/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.StatueBlockTile;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public class StatueEntityModel
extends Model {
    public final ModelPart head;
    public final ModelPart hat;
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart leftSleeve;
    public final ModelPart rightSleeve;
    public final ModelPart leftPants;
    public final ModelPart rightPants;
    public final ModelPart jacket;
    private final ModelPart cloak;
    private final ModelPart ear;
    public final ModelPart rightArmS;
    public final ModelPart leftArmS;
    public final ModelPart leftSleeveS;
    public final ModelPart rightSleeveS;

    public StatueEntityModel(BlockEntityRendererProvider.Context context) {
        super(RenderType::m_110473_);
        ModelPart modelPart = context.m_173582_(ModelLayers.f_171162_);
        this.head = modelPart.m_171324_("head");
        this.hat = modelPart.m_171324_("hat");
        this.body = modelPart.m_171324_("body");
        this.rightArm = modelPart.m_171324_("right_arm");
        this.leftArm = modelPart.m_171324_("left_arm");
        this.rightLeg = modelPart.m_171324_("right_leg");
        this.leftLeg = modelPart.m_171324_("left_leg");
        this.ear = modelPart.m_171324_("ear");
        this.cloak = modelPart.m_171324_("cloak");
        this.leftSleeve = modelPart.m_171324_("left_sleeve");
        this.rightSleeve = modelPart.m_171324_("right_sleeve");
        this.leftPants = modelPart.m_171324_("left_pants");
        this.rightPants = modelPart.m_171324_("right_pants");
        this.jacket = modelPart.m_171324_("jacket");
        ModelPart modelPartSlim = context.m_173582_(ModelLayers.f_171166_);
        this.rightArmS = modelPartSlim.m_171324_("right_arm");
        this.leftArmS = modelPartSlim.m_171324_("left_arm");
        this.leftSleeveS = modelPartSlim.m_171324_("left_sleeve");
        this.rightSleeveS = modelPartSlim.m_171324_("right_sleeve");
    }

    public void renderEars(PoseStack p_228287_1_, VertexConsumer p_228287_2_, int p_228287_3_, int p_228287_4_) {
        this.ear.m_104315_(this.head);
        this.ear.f_104200_ = 0.0f;
        this.ear.f_104201_ = 0.0f;
        this.ear.m_104301_(p_228287_1_, p_228287_2_, p_228287_3_, p_228287_4_);
    }

    public void renderCloak(PoseStack p_228289_1_, VertexConsumer p_228289_2_, int p_228289_3_, int p_228289_4_) {
        this.cloak.m_104301_(p_228289_1_, p_228289_2_, p_228289_3_, p_228289_4_);
    }

    public void setupAnim(long ticks, float partialTricks, Direction dir, StatueBlockTile.StatuePose pose, boolean waving, boolean slim) {
        this.rightArmS.f_104207_ = slim;
        this.leftArmS.f_104207_ = slim;
        this.leftSleeveS.f_104207_ = slim;
        this.rightSleeveS.f_104207_ = slim;
        this.rightArm.f_104207_ = !slim;
        this.leftArm.f_104207_ = !slim;
        this.leftSleeve.f_104207_ = !slim;
        this.rightSleeve.f_104207_ = !slim;
        int d = dir.m_122421_() == Direction.AxisDirection.NEGATIVE ? -1 : 1;
        switch (pose) {
            case SWORD: {
                this.leftLeg.f_104203_ = 0.0f;
                this.rightLeg.f_104203_ = 0.0f;
                this.leftArm.f_104203_ = -1.2566371f;
                this.leftArm.f_104204_ = 0.4712389f;
                this.rightArm.f_104203_ = -1.2566371f;
                this.rightArm.f_104204_ = -0.4712389f;
                break;
            }
            case TOOL: {
                this.leftLeg.f_104203_ = 0.0f;
                this.rightLeg.f_104203_ = 0.0f;
                this.leftArm.f_104203_ = -0.9424778f;
                this.leftArm.f_104204_ = 0.4712389f;
                this.rightArm.f_104203_ = -0.9424778f;
                this.rightArm.f_104204_ = -0.4712389f;
                break;
            }
            case HOLDING: 
            case GLOBE: 
            case SEPIA_GLOBE: {
                this.leftLeg.f_104203_ = 0.0f;
                this.rightLeg.f_104203_ = 0.0f;
                this.leftArm.f_104203_ = -0.7853982f;
                this.rightArm.f_104203_ = -0.7853982f;
                this.leftArm.f_104204_ = 0.0f;
                this.rightArm.f_104204_ = 0.0f;
                break;
            }
            case STANDING: {
                this.leftLeg.f_104203_ = 0.3926991f * (float)d;
                this.rightLeg.f_104203_ = -0.3926991f * (float)d;
                this.leftArm.f_104203_ = -0.3926991f * (float)d;
                this.rightArm.f_104203_ = 0.3926991f * (float)d;
                this.leftArm.f_104204_ = 0.0f;
                this.rightArm.f_104204_ = 0.0f;
                break;
            }
            case CANDLE: {
                this.leftLeg.f_104203_ = 0.0f;
                this.rightLeg.f_104203_ = 0.0f;
                this.leftArm.f_104203_ = -0.3926991f;
                this.rightArm.f_104203_ = -0.3926991f;
                this.leftArm.f_104204_ = 0.0f;
                this.rightArm.f_104204_ = 0.0f;
            }
        }
        if (waving) {
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104203_ = (float)Math.PI;
            float f2 = ((float)Math.floorMod(ticks, 15L) + partialTricks) / 15.0f;
            this.rightArm.f_104205_ = -0.5f - 0.5f * Mth.m_14031_((float)((float)Math.PI * 2 * f2));
        } else {
            this.rightArm.f_104205_ = 0.0f;
        }
        this.hat.m_104315_(this.head);
        this.leftPants.m_104315_(this.leftLeg);
        this.rightPants.m_104315_(this.rightLeg);
        this.leftSleeve.m_104315_(this.leftArm);
        this.rightSleeve.m_104315_(this.rightArm);
        this.jacket.m_104315_(this.body);
        this.leftArmS.m_104315_(this.leftArm);
        this.rightArmS.m_104315_(this.rightArm);
        this.leftSleeveS.m_104315_(this.leftArm);
        this.rightSleeveS.m_104315_(this.rightArm);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.hat, (Object)this.leftPants, (Object)this.rightPants, (Object)this.leftSleeve, (Object)this.rightSleeve, (Object)this.jacket);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.head.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.hat.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.body.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.jacket.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.rightLeg.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leftLeg.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leftPants.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.rightPants.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.rightArmS.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leftArmS.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leftSleeveS.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.rightSleeveS.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.rightArm.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leftArm.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leftSleeve.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.rightSleeve.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }
}

