/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.dispenser;

import java.util.Collection;
import java.util.HashSet;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.BambooSpikesBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.BombsBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.EnderPearlBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FakePlayerUseItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FillFluidHolderBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FishBucketJarBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.FlintAndSteelBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.GunpowderBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.KeyBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.PancakeBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.PancakeDiscBehavior;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.ThrowableBricksBehavior;
import net.mehvahdjukaar.supplementaries.common.entities.RopeArrowEntity;
import net.mehvahdjukaar.supplementaries.common.items.DispenserMinecartItem;
import net.mehvahdjukaar.supplementaries.common.items.KeyItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class DispenserBehaviorsManager {
    public static void registerBehaviors(RegistryAccess registryAccess) {
        boolean isForge = PlatformHelper.getPlatform().isForge();
        if (!CommonConfigs.General.DISPENSERS.get().booleanValue()) {
            return;
        }
        for (SoftFluid f : registryAccess.m_175515_(SoftFluidRegistry.getRegistryKey())) {
            DispenserBehaviorsManager.registerFluidBehavior(f);
        }
        if (CommonConfigs.Building.PANCAKES_ENABLED.get().booleanValue()) {
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new PancakeBehavior(Items.f_42787_));
            if (CompatHandler.QUARK && QuarkCompat.isJukeboxModuleOn()) {
                DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.PANCAKE.get()), (DispenseItemBehavior)new PancakeDiscBehavior());
            }
        }
        if (CommonConfigs.Tweaks.ENDER_PEAR_DISPENSERS.get().booleanValue()) {
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new EnderPearlBehavior());
        }
        if (CommonConfigs.Redstone.DISPENSER_MINECART_ENABLED.get().booleanValue()) {
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.DISPENSER_MINECART_ITEM.get()), (DispenseItemBehavior)DispenserMinecartItem.DISPENSE_ITEM_BEHAVIOR);
        }
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_ENABLED.get().booleanValue()) {
            OptionalDispenseItemBehavior armorBehavior = new OptionalDispenseItemBehavior(){

                protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                    this.m_123573_(ArmorItem.m_40398_((BlockSource)source, (ItemStack)stack));
                    return stack;
                }
            };
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.ENDERMAN_SKULL_ITEM.get()), (DispenseItemBehavior)armorBehavior);
        }
        if (CommonConfigs.Functional.FODDER_ENABLED.get().booleanValue()) {
            DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.FODDER.get()));
        }
        if (CommonConfigs.Functional.SOAP_ENABLED.get().booleanValue()) {
            DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.BUBBLE_BLOCK.get()));
        }
        if (CommonConfigs.Functional.SACK_ENABLED.get().booleanValue()) {
            DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.SACK.get()));
        }
        if (CommonConfigs.Functional.JAR_ENABLED.get().booleanValue()) {
            DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.JAR_ITEM.get()));
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new DispenserHelper.AddItemToInventoryBehavior(Items.f_42572_));
        }
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FlintAndSteelBehavior(Items.f_42409_));
        if (CommonConfigs.Functional.BAMBOO_SPIKES_ENABLED.get().booleanValue()) {
            DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.BAMBOO_SPIKES_ITEM.get()));
        }
        if (CommonConfigs.Functional.TIPPED_SPIKES_ENABLED.get().booleanValue()) {
            DispenserHelper.registerPlaceBlockBehavior((ItemLike)((ItemLike)ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get()));
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new BambooSpikesBehavior(Items.f_42739_));
        }
        if (isForge) {
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FakePlayerUseItemBehavior(ModRegistry.SOAP.get()));
        }
        if (CommonConfigs.Tweaks.THROWABLE_BRICKS_ENABLED.get().booleanValue()) {
            Registry.f_122827_.m_206058_(ModTags.BRICKS).iterator().forEachRemaining(h -> DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new ThrowableBricksBehavior((Item)h.m_203334_())));
        }
        if (CommonConfigs.Tools.BOMB_ENABLED.get().booleanValue()) {
            BombsBehavior bombBehavior = new BombsBehavior();
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_ITEM.get()), (DispenseItemBehavior)bombBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_ITEM_ON.get()), (DispenseItemBehavior)bombBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_BLUE_ITEM.get()), (DispenseItemBehavior)bombBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_BLUE_ITEM_ON.get()), (DispenseItemBehavior)bombBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_SPIKY_ITEM.get()), (DispenseItemBehavior)bombBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.BOMB_SPIKY_ITEM_ON.get()), (DispenseItemBehavior)bombBehavior);
        }
        if (CommonConfigs.Tweaks.PLACEABLE_GUNPOWDER.get().booleanValue()) {
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new GunpowderBehavior(Items.f_42403_));
        }
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModRegistry.ROPE_ARROW_ITEM.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level world, Position pos, ItemStack stack) {
                    CompoundTag com = stack.m_41783_();
                    int charges = stack.m_41776_();
                    if (com != null && com.m_128441_("Damage")) {
                        charges -= com.m_128451_("Damage");
                    }
                    RopeArrowEntity arrow = new RopeArrowEntity(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), charges);
                    arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                    return arrow;
                }
            });
        }
        boolean axe = CommonConfigs.Tweaks.AXE_DISPENSER_BEHAVIORS.get();
        boolean jar = CommonConfigs.Functional.JAR_ENABLED.get();
        boolean key = CommonConfigs.isEnabled("key");
        if (axe || jar || key) {
            for (Item i : Registry.f_122827_) {
                try {
                    if (jar && BucketHelper.isFishBucket(i)) {
                        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FishBucketJarBehavior(i));
                    }
                    if (isForge && axe && i instanceof AxeItem) {
                        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FakePlayerUseItemBehavior(i));
                    }
                    if (!key || !(i instanceof KeyItem)) continue;
                    DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new KeyBehavior(i));
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.warn("Error white registering dispenser behavior for item {}: {}", (Object)i, (Object)e);
                }
            }
        }
    }

    public static void registerFluidBehavior(SoftFluid f) {
        HashSet<Item> itemSet = new HashSet<Item>();
        Collection categories = f.getContainerList().getCategories();
        for (FluidContainerList.Category c : categories) {
            Item empty = c.getEmptyContainer();
            if (empty != Items.f_41852_ && !itemSet.contains(empty)) {
                DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FillFluidHolderBehavior(empty));
                itemSet.add(empty);
            }
            for (Item full : c.getFilledItems()) {
                if (full == Items.f_41852_ || itemSet.contains(full)) continue;
                DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FillFluidHolderBehavior(full));
                itemSet.add(full);
            }
        }
    }
}

