/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetTileSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetTileTarget;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import org.jetbrains.annotations.Nullable;

class BrewingStandInteraction
implements IFaucetTileSource,
IFaucetTileTarget {
    BrewingStandInteraction() {
    }

    @Override
    public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile, Direction dir, @Nullable FaucetBlockTile.FillAction fillAction) {
        if (tile instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)tile;
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = brewingStand.m_8020_(i);
                if (faucetTank.tryDrainItem(stack, level, pos, true, false) == null) continue;
                ItemStack empty = faucetTank.tryDrainItem(stack, level, pos, false, false);
                faucetTank.setCount(2);
                if (fillAction == null) {
                    return InteractionResult.CONSUME;
                }
                if (!fillAction.tryExecute()) continue;
                brewingStand.m_6836_(i, empty.m_41777_());
                tile.m_6596_();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockEntity tile) {
        if (tile instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)tile;
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = brewingStand.m_8020_(i);
                ItemStack result = faucetTank.tryFillingItem(stack.m_41720_(), level, pos, false, false);
                if (result == null) continue;
                brewingStand.m_6836_(i, result.m_41777_());
                tile.m_6596_();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

