/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_markers.markers;

import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.ColoredDecoration;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.ModMapMarkers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;

public abstract class ColoredMarker
extends MapBlockMarker<ColoredDecoration> {
    private DyeColor color = DyeColor.WHITE;

    protected ColoredMarker(MapDecorationType<ColoredDecoration, ?> type) {
        super(type);
    }

    protected ColoredMarker(MapDecorationType<?, ?> type, BlockPos pos, DyeColor color, @Nullable Component name) {
        super(ModMapMarkers.FLAG_DECORATION_TYPE);
        this.color = color;
        this.setName(name);
        this.setPos(pos);
    }

    public CompoundTag saveToNBT(CompoundTag compound) {
        super.saveToNBT(compound);
        compound.m_128359_("Color", this.color.m_41065_());
        return compound;
    }

    public void loadFromNBT(CompoundTag compound) {
        super.loadFromNBT(compound);
        this.color = DyeColor.m_41057_((String)compound.m_128461_("Color"), (DyeColor)DyeColor.WHITE);
    }

    @Nullable
    public ColoredDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new ColoredDecoration(this.getType(), mapX, mapY, rot, this.getName(), this.color);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && ((Object)((Object)this)).getClass() == other.getClass()) {
            ColoredMarker marker = (ColoredMarker)((Object)other);
            return Objects.equals(this.getPos(), marker.getPos()) && this.color == marker.color && Objects.equals(marker.getName(), this.getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPos(), this.getName(), this.color);
    }
}

