/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.model;

import com.github.alexthe666.alexsmobs.entity.EntitySnowLeopard;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;

public class ModelSnowLeopard
extends AdvancedEntityModel<EntitySnowLeopard> {
    private final AdvancedModelBox root;
    private final AdvancedModelBox body;
    private final AdvancedModelBox tail1;
    private final AdvancedModelBox tail2;
    private final AdvancedModelBox tail3;
    private final AdvancedModelBox leg_front_left;
    private final AdvancedModelBox leg_front_right;
    private final AdvancedModelBox leg_back_left;
    private final AdvancedModelBox leg_back_right;
    private final AdvancedModelBox neck;
    private final AdvancedModelBox head;
    private final AdvancedModelBox whisker_left;
    private final AdvancedModelBox whisker_right;
    private final AdvancedModelBox ear_left;
    private final AdvancedModelBox ear_right;
    private final AdvancedModelBox snout;
    private ModelAnimator animator;

    public ModelSnowLeopard() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this, "root");
        this.root.setPos(0.0f, 24.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this, "body");
        this.body.setPos(0.0f, -11.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.body);
        this.body.setTextureOffset(0, 32).addBox(-4.5f, 2.0f, -11.0f, 9.0f, 2.0f, 22.0f, 0.0f, false);
        this.body.setTextureOffset(0, 0).addBox(-4.5f, -7.0f, -11.0f, 9.0f, 9.0f, 22.0f, 0.0f, false);
        this.tail1 = new AdvancedModelBox((AdvancedEntityModel)this, "tail1");
        this.tail1.setPos(0.0f, -6.5f, 11.0f);
        this.body.addChild((BasicModelPart)this.tail1);
        this.setRotationAngle(this.tail1, -0.9599f, 0.0f, 0.0f);
        this.tail1.setTextureOffset(41, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 17.0f, 0.0f, false);
        this.tail2 = new AdvancedModelBox((AdvancedEntityModel)this, "tail2");
        this.tail2.setPos(0.0f, 2.9f, 17.0f);
        this.tail1.addChild((BasicModelPart)this.tail2);
        this.setRotationAngle(this.tail2, 0.7854f, 0.0f, 0.0f);
        this.tail2.setTextureOffset(52, 52).addBox(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 11.0f, 0.1f, false);
        this.tail3 = new AdvancedModelBox((AdvancedEntityModel)this, "tail3");
        this.tail3.setPos(0.0f, -0.2f, 11.1f);
        this.tail2.addChild((BasicModelPart)this.tail3);
        this.setRotationAngle(this.tail3, 0.6545f, 0.0f, 0.0f);
        this.tail3.setTextureOffset(41, 32).addBox(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 11.0f, 0.2f, false);
        this.leg_front_left = new AdvancedModelBox((AdvancedEntityModel)this, "leg_front_left");
        this.leg_front_left.setPos(3.0f, 1.0f, -8.0f);
        this.body.addChild((BasicModelPart)this.leg_front_left);
        this.leg_front_left.setTextureOffset(0, 32).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 13.0f, 4.0f, 0.0f, false);
        this.leg_front_right = new AdvancedModelBox((AdvancedEntityModel)this, "leg_front_right");
        this.leg_front_right.setPos(-3.0f, 1.0f, -8.0f);
        this.body.addChild((BasicModelPart)this.leg_front_right);
        this.leg_front_right.setTextureOffset(0, 32).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 13.0f, 4.0f, 0.0f, true);
        this.leg_back_left = new AdvancedModelBox((AdvancedEntityModel)this, "leg_back_left");
        this.leg_back_left.setPos(3.0f, 0.0f, 8.0f);
        this.body.addChild((BasicModelPart)this.leg_back_left);
        this.leg_back_left.setTextureOffset(0, 0).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 14.0f, 4.0f, 0.0f, false);
        this.leg_back_right = new AdvancedModelBox((AdvancedEntityModel)this, "leg_back_right");
        this.leg_back_right.setPos(-3.0f, 0.0f, 8.0f);
        this.body.addChild((BasicModelPart)this.leg_back_right);
        this.leg_back_right.setTextureOffset(0, 0).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 14.0f, 4.0f, 0.0f, true);
        this.neck = new AdvancedModelBox((AdvancedEntityModel)this, "neck");
        this.neck.setPos(0.0f, -4.0f, -11.0f);
        this.body.addChild((BasicModelPart)this.neck);
        this.setRotationAngle(this.neck, -0.3054f, 0.0f, 0.0f);
        this.neck.setTextureOffset(27, 57).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 7.0f, 5.0f, 0.1f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this, "head");
        this.head.setPos(0.0f, 0.1f, -3.1f);
        this.neck.addChild((BasicModelPart)this.head);
        this.setRotationAngle(this.head, 0.3054f, 0.0f, 0.0f);
        this.head.setTextureOffset(0, 57).addBox(-3.0f, -3.0f, -6.0f, 6.0f, 6.0f, 7.0f, 0.0f, false);
        this.whisker_left = new AdvancedModelBox((AdvancedEntityModel)this, "whisker_left");
        this.whisker_left.setPos(3.0f, 2.0f, -4.0f);
        this.head.addChild((BasicModelPart)this.whisker_left);
        this.setRotationAngle(this.whisker_left, 0.0f, -0.8727f, 0.0f);
        this.whisker_left.setTextureOffset(17, 17).addBox(0.0f, -3.0f, 0.0f, 2.0f, 4.0f, 0.0f, 0.0f, false);
        this.whisker_right = new AdvancedModelBox((AdvancedEntityModel)this, "whisker_right");
        this.whisker_right.setPos(-3.0f, 2.0f, -4.0f);
        this.head.addChild((BasicModelPart)this.whisker_right);
        this.setRotationAngle(this.whisker_right, 0.0f, 0.8727f, 0.0f);
        this.whisker_right.setTextureOffset(17, 17).addBox(-2.0f, -3.0f, 0.0f, 2.0f, 4.0f, 0.0f, 0.0f, true);
        this.ear_left = new AdvancedModelBox((AdvancedEntityModel)this, "ear_left");
        this.ear_left.setPos(3.0f, -3.0f, -2.0f);
        this.head.addChild((BasicModelPart)this.ear_left);
        this.ear_left.setTextureOffset(41, 7).addBox(-1.0f, -2.0f, -2.0f, 1.0f, 2.0f, 3.0f, 0.0f, false);
        this.ear_right = new AdvancedModelBox((AdvancedEntityModel)this, "ear_right");
        this.ear_right.setPos(-3.0f, -3.0f, -2.0f);
        this.head.addChild((BasicModelPart)this.ear_right);
        this.ear_right.setTextureOffset(41, 7).addBox(0.0f, -2.0f, -2.0f, 1.0f, 2.0f, 3.0f, 0.0f, true);
        this.snout = new AdvancedModelBox((AdvancedEntityModel)this, "snout");
        this.snout.setPos(0.0f, 0.1f, -6.4f);
        this.head.addChild((BasicModelPart)this.snout);
        this.setRotationAngle(this.snout, 0.1745f, 0.0f, 0.0f);
        this.snout.setTextureOffset(41, 0).addBox(-2.0f, 0.0f, -2.2f, 4.0f, 3.0f, 3.0f, 0.0f, false);
        this.updateDefaultPose();
        this.animator = new ModelAnimator();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.whisker_left, (Object)this.whisker_right, (Object)this.snout, (Object)this.root, (Object)this.body, (Object)this.neck, (Object)this.head, (Object)this.ear_left, (Object)this.ear_right, (Object)this.leg_back_left, (Object)this.leg_back_right, (Object)this.leg_front_left, (Object[])new AdvancedModelBox[]{this.leg_front_right, this.tail1, this.tail2, this.tail3});
    }

    public void animate(IAnimatedEntity entity, float f, float f1, float f2, float f3, float f4) {
        this.resetToDefaultPose();
        this.animator.update(entity);
        this.animator.update(entity);
        this.animator.setAnimation(EntitySnowLeopard.ANIMATION_ATTACK_R);
        this.animator.startKeyframe(3);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.neck, 0.0f, (float)Math.toRadians(-10.0), (float)Math.toRadians(-10.0));
        this.animator.rotate(this.leg_front_right, (float)Math.toRadians(25.0), (float)Math.toRadians(-20.0), 0.0f);
        this.animator.move(this.leg_front_right, 0.0f, 1.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, 0.0f, 0.0f, (float)Math.toRadians(0.0));
        this.animator.rotate(this.leg_front_right, (float)Math.toRadians(-90.0), (float)Math.toRadians(-30.0), 0.0f);
        this.animator.move(this.leg_front_right, 0.0f, 1.0f, -2.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(EntitySnowLeopard.ANIMATION_ATTACK_L);
        this.animator.startKeyframe(3);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.neck, 0.0f, (float)Math.toRadians(10.0), (float)Math.toRadians(10.0));
        this.animator.rotate(this.leg_front_left, (float)Math.toRadians(25.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.move(this.leg_front_left, 0.0f, 1.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, 0.0f, 0.0f, (float)Math.toRadians(0.0));
        this.animator.rotate(this.leg_front_left, (float)Math.toRadians(-90.0), (float)Math.toRadians(30.0), 0.0f);
        this.animator.move(this.leg_front_left, 0.0f, 1.0f, -2.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    public void setupAnim(EntitySnowLeopard entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animate(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float walkSpeed = 0.7f;
        float walkDegree = 0.6f;
        float idleSpeed = 0.1f;
        float idleDegree = 0.1f;
        float runProgress = 5.0f * limbSwingAmount;
        float partialTick = Minecraft.m_91087_().m_91296_();
        float stalkProgress = entity.prevSneakProgress + (entity.sneakProgress - entity.prevSneakProgress) * partialTick;
        float tackleProgress = entity.prevTackleProgress + (entity.tackleProgress - entity.prevTackleProgress) * partialTick;
        float sitProgress = entity.prevSitProgress + (entity.sitProgress - entity.prevSitProgress) * partialTick;
        float sleepProgress = entity.prevSleepProgress + (entity.sleepProgress - entity.prevSleepProgress) * partialTick;
        float sitSleepProgress = Math.max(sitProgress, sleepProgress);
        this.swing(this.tail1, idleSpeed, idleDegree * 2.0f, false, 2.0f, 0.0f, ageInTicks, 1.0f - limbSwingAmount);
        this.swing(this.tail2, idleSpeed, idleDegree * 1.5f, false, 2.0f, 0.0f, ageInTicks, 1.0f - limbSwingAmount);
        this.flap(this.tail3, idleSpeed * 1.2f, idleDegree * 1.5f, false, 2.0f, 0.0f, ageInTicks, 1.0f - limbSwingAmount);
        this.swing(this.tail3, idleSpeed * 1.2f, idleDegree * 1.5f, false, 2.0f, 0.0f, ageInTicks, 1.0f - limbSwingAmount);
        this.walk(this.neck, idleSpeed * 0.3f, idleDegree, false, 0.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.head, idleSpeed * 0.3f, -idleDegree, false, 0.5f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.leg_front_right, walkSpeed, walkDegree * 1.1f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.bob(this.leg_front_right, walkSpeed, walkDegree, false, limbSwing, limbSwingAmount);
        this.walk(this.leg_front_left, walkSpeed, walkDegree * 1.1f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.bob(this.leg_front_left, walkSpeed, walkDegree, false, limbSwing, limbSwingAmount);
        this.walk(this.leg_back_right, walkSpeed, walkDegree * 1.1f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.bob(this.leg_back_right, walkSpeed, walkDegree, false, limbSwing, limbSwingAmount);
        this.walk(this.leg_back_left, walkSpeed, walkDegree * 1.1f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.bob(this.leg_back_left, walkSpeed, walkDegree, false, limbSwing, limbSwingAmount);
        this.bob(this.body, walkSpeed, walkDegree, false, limbSwing, limbSwingAmount);
        AdvancedModelBox[] tailBoxes = new AdvancedModelBox[]{this.tail1, this.tail2, this.tail3};
        this.chainSwing(tailBoxes, walkSpeed, walkDegree * 0.5f, -2.5, limbSwing, limbSwingAmount);
        this.progressRotationPrev(this.tail1, runProgress, (float)Math.toRadians(40.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.tail2, runProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.tail3, runProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.body, stalkProgress, (float)Math.toRadians(15.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leg_back_left, stalkProgress, (float)Math.toRadians(-15.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leg_back_right, stalkProgress, (float)Math.toRadians(-15.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leg_front_left, stalkProgress, (float)Math.toRadians(-15.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leg_front_right, stalkProgress, (float)Math.toRadians(-15.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.neck, stalkProgress, (float)Math.toRadians(5.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.head, stalkProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.tail1, stalkProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 5.0f);
        this.progressPositionPrev(this.leg_back_left, stalkProgress, 0.0f, 2.1f, 0.0f, 5.0f);
        this.progressPositionPrev(this.leg_back_right, stalkProgress, 0.0f, 2.1f, 0.0f, 5.0f);
        this.progressPositionPrev(this.leg_front_left, stalkProgress, 0.0f, -1.9f, 0.0f, 5.0f);
        this.progressPositionPrev(this.leg_front_right, stalkProgress, 0.0f, -1.9f, 0.0f, 5.0f);
        this.progressRotationPrev(this.body, tackleProgress, (float)Math.toRadians(-45.0), 0.0f, 0.0f, 3.0f);
        this.progressRotationPrev(this.neck, tackleProgress, (float)Math.toRadians(6.0), 0.0f, 0.0f, 3.0f);
        this.progressRotationPrev(this.head, tackleProgress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 3.0f);
        this.progressRotationPrev(this.tail1, tackleProgress, (float)Math.toRadians(80.0), 0.0f, 0.0f, 3.0f);
        this.progressRotationPrev(this.leg_front_right, tackleProgress, (float)Math.toRadians(-25.0), 0.0f, (float)Math.toRadians(45.0), 3.0f);
        this.progressRotationPrev(this.leg_front_left, tackleProgress, (float)Math.toRadians(-25.0), 0.0f, (float)Math.toRadians(-45.0), 3.0f);
        this.progressRotationPrev(this.leg_back_left, tackleProgress, (float)Math.toRadians(-15.0), 0.0f, (float)Math.toRadians(-25.0), 3.0f);
        this.progressRotationPrev(this.leg_back_right, tackleProgress, (float)Math.toRadians(-15.0), 0.0f, (float)Math.toRadians(25.0), 3.0f);
        this.progressPositionPrev(this.body, tackleProgress, 0.0f, -5.0f, 0.0f, 3.0f);
        this.progressPositionPrev(this.leg_front_left, tackleProgress, 1.0f, 2.0f, 0.0f, 3.0f);
        this.progressPositionPrev(this.leg_front_right, tackleProgress, -1.0f, 2.0f, 0.0f, 3.0f);
        this.progressPositionPrev(this.tail1, tackleProgress, 0.0f, 0.0f, -1.0f, 3.0f);
        float tailAngle = entity.m_19879_() % 2 == 0 ? 1.0f : -1.0f;
        this.progressRotationPrev(this.leg_back_left, sitSleepProgress, (float)Math.toRadians(-90.0), (float)Math.toRadians(-20.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.leg_back_right, sitSleepProgress, (float)Math.toRadians(-90.0), (float)Math.toRadians(20.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.leg_front_left, sitSleepProgress, (float)Math.toRadians(-90.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leg_front_right, sitSleepProgress, (float)Math.toRadians(-90.0), 0.0f, 0.0f, 5.0f);
        this.progressPositionPrev(this.body, sitSleepProgress, 0.0f, 5.0f, 0.0f, 5.0f);
        this.progressPositionPrev(this.leg_front_right, sitSleepProgress, 0.0f, 2.0f, 0.0f, 5.0f);
        this.progressPositionPrev(this.leg_front_left, sitSleepProgress, 0.0f, 2.0f, 0.0f, 5.0f);
        this.progressPositionPrev(this.leg_back_right, sitSleepProgress, 0.0f, 2.8f, -0.5f, 5.0f);
        this.progressPositionPrev(this.leg_back_left, sitSleepProgress, 0.0f, 2.8f, -0.5f, 5.0f);
        this.progressRotationPrev(this.tail1, sitProgress, (float)Math.toRadians(20.0), (float)Math.toRadians(tailAngle * 30.0f), 0.0f, 5.0f);
        this.progressRotationPrev(this.tail2, sitProgress, (float)Math.toRadians(-5.0), (float)Math.toRadians(tailAngle * 50.0f), 0.0f, 5.0f);
        this.progressRotationPrev(this.tail3, sitProgress, (float)Math.toRadians(10.0), (float)Math.toRadians(tailAngle * 20.0f), (float)Math.toRadians(tailAngle * 20.0f), 5.0f);
        this.progressRotationPrev(this.neck, sleepProgress, (float)Math.toRadians(20.0), tailAngle * (float)Math.toRadians(50.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.head, sleepProgress, (float)Math.toRadians(5.0), tailAngle * (float)Math.toRadians(20.0), 0.0f, 5.0f);
        this.progressPositionPrev(this.head, sleepProgress, tailAngle * 0.5f, -1.0f, 1.0f, 5.0f);
        this.progressPositionPrev(this.neck, sleepProgress, 0.0f, 1.0f, -1.0f, 5.0f);
        this.progressRotationPrev(this.tail1, sleepProgress, (float)Math.toRadians(20.0), (float)Math.toRadians(tailAngle * -60.0f), 0.0f, 5.0f);
        this.progressRotationPrev(this.tail2, sleepProgress, (float)Math.toRadians(10.0), (float)Math.toRadians(tailAngle * -70.0f), (float)Math.toRadians(tailAngle * -50.0f), 5.0f);
        this.progressRotationPrev(this.tail3, sleepProgress, (float)Math.toRadians(-30.0), (float)Math.toRadians(tailAngle * -50.0f), (float)Math.toRadians(tailAngle * -30.0f), 5.0f);
        if (sleepProgress <= 0.0f) {
            this.faceTarget(netHeadYaw, headPitch, 2.0f, new AdvancedModelBox[]{this.neck, this.head});
        }
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            float f = 1.45f;
            this.head.setScale(f, f, f);
            this.head.setShouldScaleChildren(true);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStackIn.m_85837_(0.0, 1.5, 0.0);
            this.parts().forEach(p_228292_8_ -> p_228292_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
            this.head.setScale(1.0f, 1.0f, 1.0f);
        } else {
            matrixStackIn.m_85836_();
            this.parts().forEach(p_228290_8_ -> p_228290_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
        }
    }

    public void setRotationAngle(AdvancedModelBox AdvancedModelBox2, float x, float y, float z) {
        AdvancedModelBox2.rotateAngleX = x;
        AdvancedModelBox2.rotateAngleY = y;
        AdvancedModelBox2.rotateAngleZ = z;
    }
}

