/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.data.ModLanguageProvider;
import fuzs.easyanvils.handler.ItemInteractionHandler;
import fuzs.easyanvils.init.ForgeModRegistry;
import fuzs.puzzleslib.core.CommonFactories;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="easyanvils")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EasyAnvilsForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CommonFactories.INSTANCE.modConstructor("easyanvils").accept(new EasyAnvils());
        ForgeModRegistry.touch();
        EasyAnvilsForge.registerHandlers();
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> ItemInteractionHandler.onRightClickItem(evt.getLevel(), evt.getEntity(), evt.getHand()).ifPresent(result -> {
            evt.setCancellationResult(result.m_19089_());
            evt.setCanceled(true);
        }));
        MinecraftForge.EVENT_BUS.addListener(evt -> ItemInteractionHandler.onRightClickBlock(evt.getLevel(), evt.getEntity(), evt.getHand(), evt.getHitVec()).ifPresent(result -> {
            evt.setCancellationResult(result);
            evt.setCanceled(true);
        }));
        MinecraftForge.EVENT_BUS.addListener(evt -> ItemInteractionHandler.onAnvilRepair(evt.getEntity(), evt.getLeft(), evt.getRight(), evt.getOutput(), evt.getBreakChance()).ifPresent(breakChance -> evt.setBreakChance((float)breakChance)));
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        ExistingFileHelper existingFileHelper = evt.getExistingFileHelper();
        generator.m_236039_(true, (DataProvider)new ModLanguageProvider(generator, "easyanvils"));
    }
}

