/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.gui.components;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fuzs.easyanvils.client.gui.components.TypeActionManager;
import fuzs.easyanvils.util.ComponentDecomposer;
import fuzs.easyanvils.util.FormattedStringDecomposer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class OpenEditBox
extends EditBox {
    private final Font font;
    String f_94093_ = "";
    private int maxLength = 32;
    private int frame;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    int f_94100_;
    int f_94101_;
    int f_94102_;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private String suggestion;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, FormattedCharSequence> formatter = (formatterValue, position) -> {
        ArrayList list = Lists.newArrayList();
        FormattedStringDecomposer.LengthLimitedCharSink sink = new FormattedStringDecomposer.LengthLimitedCharSink(formatterValue.length(), (int)position);
        FormattedStringDecomposer.iterateFormatted(this.f_94093_, Style.f_131099_, (index, style, j) -> {
            if (sink.m_6411_(index, style, j)) {
                list.add(formattedCharSink -> formattedCharSink.m_6411_(index, style, j));
            }
            return true;
        });
        return FormattedCharSequence.m_13722_((List)list);
    };
    private long lastClickTime;
    private int lastClickButton;
    private boolean doubleClick;
    public TypeActionManager typeActionManager = new TypeActionManager();

    public OpenEditBox(Font font, int i, int j, int k, int l, Component component) {
        this(font, i, j, k, l, null, component);
    }

    public OpenEditBox(Font font, int i, int j, int k, int l, @Nullable OpenEditBox editBox, Component component) {
        super(font, i, j, k, l, (EditBox)editBox, component);
        this.font = font;
        if (editBox != null) {
            this.m_94144_(editBox.m_94155_());
        }
    }

    public void m_94151_(Consumer<String> responder) {
        this.responder = responder;
    }

    public void m_94149_(BiFunction<String, Integer, FormattedCharSequence> textFormatter) {
        this.formatter = textFormatter;
    }

    public void m_94120_() {
        ++this.frame;
    }

    protected MutableComponent m_5646_() {
        Component component = this.m_6035_();
        return Component.m_237110_((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.f_94093_});
    }

    public void m_94144_(String text) {
        if (this.filter.test(text)) {
            int aboveMaxLength = ComponentDecomposer.getStringLength(text) - this.maxLength;
            this.f_94093_ = aboveMaxLength > 0 ? ComponentDecomposer.removeLast(text, aboveMaxLength) : text;
            this.m_94201_();
            this.m_94208_(this.f_94101_);
            this.onValueChange(text);
        }
    }

    public String m_94155_() {
        return this.f_94093_;
    }

    public String m_94173_() {
        int i = Math.min(this.f_94101_, this.f_94102_);
        int j = Math.max(this.f_94101_, this.f_94102_);
        return this.f_94093_.substring(i, j);
    }

    public boolean hasHighlighted() {
        return this.f_94102_ != this.f_94101_;
    }

    public void m_94153_(Predicate<String> validator) {
        this.filter = validator;
    }

    public void m_94164_(String textToWrite) {
        String string2;
        String string;
        int j;
        int i = Math.min(this.f_94101_, this.f_94102_);
        String string3 = new StringBuilder(this.f_94093_).replace(i, j = Math.max(this.f_94101_, this.f_94102_), string = FormattedStringDecomposer.filterText(textToWrite)).toString();
        int stringLength = ComponentDecomposer.getStringLength(string3) - this.maxLength;
        if (stringLength > 0) {
            string = ComponentDecomposer.removeLast(textToWrite, stringLength);
        }
        if (this.filter.test(string2 = new StringBuilder(this.f_94093_).replace(i, j, string).toString())) {
            this.f_94093_ = string2;
            int l = string.length();
            this.m_94196_(i + l);
            this.m_94208_(this.f_94101_);
            this.onValueChange(this.f_94093_);
        }
    }

    private void onValueChange(String newText) {
        this.typeActionManager.trySave(this);
        if (this.responder != null) {
            this.responder.accept(newText);
        }
    }

    private void deleteText(int count) {
        if (Screen.m_96637_()) {
            this.m_94180_(this.f_94101_);
        } else if (Screen.m_96639_()) {
            this.m_94176_(count);
        } else {
            this.m_94180_(count);
        }
    }

    public void m_94176_(int num) {
        if (!this.f_94093_.isEmpty()) {
            if (this.f_94102_ != this.f_94101_) {
                this.m_94164_("");
            } else {
                this.m_94180_(this.m_94184_(num) - this.f_94101_);
            }
        }
    }

    public void m_94180_(int num) {
        if (!this.f_94093_.isEmpty()) {
            if (this.f_94102_ != this.f_94101_) {
                this.m_94164_("");
            } else {
                String string;
                int k;
                int i = this.getCursorPos(num);
                int j = Math.min(i, this.f_94101_);
                if (j != (k = Math.max(i, this.f_94101_)) && this.filter.test(string = new StringBuilder(this.f_94093_).delete(j, k).toString())) {
                    this.f_94093_ = string;
                    this.m_94192_(j);
                }
            }
        }
    }

    public int m_94184_(int numWords) {
        return this.getWordPosition(numWords, this.m_94207_());
    }

    private int getWordPosition(int n, int pos) {
        return this.getWordPosition(n, pos, true);
    }

    private int getWordPosition(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean backwards = n < 0;
        int skippedWords = Math.abs(n);
        for (int k = 0; k < skippedWords; ++k) {
            if (!backwards) {
                int l = this.f_94093_.length();
                while (skipWs && i == pos && i < l && this.f_94093_.charAt(i) == ' ') {
                    ++i;
                    ++pos;
                }
                while (i < l && this.f_94093_.charAt(i) != ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i == pos && i > 0 && this.f_94093_.charAt(i - 1) == ' ') {
                --i;
                --pos;
            }
            while (i > 0 && this.f_94093_.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void m_94188_(int delta) {
        this.m_94192_(this.getCursorPos(delta));
    }

    private int getCursorPos(int delta) {
        return Util.m_137479_((String)this.f_94093_, (int)this.f_94101_, (int)delta);
    }

    public void m_94192_(int pos) {
        this.m_94196_(pos);
        if (!this.shiftPressed) {
            this.m_94208_(this.f_94101_);
        }
        this.onValueChange(this.f_94093_);
    }

    public void m_94196_(int pos) {
        this.f_94101_ = Mth.m_14045_((int)pos, (int)0, (int)this.f_94093_.length());
        this.setDisplayPosition(this.f_94101_);
    }

    public void m_94198_() {
        this.m_94192_(0);
    }

    public void m_94201_() {
        this.m_94192_(this.f_94093_.length());
    }

    public static boolean isUndo(int keyCode) {
        return keyCode == 89 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    public static boolean isRedo(int keyCode) {
        return keyCode == 89 && Screen.m_96637_() && Screen.m_96638_() && !Screen.m_96639_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.m_94204_()) {
            return false;
        }
        this.shiftPressed = Screen.m_96638_();
        if (Screen.m_96634_((int)keyCode)) {
            this.m_94201_();
            this.m_94208_(0);
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.m_94173_());
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.isEditable) {
                this.m_94164_(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.m_94173_());
            if (this.isEditable) {
                this.m_94164_("");
            }
            return true;
        }
        if (OpenEditBox.isUndo(keyCode)) {
            this.typeActionManager.undo(this);
            return true;
        }
        if (OpenEditBox.isRedo(keyCode)) {
            this.typeActionManager.redo(this);
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            case 262: {
                boolean canMove = true;
                if (!this.shiftPressed && this.hasHighlighted()) {
                    this.m_94196_(Math.max(this.m_94207_(), this.f_94102_));
                    this.m_94208_(this.m_94207_());
                    canMove = false;
                }
                if (Screen.m_96637_()) {
                    this.m_94201_();
                } else if (Screen.m_96639_()) {
                    this.m_94192_(this.m_94184_(1));
                } else if (canMove) {
                    this.m_94188_(1);
                }
                return true;
            }
            case 263: {
                boolean canMove = true;
                if (!this.shiftPressed && this.hasHighlighted()) {
                    this.m_94196_(Math.min(this.m_94207_(), this.f_94102_));
                    this.m_94208_(this.m_94207_());
                    canMove = false;
                }
                if (Screen.m_96637_()) {
                    this.m_94198_();
                } else if (Screen.m_96639_()) {
                    this.m_94192_(this.m_94184_(-1));
                } else if (canMove) {
                    this.m_94188_(-1);
                }
                return true;
            }
            case 268: {
                this.m_94198_();
                return true;
            }
            case 269: 
        }
        this.m_94201_();
        return true;
    }

    public boolean m_94204_() {
        return this.m_94213_() && this.m_93696_() && this.isEditable();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (!this.m_94204_()) {
            return false;
        }
        if (FormattedStringDecomposer.isAllowedChatCharacter(codePoint)) {
            if (this.isEditable) {
                this.m_94164_(Character.toString(codePoint));
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean bl;
        if (!this.m_94213_()) {
            return false;
        }
        boolean bl2 = bl = mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_);
        if (this.canLoseFocus) {
            this.m_94178_(bl);
        }
        if (this.m_93696_() && bl) {
            if (button == 0) {
                int i = Mth.m_14107_((double)mouseX) - this.f_93620_;
                if (this.bordered) {
                    i -= 4;
                }
                this.shiftPressed = Screen.m_96638_();
                String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.f_94093_, this.f_94100_, this.m_94210_(), Style.f_131099_);
                this.m_94192_(FormattedStringDecomposer.plainHeadByWidth(this.font, string, 0, i, Style.f_131099_).length() + this.f_94100_);
                long millis = Util.m_137550_();
                boolean tripleClick = this.doubleClick;
                boolean bl3 = this.doubleClick = millis - this.lastClickTime < 250L && this.lastClickButton == button;
                if (tripleClick &= this.doubleClick) {
                    this.m_94201_();
                    this.m_94208_(0);
                } else if (this.doubleClick) {
                    this.shiftPressed = false;
                    this.m_94192_(this.getWordPosition(1, this.m_94207_(), false));
                    this.shiftPressed = true;
                    this.m_94192_(this.getWordPosition(-1, this.m_94207_(), false));
                    this.shiftPressed = Screen.m_96638_();
                }
                this.lastClickTime = millis;
                this.lastClickButton = button;
                return true;
            }
            if (button == 1) {
                this.m_94144_("");
            }
            return false;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean bl;
        if (!this.m_94213_()) {
            return false;
        }
        boolean bl2 = bl = mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_);
        if (this.m_93696_() && bl && button == 0) {
            int i = Mth.m_14107_((double)mouseX) - this.f_93620_;
            if (this.bordered) {
                i -= 4;
            }
            this.shiftPressed = true;
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.f_94093_, this.f_94100_, this.m_94210_(), Style.f_131099_);
            this.m_94192_(FormattedStringDecomposer.plainHeadByWidth(this.font, string, 0, i, Style.f_131099_).length() + this.f_94100_);
            this.shiftPressed = Screen.m_96638_();
            return true;
        }
        return false;
    }

    public void m_94178_(boolean isFocused) {
        this.m_93692_(isFocused);
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.m_94213_()) {
            int i;
            if (this.isBordered()) {
                i = this.m_93696_() ? -1 : -6250336;
                OpenEditBox.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (int)(this.f_93620_ + this.f_93618_ + 1), (int)(this.f_93621_ + this.f_93619_ + 1), (int)i);
                OpenEditBox.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-16777216);
            }
            i = this.isEditable ? this.textColor : this.textColorUneditable;
            int j = this.f_94101_ - this.f_94100_;
            int k = this.f_94102_ - this.f_94100_;
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.f_94093_, this.f_94100_, this.m_94210_(), Style.f_131099_);
            boolean bl = j >= 0 && j <= string.length();
            boolean bl2 = this.m_93696_() && this.frame / 6 % 2 == 0 && bl;
            int l = this.bordered ? this.f_93620_ + 4 : this.f_93620_;
            int m = this.bordered ? this.f_93621_ + (this.f_93619_ - 8) / 2 : this.f_93621_;
            int n = l;
            if (k > string.length()) {
                k = string.length();
            }
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, j) : string;
                n = this.font.m_92744_(poseStack, this.formatter.apply(string2, this.f_94100_), (float)l, (float)m, i);
            }
            boolean bl3 = this.f_94101_ < this.f_94093_.length() || ComponentDecomposer.getStringLength(this.f_94093_) >= this.getMaxLength();
            int o = n;
            if (!bl) {
                o = j > 0 ? l + this.f_93618_ : l;
            } else if (!string.isEmpty()) {
                o = n - 1;
                --n;
            }
            if (!string.isEmpty() && bl && j < string.length()) {
                this.font.m_92744_(poseStack, this.formatter.apply(string.substring(j), this.f_94101_), (float)n, (float)m, i);
            }
            if (!bl3 && this.suggestion != null) {
                this.font.m_92750_(poseStack, this.suggestion, (float)(o - 1), (float)m, -8355712);
            }
            if (bl2 && k == j) {
                if (!string.isEmpty()) {
                    GuiComponent.m_93172_((PoseStack)poseStack, (int)o, (int)(m - 1), (int)(o + 1), (int)(m + 1 + 9), (int)-3092272);
                } else {
                    this.font.m_92750_(poseStack, "_", (float)o, (float)m, i);
                }
            }
            if (k != j) {
                int p = l + FormattedStringDecomposer.stringWidth(this.font, this.f_94093_.substring(0, this.f_94102_), this.f_94100_);
                this.renderHighlight(o, m - 1, p - 1, m + 1 + 9);
            }
        }
    }

    private void renderHighlight(int startX, int startY, int endX, int endY) {
        int i;
        if (startX < endX) {
            i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            i = startY;
            startY = endY;
            endY = i;
        }
        if (endX > this.f_93620_ + this.f_93618_) {
            endX = this.f_93620_ + this.f_93618_;
        }
        if (startX > this.f_93620_ + this.f_93618_) {
            startX = this.f_93620_ + this.f_93618_;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferBuilder.m_5483_((double)startX, (double)endY, 0.0).m_5752_();
        bufferBuilder.m_5483_((double)endX, (double)endY, 0.0).m_5752_();
        bufferBuilder.m_5483_((double)endX, (double)startY, 0.0).m_5752_();
        bufferBuilder.m_5483_((double)startX, (double)startY, 0.0).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }

    public void m_94199_(int length) {
        this.maxLength = length;
        if (this.f_94093_.length() > length) {
            this.f_94093_ = this.f_94093_.substring(0, length);
            this.onValueChange(this.f_94093_);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int m_94207_() {
        return this.f_94101_;
    }

    private boolean isBordered() {
        return this.bordered;
    }

    public void m_94182_(boolean enableBackgroundDrawing) {
        this.bordered = enableBackgroundDrawing;
    }

    public void m_94202_(int color) {
        this.textColor = color;
    }

    public void m_94205_(int color) {
        this.textColorUneditable = color;
    }

    public boolean m_5755_(boolean focus) {
        return this.f_93624_ && this.isEditable ? super.m_5755_(focus) : false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_);
    }

    protected void m_7207_(boolean focused) {
        if (focused) {
            this.frame = 0;
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void m_94186_(boolean enabled) {
        this.isEditable = enabled;
    }

    public int m_94210_() {
        return this.isBordered() ? this.f_93618_ - 8 : this.f_93618_;
    }

    public void m_94208_(int position) {
        this.f_94102_ = Mth.m_14045_((int)position, (int)0, (int)this.f_94093_.length());
    }

    public void setDisplayPosition(int position) {
        if (this.font != null) {
            int i = this.f_94093_.length();
            if (this.f_94100_ > i) {
                this.f_94100_ = i;
            }
            int j = this.m_94210_();
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.f_94093_, this.f_94100_, j, Style.f_131099_);
            int k = string.length() + this.f_94100_;
            if (position == this.f_94100_) {
                this.f_94100_ -= FormattedStringDecomposer.plainTailByWidth(this.font, this.f_94093_, j, Style.f_131099_).length();
            }
            if (position > k) {
                this.f_94100_ += position - k;
            } else if (position <= this.f_94100_) {
                this.f_94100_ -= this.f_94100_ - position;
            }
            this.f_94100_ = Mth.m_14045_((int)this.f_94100_, (int)0, (int)i);
        }
    }

    public void m_94190_(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public boolean m_94213_() {
        return this.f_93624_;
    }

    public void m_94194_(boolean isVisible) {
        this.f_93624_ = isVisible;
    }

    public void m_94167_(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public int m_94211_(int charNum) {
        return charNum > this.f_94093_.length() ? this.f_93620_ : this.f_93620_ + FormattedStringDecomposer.stringWidth(this.font, this.f_94093_.substring(0, charNum), 0);
    }

    public void m_94214_(int x) {
        this.f_93620_ = x;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.edit_box", (Object[])new Object[]{this.m_94155_()}));
    }
}

