/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.StringDecomposer;
import org.jetbrains.annotations.Nullable;

public class ComponentDecomposer {
    private static final Style EMPTY = Style.f_131099_.m_178520_(ChatFormatting.WHITE.m_126665_().intValue()).m_131136_(Boolean.valueOf(false)).m_131155_(Boolean.valueOf(false)).m_131162_(Boolean.valueOf(false)).m_178522_(Boolean.valueOf(false)).m_178524_(Boolean.valueOf(false));

    public static String toFormattedString(Component component) {
        StringBuilder builder = new StringBuilder();
        component.m_7451_((style, string) -> {
            builder.append(ComponentDecomposer.applyLegacyFormatting(string, style));
            return Optional.empty();
        }, Style.f_131099_);
        return builder.toString();
    }

    private static String applyLegacyFormatting(String string, Style style) {
        return ComponentDecomposer.toLegacyFormatting(style).stream().map(ChatFormatting::toString).reduce(String::concat).map(formattings -> formattings.concat(string).concat(ChatFormatting.RESET.toString())).orElse(string);
    }

    private static List<ChatFormatting> toLegacyFormatting(Style style) {
        ChatFormatting chatFormatting;
        ArrayList formattings = Lists.newArrayList();
        if (style.m_131179_()) {
            return formattings;
        }
        TextColor textColor = style.m_131135_();
        if (textColor != null && (chatFormatting = ChatFormatting.m_126657_((String)textColor.toString())) != null) {
            formattings.add(chatFormatting);
        }
        if (style.m_131154_()) {
            formattings.add(ChatFormatting.BOLD);
        }
        if (style.m_131161_()) {
            formattings.add(ChatFormatting.ITALIC);
        }
        if (style.m_131171_()) {
            formattings.add(ChatFormatting.UNDERLINE);
        }
        if (style.m_131168_()) {
            formattings.add(ChatFormatting.STRIKETHROUGH);
        }
        if (style.m_131176_()) {
            formattings.add(ChatFormatting.OBFUSCATED);
        }
        return ImmutableList.copyOf((Collection)formattings);
    }

    public static Component toFormattedComponent(@Nullable String value) {
        return (Component)ComponentDecomposer.toComponentEntries(value).stream().map(entry -> Component.m_237113_((String)entry.string().get()).m_130948_(entry.style())).reduce(MutableComponent::m_7220_).orElse(Component.m_237119_());
    }

    public static String removeLast(@Nullable String value, int amount) {
        Deque<ComponentEntry> componentEntries = ComponentDecomposer.toComponentEntries(value);
        for (int i = 0; i < amount; ++i) {
            ComponentEntry componentEntry = componentEntries.peekLast();
            if (componentEntry == null) continue;
            if (!componentEntry.string().get().isEmpty()) {
                componentEntry.string().updateAndGet(s -> s.substring(0, s.length() - 1));
            }
            if (!componentEntry.string().get().isEmpty()) continue;
            componentEntries.pollLast();
        }
        return componentEntries.stream().map(entry -> ComponentDecomposer.applyLegacyFormatting(entry.string().get(), entry.style())).collect(Collectors.joining());
    }

    private static Deque<ComponentEntry> toComponentEntries(@Nullable String value) {
        LinkedList values = Lists.newLinkedList();
        if (value == null) {
            return values;
        }
        StringDecomposer.m_14346_((String)value, (Style)EMPTY, (i, style, j) -> {
            ComponentEntry last = (ComponentEntry)values.peekLast();
            if (last != null && last.style().equals((Object)style)) {
                last.string().updateAndGet(s -> s + Character.toString(j));
            } else {
                values.offerLast(new ComponentEntry(new AtomicReference<String>(Character.toString(j)), style));
            }
            return true;
        });
        return values;
    }

    public static int getStringLength(String value) {
        return ComponentDecomposer.toFormattedComponent(value).getString().length();
    }

    private record ComponentEntry(AtomicReference<String> string, Style style) {
    }
}

