/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.patch.impl.game;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.patch.Patch;

public class IntelPatch
extends Patch {
    public IntelPatch() {
        super("intel", "Patches rendering on Intel", false);
    }

    public void apply(final Instrumentation inst) throws Exception {
        inst.addTransformer(new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classRedefined, ProtectionDomain domain, byte[] classfileBuffer) {
                if (className == null) {
                    return null;
                }
                CtClass clas = pool.getOrNull(className.replace('/', '.'));
                if (clas == null || className.startsWith("org/lwjgl") || clas.getDeclaredConstructors().length > 1 || clas.isFrozen()) {
                    return null;
                }
                try {
                    final boolean[] openGlHelperMatched = new boolean[1];
                    for (CtMethod glActiveTextureMethod : clas.getDeclaredMethods()) {
                        if (!Modifier.isPublic(glActiveTextureMethod.getModifiers()) || !Modifier.isStatic(glActiveTextureMethod.getModifiers()) || !"void".equals(glActiveTextureMethod.getReturnType().getName()) || glActiveTextureMethod.getParameterTypes().length != 1 || !"int".equals(glActiveTextureMethod.getParameterTypes()[0].getName())) continue;
                        glActiveTextureMethod.instrument(new ExprEditor(){

                            public void edit(MethodCall m) throws CannotCompileException {
                                if ("org.lwjgl.opengl.ARBMultitexture".equals(m.getClassName()) && "glActiveTextureARB".equals(m.getMethodName()) && "(I)V".equalsIgnoreCase(m.getSignature())) {
                                    openGlHelperMatched[0] = true;
                                    m.replace("{ org.lwjgl.opengl.ARBMultitexture.glClientActiveTextureARB($$); $_ = $proceed($$); }");
                                    LFLogger.debug("intel", "Matched ARBMultitexture.glActiveTextureARB(I)V");
                                } else if ("org.lwjgl.opengl.GL13".equals(m.getClassName()) && "glActiveTexture".equals(m.getMethodName()) && "(I)V".equalsIgnoreCase(m.getSignature())) {
                                    openGlHelperMatched[0] = true;
                                    m.replace("{ org.lwjgl.opengl.GL13.glClientActiveTexture($$); $_ = $proceed($$); }");
                                    LFLogger.debug("intel", "Matched GL13.glActiveTexture(I)V");
                                }
                            }
                        });
                        if (!openGlHelperMatched[0]) continue;
                        LFLogger.debug("intel", "Found OpenGlHelper and patched it: " + clas.getName());
                        inst.removeTransformer(this);
                        return clas.toBytecode();
                    }
                }
                catch (Throwable t) {
                    LFLogger.error("intel", t);
                }
                return null;
            }
        });
    }
}

