/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.pipes;

import earth.terrarium.adastra.common.blockentities.base.TickableBlockEntity;
import earth.terrarium.adastra.common.blockentities.pipes.Pipe;
import earth.terrarium.adastra.common.blocks.base.BasicEntityBlock;
import earth.terrarium.adastra.common.blocks.pipes.PipeBlock;
import earth.terrarium.adastra.common.config.MachineConfig;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public abstract class PipeBlockEntity
extends class_2586
implements TickableBlockEntity,
Pipe {
    protected final Map<class_2338, class_2350> sources = new IdentityHashMap<class_2338, class_2350>();
    protected final Map<class_2338, class_2350> consumers = new IdentityHashMap<class_2338, class_2350>();
    private final long transferRate;
    @Nullable
    private class_2350[] connectedDirections;
    private boolean initialized;
    private boolean isController;

    public PipeBlockEntity(class_2338 pos, class_2680 state) {
        super(((BasicEntityBlock)state.method_26204()).entity(state), pos, state);
        PipeBlock pipe = (PipeBlock)state.method_26204();
        this.transferRate = pipe.transferRate();
    }

    @Override
    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        if (this.isController) {
            if (time % (long)MachineConfig.pipeRefreshRate == 0L) {
                this.sources.clear();
                this.consumers.clear();
                this.findNodes(level, pos);
            }
            if (!this.consumers.isEmpty() && !this.sources.isEmpty()) {
                this.transfer(level, this.transferRate, this.sources, this.consumers);
            }
        }
    }

    public void pipeChanged(class_1937 level, class_2338 pos) {
        class_2350[] directions = PipeBlock.getConnectedDirections(level.method_8320(pos));
        this.connectedDirections = directions;
        for (class_2350 direction : directions) {
            if (level.method_8320(pos.method_10093(direction)).method_26204() instanceof PipeBlock) continue;
            this.isController = true;
            return;
        }
        this.isController = false;
    }

    @Override
    public void firstTick(class_1937 level, class_2338 pos, class_2680 state) {
        this.initialized = true;
        this.pipeChanged(level, pos);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Nullable
    public class_2350[] connectedDirections() {
        return this.connectedDirections;
    }
}

