/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items;

import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedItemFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import org.jetbrains.annotations.NotNull;

public class GasTankItem
extends class_1792
implements BotariumFluidItem<WrappedItemFluidContainer> {
    private final long tankSize;
    private final long distributionAmount;

    public GasTankItem(class_1792.class_1793 properties, long tankSize, long distributionAmount) {
        super(properties);
        this.tankSize = tankSize;
        this.distributionAmount = distributionAmount;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 usedHand) {
        class_1799 stack = player.method_5998(usedHand);
        if (FluidUtils.hasFluid(stack)) {
            player.method_6019(usedHand);
        }
        return class_1271.method_22430((Object)stack);
    }

    public void method_7852(@NotNull class_1937 level, @NotNull class_1309 entity, @NotNull class_1799 stack, int remainingUseDuration) {
        if (level.method_8608()) {
            return;
        }
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        class_1661 inventory = player.method_31548();
        FluidHolder container = FluidUtils.getTank(stack);
        if (container.getFluidAmount() == 0L) {
            return;
        }
        ItemStackHolder from = new ItemStackHolder(stack);
        if (!this.distributeSequential(from, container, inventory)) {
            return;
        }
        inventory.method_5447(inventory.field_7545, from.getStack());
        if (entity.field_6012 % 4 == 0) {
            level.method_8396(null, player.method_24515(), class_3417.field_20613, player.method_5634(), 1.0f, 1.0f);
        }
    }

    public boolean distributeSequential(ItemStackHolder from, FluidHolder container, class_1661 inventory) {
        for (int i = inventory.method_5439() - 1; i >= 0; --i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || stack.method_31574((class_1792)this)) continue;
            ItemStackHolder to = new ItemStackHolder(stack);
            long moved = FluidApi.moveFluid((ItemStackHolder)from, (ItemStackHolder)to, (FluidHolder)container.copyWithAmount(FluidConstants.fromMillibuckets((long)this.distributionAmount)), (boolean)false);
            inventory.method_5447(i, to.getStack());
            if (moved <= 0L) continue;
            return true;
        }
        return false;
    }

    public WrappedItemFluidContainer getFluidContainer(class_1799 holder) {
        return new WrappedItemFluidContainer(holder, (FluidContainer)new SimpleFluidContainer(FluidConstants.fromMillibuckets((long)this.tankSize), 1, (t, f) -> true));
    }

    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        tooltipComponents.add(TooltipUtils.getFluidComponent(FluidUtils.getTank(stack), FluidUtils.getTankCapacity(stack)));
        tooltipComponents.add(TooltipUtils.getMaxFluidOutComponent(FluidConstants.fromMillibuckets((long)this.distributionAmount)));
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.GAS_TANK_INFO);
    }

    public int method_7881(@NotNull class_1799 stack) {
        return 72000;
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        return FluidUtils.hasFluid(stack);
    }

    public int method_31569(@NotNull class_1799 stack) {
        WrappedItemFluidContainer fluidContainer = this.getFluidContainer(stack);
        return (int)((double)fluidContainer.getFirstFluid().getFluidAmount() / (double)fluidContainer.getTankCapacity(0) * 13.0);
    }

    public int method_31571(@NotNull class_1799 stack) {
        return ClientFluidHooks.getFluidColor((FluidHolder)FluidUtils.getTank(stack));
    }
}

