/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.rolling_mill;

import com.mrh0.createaddition.blocks.rolling_mill.RollingMillBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.index.CARecipes;
import com.mrh0.createaddition.recipe.rolling.RollingRecipe;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.fabricators_of_create.porting_lib.transfer.ViewOnlyWrappedStorageView;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollingMillBlockEntity
extends KineticBlockEntity
implements SidedStorageBlockEntity {
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public ItemStackHandler outputInv = new ItemStackHandler(9);
    public RollingMillInventoryHandler storage = new RollingMillInventoryHandler();
    public int timer;
    private RollingRecipe lastRecipe;

    public RollingMillBlockEntity(class_2591<? extends RollingMillBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        for (int i = 0; i < this.outputInv.getSlotCount(); ++i) {
            if (this.outputInv.getStackInSlot(i).method_7947() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.field_11863.field_9236) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        class_2350 ejectDirection = this.getEjectDirection();
        for (int slot = 0; slot < this.outputInv.getSlotCount(); ++slot) {
            class_1799 tryExport;
            class_1799 stack = this.outputInv.getStackInSlot(slot).method_7972();
            if (stack.method_7960() || (tryExport = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(stack, ejectDirection, false)) == null || tryExport.method_7947() == stack.method_7947()) continue;
            this.outputInv.setStackInSlot(slot, tryExport);
            this.method_5431();
            this.sendData();
        }
        class_2382 step = new class_2382(ejectDirection.method_10148(), ejectDirection.method_10164(), ejectDirection.method_10165());
        class_2338 nextPos = this.method_11016().method_10081(step);
        DirectBeltInputBehaviour behaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((class_1922)this.field_11863, (class_2338)nextPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (this.field_11863.field_9236 && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.outputInv.getSlotCount(); ++slot) {
                class_1799 rest;
                class_1799 stack = this.outputInv.getStackInSlot(slot).method_7972();
                if (stack.method_7960() || (rest = behaviour.handleInsertion(stack, ejectDirection, false)).equals(stack)) continue;
                this.outputInv.setStackInSlot(slot, rest);
                changed = true;
            }
            if (changed) {
                this.method_5431();
                this.sendData();
            }
        }
        if (this.inputInv.getStackInSlot(0).method_7960()) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper(this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.field_11863)) {
            Optional<RollingRecipe> recipe = this.find(inventoryIn, this.field_11863);
            if (recipe.isEmpty()) {
                this.timer = 100;
            } else {
                this.lastRecipe = recipe.get();
                this.timer = RollingMillBlockEntity.getProcessingDuration();
            }
            this.sendData();
            return;
        }
        this.timer = RollingMillBlockEntity.getProcessingDuration();
        this.sendData();
    }

    private class_2350 getEjectDirection() {
        RollingMillBlock block = (RollingMillBlock)this.method_11010().method_26204();
        float speed = this.getSpeed();
        block.getRotationAxis(this.method_11010());
        boolean rotation = speed >= 0.0f;
        class_2350 ejectDirection = class_2350.field_11036;
        switch (block.getRotationAxis(this.method_11010())) {
            case field_11048: {
                ejectDirection = rotation ? class_2350.field_11035 : class_2350.field_11043;
                break;
            }
            case field_11051: {
                ejectDirection = rotation ? class_2350.field_11039 : class_2350.field_11034;
            }
        }
        return ejectDirection;
    }

    public void remove() {
        super.remove();
    }

    private void process() {
        Object recipe;
        List results;
        if (this.method_10997() == null) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper(this.inputInv);
        Optional sequenced = SequencedAssemblyRecipe.getRecipe((class_1937)this.field_11863, (class_1799)inventoryIn.method_5438(0), CARecipes.ROLLING_TYPE.get(), RollingRecipe.class);
        if (sequenced.isPresent() && !(results = (recipe = (RollingRecipe)((Object)sequenced.get())).rollResults()).isEmpty()) {
            class_1799 result = (class_1799)results.get(0);
            try (Transaction t = Transaction.openOuter();){
                StorageUtil.insertStacking((List)this.outputInv.getSlots(), (Object)ItemVariant.of((class_1799)result), (long)result.method_7947(), (TransactionContext)t);
                t.commit();
            }
            class_1799 stackInSlot = this.inputInv.getStackInSlot(0);
            stackInSlot.method_7934(1);
            this.inputInv.setStackInSlot(0, stackInSlot);
            this.sendData();
            this.method_5431();
            return;
        }
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.field_11863)) {
            recipe = this.find(inventoryIn, this.field_11863);
            if (((Optional)recipe).isEmpty()) {
                return;
            }
            this.lastRecipe = (RollingRecipe)((Object)((Optional)recipe).get());
        }
        class_1799 result = this.lastRecipe.assemble(inventoryIn, this.method_10997().method_30349()).method_7972();
        try (Transaction t = Transaction.openOuter();){
            StorageUtil.insertStacking((List)this.outputInv.getSlots(), (Object)ItemVariant.of((class_1799)result), (long)result.method_7947(), (TransactionContext)t);
            t.commit();
        }
        class_1799 stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.method_7934(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        this.sendData();
        this.method_5431();
    }

    public void spawnParticles() {
        class_1799 stackInSlot = this.inputInv.getStackInSlot(0);
        if (stackInSlot.method_7960()) {
            return;
        }
        class_2392 data = new class_2392(class_2398.field_11218, stackInSlot);
        float angle = this.field_11863.field_9229.method_43057() * 360.0f;
        class_243 offset = new class_243(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((class_243)offset, (double)angle, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_243 target = VecHelper.rotate((class_243)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_243 center = offset.method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
        target = VecHelper.offsetRandomly((class_243)target.method_1020(offset), (class_5819)this.field_11863.field_9229, (float)0.0078125f);
        this.field_11863.method_8406((class_2394)data, center.field_1352, center.field_1351, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("Timer", this.timer);
        compound.method_10566("InputInventory", (class_2520)this.inputInv.serializeNBT());
        compound.method_10566("OutputInventory", (class_2520)this.outputInv.serializeNBT());
        super.write(compound, clientPacket);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        if (compound.method_10545("Inventory")) {
            ProcessingInventory inventory = new ProcessingInventory(stack -> {});
            inventory.deserializeNBT(compound.method_10562("Inventory"));
            try (Transaction t = Transaction.openOuter();){
                StorageUtil.move((Storage)inventory, (Storage)this.inputInv, variant -> true, (long)Long.MAX_VALUE, (TransactionContext)t);
            }
        }
        this.timer = compound.method_10550("Timer");
        this.inputInv.deserializeNBT(compound.method_10562("InputInventory"));
        this.outputInv.deserializeNBT(compound.method_10562("OutputInventory"));
        super.read(compound, clientPacket);
    }

    public int getProcessingSpeed() {
        return class_3532.method_15340((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(class_2350 side) {
        return this.storage;
    }

    private boolean canProcess(class_1799 stack) {
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper(tester);
        Optional sequenced = SequencedAssemblyRecipe.getRecipe((class_1937)this.field_11863, (class_1799)stack, CARecipes.ROLLING_TYPE.get(), RollingRecipe.class);
        if (sequenced.isPresent()) {
            return true;
        }
        if (this.lastRecipe != null && this.lastRecipe.matches(inventoryIn, this.field_11863)) {
            return true;
        }
        return this.find(inventoryIn, this.field_11863).isPresent();
    }

    public Optional<RollingRecipe> find(RecipeWrapper inv, class_1937 world) {
        Optional sequenced = SequencedAssemblyRecipe.getRecipe((class_1937)this.field_11863, (class_1799)inv.method_5438(0), CARecipes.ROLLING_TYPE.get(), RollingRecipe.class);
        if (sequenced.isPresent()) {
            return sequenced;
        }
        return world.method_8433().method_8132(CARecipes.ROLLING_TYPE.get(), (class_1263)inv, world);
    }

    public static int getProcessingDuration() {
        return (Integer)Config.ROLLING_MILL_PROCESSING_DURATION.get();
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)((Integer)Config.ROLLING_MILL_STRESS.get()).intValue();
        return impact;
    }

    private class RollingMillInventoryHandler
    extends CombinedStorage<ItemVariant, ItemStackHandler> {
        public RollingMillInventoryHandler() {
            super(List.of(RollingMillBlockEntity.this.inputInv, RollingMillBlockEntity.this.outputInv));
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (RollingMillBlockEntity.this.canProcess(resource.toStack())) {
                return RollingMillBlockEntity.this.inputInv.insert(resource, maxAmount, transaction);
            }
            return 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return RollingMillBlockEntity.this.outputInv.extract(resource, maxAmount, transaction);
        }

        @NotNull
        public Iterator<StorageView<ItemVariant>> iterator() {
            return new RollingMillInventoryHandlerIterator();
        }

        private class RollingMillInventoryHandlerIterator
        implements Iterator<StorageView<ItemVariant>> {
            private boolean output = true;
            private Iterator<StorageView<ItemVariant>> wrapped;

            public RollingMillInventoryHandlerIterator() {
                this.wrapped = RollingMillBlockEntity.this.outputInv.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.wrapped.hasNext();
            }

            @Override
            public StorageView<ItemVariant> next() {
                ViewOnlyWrappedStorageView view = this.wrapped.next();
                if (!this.output) {
                    view = new ViewOnlyWrappedStorageView(view);
                }
                if (this.output && !this.hasNext()) {
                    this.wrapped = RollingMillBlockEntity.this.inputInv.iterator();
                    this.output = false;
                }
                return view;
            }
        }
    }
}

