/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.compat.computercraft;

import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlockEntity;
import com.mrh0.createaddition.config.Config;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ElectricMotorPeripheral
implements IPeripheral {
    protected final List<IComputerAccess> connected = new ArrayList<IComputerAccess>();
    protected String type;
    protected ElectricMotorBlockEntity tileEntity;

    public ElectricMotorPeripheral(String type, ElectricMotorBlockEntity tileEntity) {
        this.type = type;
        this.tileEntity = tileEntity;
    }

    public List<IComputerAccess> getConnectedComputers() {
        return this.connected;
    }

    public Object getTarget() {
        return this.tileEntity;
    }

    public void attach(IComputerAccess computer) {
        this.connected.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.connected.remove(computer);
    }

    public boolean equals(IPeripheral iPeripheral) {
        return iPeripheral == this;
    }

    @LuaFunction
    public final String getType() {
        return this.type;
    }

    @LuaFunction(mainThread=true)
    public final void setSpeed(double rpm) throws LuaException {
        if ((float)rpm == this.getSpeed()) {
            return;
        }
        if (this.tileEntity != null && !this.tileEntity.setRPM((float)rpm)) {
            throw new LuaException("Speed is set too many times per second (Anti Spam).");
        }
    }

    @LuaFunction(mainThread=true)
    public final void stop() throws LuaException {
        this.setSpeed(0.0);
    }

    @LuaFunction(mainThread=true)
    public final float getSpeed() throws LuaException {
        if (this.tileEntity != null) {
            return this.tileEntity.getRPM();
        }
        return 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final int getStressCapacity() throws LuaException {
        if (this.tileEntity != null) {
            return this.tileEntity.getGeneratedStress();
        }
        return 0;
    }

    @LuaFunction(mainThread=true)
    public final float getEnergyConsumption() throws LuaException {
        if (this.tileEntity != null) {
            return this.tileEntity.getEnergyConsumption();
        }
        return 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final float rotate(double deg, Optional<Double> rpm) throws LuaException {
        if (this.tileEntity != null) {
            double _rpm = rpm.orElse(Double.valueOf(this.getSpeed()));
            if (rpm.isPresent()) {
                this.setSpeed(deg < 0.0 ? -_rpm : _rpm);
            }
            return ElectricMotorBlockEntity.getDurationAngle((float)deg, 0.0f, (float)_rpm) / 20.0f;
        }
        return 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final float translate(double dist, Optional<Double> rpm) throws LuaException {
        if (this.tileEntity != null) {
            double _rpm = rpm.orElse(Double.valueOf(this.getSpeed()));
            if (rpm.isPresent()) {
                this.setSpeed(dist < 0.0 ? -_rpm : _rpm);
            }
            return ElectricMotorBlockEntity.getDurationDistance((float)dist, 0.0f, (float)_rpm) / 20.0f;
        }
        return 0.0f;
    }

    @LuaFunction(mainThread=true)
    public long getMaxInsert() {
        return (Long)Config.ELECTRIC_MOTOR_MAX_INPUT.get();
    }

    @LuaFunction(mainThread=true)
    public int getMaxExtract() {
        return 0;
    }
}

