/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.transfer.EnergyTransferable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.EnumMap;
import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public abstract class BaseElectricBlockEntity
extends SmartBlockEntity
implements EnergyTransferable {
    protected final InternalEnergyStorage localEnergy;
    private final EnumMap<class_2350, BlockApiCache<EnergyStorage, class_2350>> escacheMap = new EnumMap(class_2350.class);

    public BaseElectricBlockEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state);
        this.localEnergy = new InternalEnergyStorage(this.getCapacity(), this.getMaxIn(), this.getMaxOut());
        this.setLazyTickRate(20);
    }

    public abstract long getCapacity();

    public abstract long getMaxIn();

    public abstract long getMaxOut();

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    @Nullable
    public EnergyStorage getEnergyStorage(@Nullable class_2350 side) {
        if (this.isEnergyInput(side) || this.isEnergyOutput(side)) {
            return this.localEnergy;
        }
        return null;
    }

    public abstract boolean isEnergyInput(class_2350 var1);

    public abstract boolean isEnergyOutput(class_2350 var1);

    protected void read(class_2487 compound, boolean arg1) {
        super.read(compound, arg1);
        this.localEnergy.read(compound);
    }

    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.localEnergy.write(compound);
    }

    @Deprecated
    public void outputTick(int max) {
        for (class_2350 side : class_2350.values()) {
            if (!this.isEnergyOutput(side)) continue;
            this.localEnergy.outputToSide(this.field_11863, this.field_11867, side, max);
        }
    }

    public boolean ignoreCapSide() {
        return false;
    }

    @Nullable
    public EnergyStorage getCachedEnergy(class_2350 side) {
        class_1937 class_19372 = this.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        BlockApiCache cache = this.escacheMap.computeIfAbsent(side, side1 -> BlockApiCache.create((BlockApiLookup)EnergyStorage.SIDED, (class_3218)serverLevel, (class_2338)this.method_11016().method_10093(side)));
        EnergyStorage es = (EnergyStorage)cache.find((Object)side.method_10153());
        if (es == null && this.ignoreCapSide()) {
            es = (EnergyStorage)cache.find(null);
        }
        return es;
    }
}

