/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.sodium.mixin.vertex_format.entity;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.render.immediate.model.BakedModelEncoder;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorU8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.compat.sodium.impl.vertex_format.entity_xhfp.EntityVertex;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BakedModelEncoder.class})
public class MixinModelVertex {
    @Inject(method={"writeQuadVertices(Lnet/caffeinemc/mods/sodium/api/vertex/buffer/VertexBufferWriter;Lnet/minecraft/class_4587$class_4665;Lme/jellysquid/mods/sodium/client/model/quad/ModelQuadView;III)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void redirect2(VertexBufferWriter writer, class_4587.class_4665 matrices, ModelQuadView quad, int color, int light, int overlay, CallbackInfo ci) {
        if (MixinModelVertex.shouldBeExtended()) {
            ci.cancel();
            EntityVertex.writeQuadVertices(writer, matrices, quad, light, overlay, color);
        }
    }

    @Overwrite
    public static void writeQuadVertices(VertexBufferWriter writer, class_4587.class_4665 matrices, ModelQuadView quad, float r, float g, float b, float a, float[] brightnessTable, boolean colorize, int[] light, int overlay) {
        Matrix3f matNormal = matrices.method_23762();
        Matrix4f matPosition = matrices.method_23761();
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(144);
            int normal = MatrixHelper.transformNormal((Matrix3f)matNormal, (boolean)true, (class_2350)quad.getLightFace());
            for (int i = 0; i < 4; ++i) {
                float fB;
                float fG;
                float fR;
                int color;
                float x = quad.getX(i);
                float y = quad.getY(i);
                float z = quad.getZ(i);
                float xt = MatrixHelper.transformPositionX((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                float yt = MatrixHelper.transformPositionY((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                float zt = MatrixHelper.transformPositionZ((Matrix4f)matPosition, (float)x, (float)y, (float)z);
                float brightness = brightnessTable[i];
                if (colorize) {
                    color = quad.getColor(i);
                    float oR = ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackRed((int)color));
                    float oG = ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackGreen((int)color));
                    float oB = ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackBlue((int)color));
                    fR = oR * brightness * r;
                    fG = oG * brightness * g;
                    fB = oB * brightness * b;
                } else {
                    fR = brightness * r;
                    fG = brightness * g;
                    fB = brightness * b;
                }
                color = ColorABGR.pack((float)fR, (float)fG, (float)fB, (float)a);
                ModelVertex.write((long)ptr, (float)xt, (float)yt, (float)zt, (int)color, (float)quad.getTexU(i), (float)quad.getTexV(i), (int)overlay, (int)light[i], (int)normal);
                ptr += 36L;
            }
            writer.push(stack, buffer, 4, ModelVertex.FORMAT);
        }
    }

    private static boolean shouldBeExtended() {
        return IrisApi.getInstance().isShaderPackInUse() && ImmediateState.renderWithExtendedVertexFormat;
    }
}

