/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.fabricators_of_create.porting_lib.models.BakedMeshModel;
import io.github.fabricators_of_create.porting_lib.models.PortingLibModelLoadingRegistry;
import io.github.fabricators_of_create.porting_lib.models.UnbakedGeometryHelper;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import org.jetbrains.annotations.Nullable;

public class TFItemLayerModel
implements IUnbakedGeometry<TFItemLayerModel> {
    @Nullable
    private ImmutableList<class_4730> textures;
    private final Int2ObjectMap<RenderMaterial> layerData;

    private TFItemLayerModel(@Nullable ImmutableList<class_4730> textures, Int2ObjectMap<RenderMaterial> layerData) {
        this.textures = textures;
        this.layerData = layerData;
    }

    public class_1087 bake(class_793 context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        if (this.textures == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (context.method_3432("particle")) {
                builder.add((Object)context.method_24077("particle"));
            }
            int i = 0;
            while (context.method_3432("layer" + i)) {
                builder.add((Object)context.method_24077("layer" + i));
                ++i;
            }
            this.textures = builder.build();
        }
        class_1058 particle = spriteGetter.apply(context.method_3432("particle") ? context.method_24077("particle") : (class_4730)this.textures.get(0));
        MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        for (int i = 0; i < this.textures.size(); ++i) {
            QuadEmitter emitter = meshBuilder.getEmitter();
            class_1058 sprite = spriteGetter.apply((class_4730)this.textures.get(i));
            List unbaked = class_1088.field_5384.method_3480(i, "layer" + i, sprite.method_45851());
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (class_3665)modelState, (class_2960)modelLocation);
            for (class_777 quad : quads) {
                emitter.fromVanilla(quad, (RenderMaterial)this.layerData.get(i), quad.method_3358());
                emitter.emit();
            }
        }
        return new BakedMeshModel(context, particle, meshBuilder.build());
    }

    public static final class Loader
    implements IGeometryLoader<TFItemLayerModel> {
        public static final class_2960 ID = new class_2960("twilightforest", "item_layers");
        public static final Loader INSTANCE = new Loader();

        public TFItemLayerModel read(JsonObject jsonObject, JsonDeserializationContext parent) throws JsonParseException {
            if (!RendererAccess.INSTANCE.hasRenderer()) {
                throw new JsonParseException("The Fabric Rendering API is not available. If you have Sodium, install Indium!");
            }
            Int2ObjectArrayMap emissiveLayers = new Int2ObjectArrayMap();
            if (jsonObject.has("render_materials")) {
                JsonObject forgeData = jsonObject.get("render_materials").getAsJsonObject();
                this.readLayerData(forgeData, "layers", (Int2ObjectMap<RenderMaterial>)emissiveLayers);
            }
            return new TFItemLayerModel(null, (Int2ObjectMap<RenderMaterial>)emissiveLayers);
        }

        public void readLayerData(JsonObject jsonObject, String name, Int2ObjectMap<RenderMaterial> layerData) {
            if (!jsonObject.has(name)) {
                return;
            }
            JsonObject fullbrightLayers = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : fullbrightLayers.entrySet()) {
                int layer = Integer.parseInt((String)entry.getKey());
                RenderMaterial data = (RenderMaterial)PortingLibModelLoadingRegistry.GSON.fromJson((JsonElement)entry.getValue(), RenderMaterial.class);
                layerData.put(layer, (Object)data);
            }
        }
    }
}

