/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.block.doors;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twilightforest.client.model.block.doors.ConnectionLogic;
import twilightforest.init.TFBlocks;

public class CastleDoorModel
implements class_1087,
FabricBakedModel {
    private static final RenderMaterial MATERIAL = RendererAccess.INSTANCE.getRenderer().materialFinder().blendMode(0, BlendMode.CUTOUT).emissive(0, true).find();
    @Nullable
    private final Mesh[] baseQuads;
    private final class_777[][][] quads;
    private final class_1058 particle;
    private final class_806 overrides;
    private final class_809 transforms;
    private final class_2248[] validConnectors = new class_2248[]{(class_2248)TFBlocks.PINK_CASTLE_DOOR.get(), (class_2248)TFBlocks.YELLOW_CASTLE_DOOR.get(), (class_2248)TFBlocks.BLUE_CASTLE_DOOR.get(), (class_2248)TFBlocks.VIOLET_CASTLE_DOOR.get()};

    public CastleDoorModel(@Nullable Mesh[] baseQuads, class_777[][][] quads, class_1058 particle, class_806 overrides, class_809 transforms) {
        this.baseQuads = baseQuads;
        this.quads = quads;
        this.particle = particle;
        this.overrides = overrides;
        this.transforms = transforms;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        QuadEmitter emitter = context.getEmitter();
        for (class_2350 side : class_2350.values()) {
            int faceIndex = side.method_10146();
            CastleDoorData data = this.getModelData(blockView, pos);
            context.meshConsumer().accept(this.baseQuads[faceIndex]);
            for (int quad = 0; quad < 4; ++quad) {
                ConnectionLogic connectionType = data.logic[faceIndex][quad];
                emitter.fromVanilla(this.quads[faceIndex][quad][connectionType.ordinal()], MATERIAL, side);
                emitter.emit();
            }
        }
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        QuadEmitter emitter = context.getEmitter();
        for (class_2350 side : class_2350.values()) {
            int faceIndex = side.method_10146();
            context.meshConsumer().accept(this.baseQuads[faceIndex]);
            for (int quad = 0; quad < 4; ++quad) {
                ConnectionLogic connectionType = ConnectionLogic.NONE;
                emitter.fromVanilla(this.quads[faceIndex][quad][connectionType.ordinal()], MATERIAL, side);
                emitter.emit();
            }
        }
    }

    @NotNull
    public CastleDoorData getModelData(@NotNull class_1920 getter, @NotNull class_2338 pos) {
        CastleDoorData data = new CastleDoorData();
        for (class_2350 face : class_2350.values()) {
            int faceIndex;
            class_2350[] directions = ConnectionLogic.AXIS_PLANE_DIRECTIONS[face.method_10166().ordinal()];
            boolean[] sideStates = new boolean[4];
            for (faceIndex = 0; faceIndex < directions.length; ++faceIndex) {
                sideStates[faceIndex] = this.shouldConnectSide(getter, pos, face, directions[faceIndex]);
            }
            faceIndex = face.method_10146();
            for (int dir = 0; dir < directions.length; ++dir) {
                int cornerOffset = (dir + 1) % directions.length;
                boolean side1 = sideStates[dir];
                boolean side2 = sideStates[cornerOffset];
                boolean corner = side1 && side2 && this.isCornerBlockPresent(getter, pos, face, directions[dir], directions[cornerOffset]);
                data.logic[faceIndex][dir] = dir % 2 == 0 ? ConnectionLogic.of(side1, side2, corner) : ConnectionLogic.of(side2, side1, corner);
            }
        }
        return data;
    }

    private boolean shouldConnectSide(class_1920 getter, class_2338 pos, class_2350 face, class_2350 side) {
        class_2680 neighborState = getter.method_8320(pos.method_10093(side));
        return Arrays.stream(this.validConnectors).anyMatch(arg_0 -> ((class_2680)neighborState).method_27852(arg_0)) && class_2248.method_9607((class_2680)neighborState, (class_1922)getter, (class_2338)pos, (class_2350)face, (class_2338)pos.method_10093(face));
    }

    private boolean isCornerBlockPresent(class_1920 getter, class_2338 pos, class_2350 face, class_2350 side1, class_2350 side2) {
        class_2680 neighborState = getter.method_8320(pos.method_10093(side1).method_10093(side2));
        return Arrays.stream(this.validConnectors).anyMatch(arg_0 -> ((class_2680)neighborState).method_27852(arg_0)) && class_2248.method_9607((class_2680)neighborState, (class_1922)getter, (class_2338)pos, (class_2350)face, (class_2338)pos.method_10093(face));
    }

    public List<class_777> method_4707(@Nullable class_2680 blockState, @Nullable class_2350 direction, class_5819 randomSource) {
        return List.of();
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return true;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    @NotNull
    public class_1058 method_4711() {
        return this.particle;
    }

    @NotNull
    public class_806 method_4710() {
        return this.overrides;
    }

    @NotNull
    public class_809 method_4709() {
        return this.transforms;
    }

    public static final class CastleDoorData {
        private final ConnectionLogic[][] logic = new ConnectionLogic[6][4];

        private CastleDoorData() {
        }
    }
}

