/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import twilightforest.client.MagicPaintingTextureManager;
import twilightforest.entity.MagicPainting;
import twilightforest.init.custom.MagicPaintingVariants;
import twilightforest.util.MagicPaintingVariant;
import twilightforest.util.PartialTickUtil;

public class MagicPaintingRenderer
extends class_897<MagicPainting> {
    protected static final float ONE_SECOND = 8.3333335E-4f;

    public MagicPaintingRenderer(class_5617.class_5618 pContext) {
        super(pContext);
    }

    public void render(MagicPainting painting, float yaw, float partialTicks, class_4587 stack, class_4597 buffer, int packedLight) {
        MagicPaintingVariant paintingVariant = painting.getVariant().orElse(null);
        if (paintingVariant == null) {
            return;
        }
        stack.method_22903();
        stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yaw));
        stack.method_22905(0.0625f, 0.0625f, 0.0625f);
        class_4588 vertexconsumer = buffer.getBuffer(class_1921.method_23580((class_2960)this.getTextureLocation(painting)));
        this.renderPainting(stack, vertexconsumer, painting, paintingVariant);
        stack.method_22909();
        super.method_3936((class_1297)painting, yaw, partialTicks, stack, buffer, packedLight);
    }

    public class_2960 getTextureLocation(MagicPainting painting) {
        return MagicPaintingTextureManager.ATLAS_LOCATION;
    }

    private void renderPainting(class_4587 stack, class_4588 vertex, MagicPainting painting, MagicPaintingVariant variant) {
        class_2960 textureLocation = MagicPaintingVariants.getVariantResourceLocation(painting.method_37908().method_30349(), variant);
        int width = variant.width();
        int height = variant.height();
        int widthAsBlock = width / 16;
        int heightAsBlock = height / 16;
        class_4587.class_4665 pose = stack.method_23760();
        Matrix4f matrix4f = pose.method_23761();
        Matrix3f matrix3f = pose.method_23762();
        float x = (float)(-width) / 2.0f;
        float y = (float)(-height) / 2.0f;
        float z = 0.5f;
        double widthFactor = 16.0 / (double)widthAsBlock;
        double heightFactor = 16.0 / (double)heightAsBlock;
        class_2350 direction = painting.method_5735();
        int posX = painting.method_31477();
        int posZ = painting.method_31479();
        for (MagicPaintingVariant.Layer layer : variant.layers()) {
            float alpha = this.getAlpha(layer.opacityModifier(), painting);
            if (alpha <= 0.0f) continue;
            MagicPaintingVariant.Layer.Parallax parallax = layer.parallax();
            int layerWidth = parallax != null ? parallax.width() : width;
            int layerHeight = parallax != null ? parallax.height() : height;
            double layerWidthAsBlock = (double)layerWidth / 16.0;
            double layerHeightAsBlock = (double)layerHeight / 16.0;
            double layerWidthFactor = 16.0 / layerWidthAsBlock;
            double layerHeightFactor = 16.0 / layerHeightAsBlock;
            double widthDiff = parallax != null ? (widthFactor - layerWidthFactor) * (double)widthAsBlock * 0.5 : 0.0;
            double widthOffset = widthDiff != 0.0 ? this.getWidthOffset(parallax, painting, widthDiff) : 0.0;
            double heightDiff = parallax != null ? (heightFactor - layerHeightFactor) * (double)heightAsBlock * 0.5 : 0.0;
            double heightOffset = heightDiff != 0.0 ? this.getHeightOffset(parallax, painting, heightDiff) : 0.0;
            class_1058 layerTexture = MagicPaintingTextureManager.getInstance().getLayerSprite(textureLocation, layer);
            for (int k = 0; k < widthAsBlock; ++k) {
                for (int l = 0; l < heightAsBlock; ++l) {
                    float xMax = x + (float)((k + 1) * 16);
                    float xMin = x + (float)(k * 16);
                    float yMax = y + (float)((l + 1) * 16);
                    float yMin = y + (float)(l * 16);
                    if (direction == class_2350.field_11043) {
                        posX = class_3532.method_15357((double)(painting.method_23317() + (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    if (direction == class_2350.field_11039) {
                        posZ = class_3532.method_15357((double)(painting.method_23321() - (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    if (direction == class_2350.field_11035) {
                        posX = class_3532.method_15357((double)(painting.method_23317() - (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    if (direction == class_2350.field_11034) {
                        posZ = class_3532.method_15357((double)(painting.method_23321() + (double)((xMax + xMin) / 2.0f / 16.0f)));
                    }
                    int light = layer.fullbright() ? 15728850 : class_761.method_23794((class_1920)painting.method_37908(), (class_2338)new class_2338(posX, class_3532.method_15357((double)(painting.method_23318() + (double)((yMax + yMin) / 2.0f / 16.0f))), posZ));
                    float xEnd = layerTexture.method_4580(layerWidthFactor * (double)(widthAsBlock - k) + widthOffset);
                    float xStart = layerTexture.method_4580(layerWidthFactor * (double)(widthAsBlock - (k + 1)) + widthOffset);
                    float yEnd = layerTexture.method_4570(layerHeightFactor * (double)(heightAsBlock - l) + heightOffset);
                    float yStart = layerTexture.method_4570(layerHeightFactor * (double)(heightAsBlock - (l + 1)) + heightOffset);
                    this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, -z, xStart, yEnd, 0, 0, -1, light, alpha);
                    this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, -z, xEnd, yEnd, 0, 0, -1, light, alpha);
                    this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, -z, xEnd, yStart, 0, 0, -1, light, alpha);
                    this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, -z, xStart, yStart, 0, 0, -1, light, alpha);
                }
            }
        }
        class_1058 backSprite = MagicPaintingTextureManager.getInstance().getBackSprite();
        float u0 = backSprite.method_4594();
        float u1 = backSprite.method_4577();
        float v0 = backSprite.method_4593();
        float v1 = backSprite.method_4575();
        float u01 = backSprite.method_4594();
        float u11 = backSprite.method_4577();
        float v01 = backSprite.method_4593();
        float v = backSprite.method_4570(1.0);
        float u02 = backSprite.method_4594();
        float u = backSprite.method_4580(1.0);
        float v02 = backSprite.method_4593();
        float v11 = backSprite.method_4575();
        for (int w = 0; w < widthAsBlock; ++w) {
            for (int h = 0; h < heightAsBlock; ++h) {
                float xMax = x + (float)((w + 1) * 16);
                float xMin = x + (float)(w * 16);
                float yMax = y + (float)((h + 1) * 16);
                float yMin = y + (float)(h * 16);
                if (direction == class_2350.field_11043) {
                    posX = class_3532.method_15357((double)(painting.method_23317() + (double)((xMax + xMin) / 2.0f / 16.0f)));
                }
                if (direction == class_2350.field_11039) {
                    posZ = class_3532.method_15357((double)(painting.method_23321() - (double)((xMax + xMin) / 2.0f / 16.0f)));
                }
                if (direction == class_2350.field_11035) {
                    posX = class_3532.method_15357((double)(painting.method_23317() - (double)((xMax + xMin) / 2.0f / 16.0f)));
                }
                if (direction == class_2350.field_11034) {
                    posZ = class_3532.method_15357((double)(painting.method_23321() + (double)((xMax + xMin) / 2.0f / 16.0f)));
                }
                int light = class_761.method_23794((class_1920)painting.method_37908(), (class_2338)new class_2338(posX, class_3532.method_15357((double)(painting.method_23318() + (double)((yMax + yMin) / 2.0f / 16.0f))), posZ));
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, z, u1, v0, 0, 0, 1, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, z, u0, v0, 0, 0, 1, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, z, u0, v1, 0, 0, 1, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, z, u1, v1, 0, 0, 1, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, -z, u01, v01, 0, 1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, -z, u11, v01, 0, 1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, z, u11, v, 0, 1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, z, u01, v, 0, 1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, z, u01, v01, 0, -1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, z, u11, v01, 0, -1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, -z, u11, v, 0, -1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, -z, u01, v, 0, -1, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, z, u, v02, -1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, z, u, v11, -1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMin, -z, u02, v11, -1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMax, yMax, -z, u02, v02, -1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, -z, u, v02, 1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, -z, u, v11, 1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMin, z, u02, v11, 1, 0, 0, light, 1.0f);
                this.vertex(matrix4f, matrix3f, vertex, xMin, yMax, z, u02, v02, 1, 0, 0, light, 1.0f);
            }
        }
    }

    protected void vertex(Matrix4f matrix4f, Matrix3f matrix3f, class_4588 vertex, float x, float y, float z, float u, float v, int normX, int normY, int normZ, int light, float a) {
        vertex.method_22918(matrix4f, x, y, z).method_1336(255, 255, 255, (int)(255.0f * a)).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix3f, (float)normX, (float)normY, (float)normZ).method_1344();
    }

    protected double getWidthOffset(@Nullable MagicPaintingVariant.Layer.Parallax parallax, MagicPainting painting, double widthDiff) {
        if (parallax != null) {
            switch (parallax.type()) {
                case VIEW_ANGLE: {
                    float partialTick = PartialTickUtil.getPartialTick();
                    class_243 camPos = class_310.method_1551().field_1719 != null ? class_310.method_1551().field_1719.method_5836(partialTick) : class_310.method_1551().field_1773.method_19418().method_19326();
                    class_243 paintPos = painting.method_19538().method_43206(painting.method_5735().method_10153(), 1.0);
                    double x = camPos.field_1352 - paintPos.field_1352;
                    double z = camPos.field_1350 - paintPos.field_1350;
                    double yRot = class_3532.method_15393((float)((float)(class_3532.method_15349((double)z, (double)x) * 57.2957763671875) - 90.0f - painting.method_36454()));
                    return widthDiff + class_3532.method_15350((double)(yRot * (double)parallax.multiplier() * widthDiff), (double)(-widthDiff), (double)widthDiff);
                }
                case SINE_TIME: {
                    return widthDiff + Math.sin(((float)painting.field_6012 + PartialTickUtil.getPartialTick()) * parallax.multiplier()) * widthDiff;
                }
                case LINEAR_TIME: {
                    double trueTick = ((float)painting.field_6012 + PartialTickUtil.getPartialTick()) * parallax.multiplier();
                    double wholeDiff = widthDiff * 2.0;
                    return widthDiff + ((double)parallax.multiplier() > 0.0 ? -widthDiff + trueTick % wholeDiff : widthDiff - trueTick % wholeDiff);
                }
            }
        }
        return 0.0;
    }

    protected double getHeightOffset(@Nullable MagicPaintingVariant.Layer.Parallax parallax, MagicPainting painting, double heightDiff) {
        if (parallax != null) {
            switch (parallax.type()) {
                case VIEW_ANGLE: {
                    float partialTick = PartialTickUtil.getPartialTick();
                    class_243 camPos = class_310.method_1551().field_1719 != null ? class_310.method_1551().field_1719.method_5836(partialTick) : class_310.method_1551().field_1773.method_19418().method_19326();
                    class_243 paintPos = painting.method_19538().method_43206(painting.method_5735().method_10153(), 1.0);
                    double x = camPos.field_1352 - paintPos.field_1352;
                    double y = camPos.field_1351 - paintPos.field_1351;
                    double z = camPos.field_1350 - paintPos.field_1350;
                    double pythagoras = Math.sqrt(x * x + z * z);
                    double xRot = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)y, (double)pythagoras) * 57.2957763671875))));
                    return heightDiff - class_3532.method_15350((double)(xRot * (double)parallax.multiplier() * heightDiff), (double)(-heightDiff), (double)heightDiff);
                }
                case SINE_TIME: {
                    return heightDiff - Math.cos(((float)painting.field_6012 + PartialTickUtil.getPartialTick()) * parallax.multiplier()) * heightDiff;
                }
                case LINEAR_TIME: {
                    double trueTick = ((float)painting.field_6012 + PartialTickUtil.getPartialTick()) * parallax.multiplier();
                    double wholeDiff = heightDiff * 2.0;
                    return heightDiff - ((double)parallax.multiplier() > 0.0 ? -heightDiff + trueTick % wholeDiff : heightDiff - trueTick % wholeDiff);
                }
            }
        }
        return 0.0;
    }

    protected float getAlpha(@Nullable MagicPaintingVariant.Layer.OpacityModifier opacityModifier, MagicPainting painting) {
        float a = 1.0f;
        if (opacityModifier != null) {
            switch (opacityModifier.type()) {
                case DISTANCE: {
                    class_243 camPos = Optional.ofNullable(class_310.method_1551().field_1719).map(class_1297::method_33571).orElse(class_310.method_1551().field_1773.method_19418().method_19326());
                    a = (float)(opacityModifier.invert() ? (double)opacityModifier.multiplier() - camPos.method_1022(painting.method_19538()) : camPos.method_1022(painting.method_19538()) - (double)opacityModifier.multiplier());
                    break;
                }
                case WEATHER: {
                    float partialTick = PartialTickUtil.getPartialTick();
                    a = (painting.method_37908().method_8430(partialTick) + painting.method_37908().method_8478(partialTick)) * 0.5f * Math.abs(opacityModifier.multiplier());
                    if (!opacityModifier.invert()) break;
                    a = 1.0f - a;
                    break;
                }
                case LIGHTNING: {
                    class_1937 class_19372 = painting.method_37908();
                    if (!(class_19372 instanceof class_638)) break;
                    class_638 clientLevel = (class_638)class_19372;
                    a = (float)clientLevel.method_23789() * opacityModifier.multiplier();
                    if (!opacityModifier.invert()) break;
                    a = 1.0f - a;
                    break;
                }
                case DAY_TIME: {
                    float dayTime = Math.abs(painting.method_37908().method_30274(PartialTickUtil.getPartialTick()) - 0.5f) * 2.0f;
                    if (opacityModifier.invert()) {
                        dayTime = 1.0f - dayTime;
                    }
                    a = (float)Math.pow(dayTime, opacityModifier.multiplier());
                    break;
                }
                case DAY_TIME_SHARP: {
                    float threshold;
                    float dayTime = Math.abs(painting.method_37908().method_30274(PartialTickUtil.getPartialTick()) - 0.5f) * 2.0f;
                    if (opacityModifier.invert()) {
                        dayTime = 1.0f - dayTime;
                    }
                    if ((threshold = 1.0f - opacityModifier.multiplier()) > 0.99916667f) {
                        threshold = 0.99916667f;
                    } else if (threshold < 8.3333335E-4f) {
                        threshold = 8.3333335E-4f;
                    }
                    if (dayTime < threshold) {
                        a = 0.0f;
                        break;
                    }
                    if (!(dayTime <= threshold + 8.3333335E-4f)) break;
                    a = (dayTime - threshold) / 8.3333335E-4f;
                    break;
                }
                case SINE_TIME: {
                    a = (float)Math.sin(((float)painting.field_6012 + PartialTickUtil.getPartialTick()) * opacityModifier.multiplier()) * 0.5f + 0.5f;
                    if (!opacityModifier.invert()) break;
                    a = 1.0f - a;
                }
            }
        }
        return class_3532.method_15363((float)a, (float)0.0f, (float)1.0f);
    }
}

