/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2484;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4844;
import net.minecraft.class_5544;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_607;
import net.minecraft.class_7718;
import net.minecraft.class_7946;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.LightableBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;

public class SkullCandleTileEntityRenderer<T extends SkullCandleBlockEntity>
implements class_827<T> {
    private final Map<class_2484.class_2485, class_5598> modelByType;
    public static final Map<class_2484.class_2485, class_2960> SKIN_BY_TYPE = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(class_2484.class_2486.field_11512, new class_2960("textures/entity/skeleton/skeleton.png"));
        map.put(class_2484.class_2486.field_11513, new class_2960("textures/entity/skeleton/wither_skeleton.png"));
        map.put(class_2484.class_2486.field_11508, new class_2960("textures/entity/zombie/zombie.png"));
        map.put(class_2484.class_2486.field_11507, new class_2960("textures/entity/creeper/creeper.png"));
        map.put(class_2484.class_2486.field_41313, new class_2960("textures/entity/piglin/piglin.png"));
        map.put(class_2484.class_2486.field_11510, class_1068.method_4649());
    });

    public static Map<class_2484.class_2485, class_5598> createSkullRenderers(class_5599 set) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)class_2484.class_2486.field_11512, (Object)new class_607(set.method_32072(class_5602.field_27653)));
        map.put((Object)class_2484.class_2486.field_11513, (Object)new class_607(set.method_32072(class_5602.field_27634)));
        map.put((Object)class_2484.class_2486.field_11510, (Object)new class_607(set.method_32072(class_5602.field_27578)));
        map.put((Object)class_2484.class_2486.field_11508, (Object)new class_607(set.method_32072(class_5602.field_27640)));
        map.put((Object)class_2484.class_2486.field_11507, (Object)new class_607(set.method_32072(class_5602.field_27548)));
        map.put((Object)class_2484.class_2486.field_41313, (Object)new class_7946(set.method_32072(class_5602.field_41382)));
        return map.build();
    }

    public SkullCandleTileEntityRenderer(class_5614.class_5615 renderer) {
        this.modelByType = SkullCandleTileEntityRenderer.createSkullRenderers(renderer.method_32142());
    }

    public void render(SkullCandleBlockEntity entity, float partialTicks, class_4587 stack, class_4597 buffer, int light, int overlay) {
        float animationTime = entity.method_47588(partialTicks);
        class_2680 state = entity.method_11010();
        boolean wallSkull = state.method_26204() instanceof WallSkullCandleBlock;
        class_2350 direction = wallSkull ? (class_2350)state.method_11654((class_2769)WallSkullCandleBlock.FACING) : null;
        int rotation = wallSkull ? class_7718.method_45481((class_2350)direction.method_10153()) : (Integer)state.method_11654((class_2769)SkullCandleBlock.ROTATION);
        float rotDegrees = class_7718.method_45482((int)rotation);
        class_2484.class_2485 type = ((AbstractSkullCandleBlock)state.method_26204()).getType();
        class_5598 base = this.modelByType.get(type);
        class_1921 rendertype = SkullCandleTileEntityRenderer.getRenderType(type, entity.method_11334());
        SkullCandleTileEntityRenderer.renderSkull(direction, rotDegrees, animationTime, stack, buffer, light, base, rendertype);
        if (direction != null) {
            stack.method_46416((float)(-direction.method_10148()) * 0.25f, 0.75f, (float)(-direction.method_10165()) * 0.25f);
        } else {
            stack.method_46416(0.0f, 0.45f, 0.0f);
        }
        class_310.method_1551().method_1541().method_3353((class_2680)((class_2680)AbstractSkullCandleBlock.candleColorToCandle(AbstractSkullCandleBlock.CandleColors.colorFromInt(entity.getCandleColor())).method_9564().method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(Math.max(1, entity.getCandleAmount())))).method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(state.method_11654((class_2769)AbstractSkullCandleBlock.LIGHTING) == LightableBlock.Lighting.NORMAL)), stack, buffer, light, overlay);
    }

    public static void renderSkull(@Nullable class_2350 direction, float pYRot, float animationTime, class_4587 stack, class_4597 buffer, int light, class_5598 base, class_1921 type) {
        stack.method_22903();
        if (direction == null) {
            stack.method_46416(0.5f, 0.0f, 0.5f);
        } else {
            stack.method_46416(0.5f - (float)direction.method_10148() * 0.25f, 0.25f, 0.5f - (float)direction.method_10165() * 0.25f);
        }
        stack.method_22905(-1.0f, -1.0f, 1.0f);
        class_4588 consumer = buffer.getBuffer(type);
        base.method_2821(animationTime, pYRot, 0.0f);
        base.method_2828(stack, consumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.method_22909();
    }

    public static class_1921 getRenderType(class_2484.class_2485 type, @Nullable GameProfile profile) {
        class_2960 resourcelocation = SKIN_BY_TYPE.get(type);
        if (type == class_2484.class_2486.field_11510 && profile != null) {
            class_310 minecraft = class_310.method_1551();
            Map map = minecraft.method_1582().method_4654(profile);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? class_1921.method_23580((class_2960)minecraft.method_1582().method_4656((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : class_1921.method_23578((class_2960)class_1068.method_4648((UUID)class_4844.method_43343((GameProfile)profile)));
        }
        return class_1921.method_28116((class_2960)resourcelocation);
    }
}

