/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1867;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.client.UncraftingScreen;
import twilightforest.compat.jei.FakeItemEntity;
import twilightforest.compat.jei.categories.CrumbleHornCategory;
import twilightforest.compat.jei.categories.JEIUncraftingCategory;
import twilightforest.compat.jei.categories.TransformationPowderCategory;
import twilightforest.compat.jei.renderers.EntityHelper;
import twilightforest.compat.jei.renderers.EntityRenderer;
import twilightforest.compat.jei.renderers.FakeItemEntityHelper;
import twilightforest.compat.jei.renderers.FakeItemEntityRenderer;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFMenuTypes;
import twilightforest.init.TFRecipes;
import twilightforest.inventory.UncraftingMenu;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public static final IIngredientType<class_1299> ENTITY_TYPE = () -> class_1299.class;
    public static final IIngredientType<FakeItemEntity> FAKE_ITEM_ENTITY = () -> FakeItemEntity.class;

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (!((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableEntireTable.get()).booleanValue()) {
            registration.addRecipeCatalyst(new class_1799((class_1935)TFBlocks.UNCRAFTING_TABLE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
            registration.addRecipeCatalyst(new class_1799((class_1935)TFBlocks.UNCRAFTING_TABLE.get()), new RecipeType[]{JEIUncraftingCategory.UNCRAFTING});
        }
        registration.addRecipeCatalyst(new class_1799((class_1935)TFItems.TRANSFORMATION_POWDER.get()), new RecipeType[]{TransformationPowderCategory.TRANSFORMATION});
        registration.addRecipeCatalyst(new class_1799((class_1935)TFItems.CRUMBLE_HORN.get()), new RecipeType[]{CrumbleHornCategory.CRUMBLE_HORN});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(UncraftingMenu.class, (class_3917)TFMenuTypes.UNCRAFTING.get(), RecipeTypes.CRAFTING, 11, 9, 20, 36);
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(ENTITY_TYPE, Collections.emptyList(), (IIngredientHelper)new EntityHelper(), (IIngredientRenderer)new EntityRenderer(16));
        registration.register(FAKE_ITEM_ENTITY, Collections.emptyList(), (IIngredientHelper)new FakeItemEntityHelper(), (IIngredientRenderer)new FakeItemEntityRenderer(16));
    }

    public class_2960 getPluginUid() {
        return TwilightForestMod.prefix("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new JEIUncraftingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new TransformationPowderCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrumbleHornCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        class_1863 manager = Objects.requireNonNull(class_310.method_1551().field_1687).method_8433();
        if (!((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableEntireTable.get()).booleanValue()) {
            if (!((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingOnly.get()).booleanValue()) {
                List recipes = manager.method_30027(class_3956.field_17545);
                recipes = recipes.stream().filter(recipe -> !recipe.method_8110(class_310.method_1551().field_1687.method_30349()).method_7960() && !recipe.method_8110(class_310.method_1551().field_1687.method_30349()).method_31573(ItemTagGenerator.BANNED_UNCRAFTABLES) && ((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.reverseRecipeBlacklist.get()).booleanValue() == ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingRecipes.get()).contains(recipe.method_8114().toString()) && ((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.flipUncraftingModIdList.get()).booleanValue() == ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.blacklistedUncraftingModIds.get()).contains(recipe.method_8114().method_12836())).collect(Collectors.toList());
                recipes.removeIf(recipe -> recipe instanceof class_1867 && (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.allowShapelessUncrafting.get() == false);
                recipes.addAll(manager.method_30027((class_3956)TFRecipes.UNCRAFTING_RECIPE.get()));
                registration.addRecipes(JEIUncraftingCategory.UNCRAFTING, recipes);
            } else {
                ArrayList recipes = new ArrayList(manager.method_30027((class_3956)TFRecipes.UNCRAFTING_RECIPE.get()));
                registration.addRecipes(JEIUncraftingCategory.UNCRAFTING, recipes);
            }
        }
        registration.addRecipes(TransformationPowderCategory.TRANSFORMATION, manager.method_30027((class_3956)TFRecipes.TRANSFORM_POWDER_RECIPE.get()));
        registration.addRecipes(CrumbleHornCategory.CRUMBLE_HORN, manager.method_30027((class_3956)TFRecipes.CRUMBLE_RECIPE.get()));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(UncraftingScreen.class, 34, 33, 27, 20, new RecipeType[]{JEIUncraftingCategory.UNCRAFTING});
        registration.addRecipeClickArea(UncraftingScreen.class, 115, 33, 27, 20, new RecipeType[]{RecipeTypes.CRAFTING});
    }
}

