/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.rei;

import com.mojang.logging.LogUtils;
import dev.architectury.event.CompoundEventResult;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRendererRegistry;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.slf4j.Logger;
import twilightforest.TFConfig;
import twilightforest.client.UncraftingScreen;
import twilightforest.compat.rei.TwilightForestREIServerPlugin;
import twilightforest.compat.rei.categories.REICrumbleHornCategory;
import twilightforest.compat.rei.categories.REITransformationPowderCategory;
import twilightforest.compat.rei.categories.REIUncraftingCategory;
import twilightforest.compat.rei.displays.REICrumbleHornDisplay;
import twilightforest.compat.rei.displays.REITransformationPowderDisplay;
import twilightforest.compat.rei.displays.REIUncraftingDisplay;
import twilightforest.compat.rei.entries.EntityEntryDefinition;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.item.recipe.CrumbleRecipe;
import twilightforest.item.recipe.TransformPowderRecipe;
import twilightforest.item.recipe.UncraftingRecipe;

public class TwilightForestREIClientPlugin
implements REIClientPlugin {
    public static final EntityEntryDefinition ENTITY_DEFINITION = new EntityEntryDefinition();
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Map<EntryStack<class_1297>, EntryRenderer<class_1297>> RENDER_CACHE = new WeakHashMap<EntryStack<class_1297>, EntryRenderer<class_1297>>();

    public void registerCategories(CategoryRegistry registry) {
        registry.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)TFBlocks.UNCRAFTING_TABLE.get()))});
        registry.addWorkstations(TwilightForestREIServerPlugin.UNCRAFTING, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)TFBlocks.UNCRAFTING_TABLE.get()))});
        registry.addWorkstations(REICrumbleHornCategory.CRUMBLE_HORN, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)TFItems.CRUMBLE_HORN.get()))});
        registry.addWorkstations(REITransformationPowderCategory.TRANSFORMATION, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)TFItems.TRANSFORMATION_POWDER.get()))});
        registry.add((DisplayCategory)new REIUncraftingCategory());
        registry.add((DisplayCategory)new REICrumbleHornCategory());
        registry.add((DisplayCategory)new REITransformationPowderCategory());
    }

    public void registerDisplays(DisplayRegistry registry) {
        class_5455 registryAccess = class_310.method_1551().field_1687.method_30349();
        registry.registerFiller(UncraftingRecipe.class, REIUncraftingDisplay::of);
        registry.registerRecipeFiller(class_3955.class, class_3956.field_17545, recipe -> {
            TFConfig.Common.UncraftingStuff nestedConfig = TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS;
            if (recipe.method_8110(registryAccess).method_7960() || recipe.method_8110(registryAccess).method_31573(ItemTagGenerator.BANNED_UNCRAFTABLES) || ((List)nestedConfig.disableUncraftingRecipes.get()).contains(recipe.method_8114().toString()) || ((Boolean)nestedConfig.flipUncraftingModIdList.get()).booleanValue() != ((List)nestedConfig.blacklistedUncraftingModIds.get()).contains(recipe.method_8114().method_12836())) {
                return null;
            }
            return REIUncraftingDisplay.of(recipe);
        });
        registry.registerFiller(CrumbleRecipe.class, REICrumbleHornDisplay::of);
        registry.registerFiller(TransformPowderRecipe.class, REITransformationPowderDisplay::of);
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerClickArea(screen -> new Rectangle(34, 33, 27, 20), UncraftingScreen.class, new CategoryIdentifier[]{TwilightForestREIServerPlugin.UNCRAFTING});
        registry.registerClickArea(screen -> new Rectangle(115, 33, 27, 20), UncraftingScreen.class, new CategoryIdentifier[]{BuiltinPlugin.CRAFTING});
    }

    public void registerEntryRenderers(EntryRendererRegistry registry) {
        this.RENDER_CACHE.clear();
        registry.register(EntityEntryDefinition.ENTITY_TYPE, (entry, last) -> {
            Object patt4974$temp = entry.getValue();
            if (patt4974$temp instanceof class_1542) {
                class_1542 itemEntity = (class_1542)patt4974$temp;
                return this.RENDER_CACHE.computeIfAbsent((EntryStack<class_1297>)entry, entityEntryStack -> new EntityEntryDefinition.ItemEntityRender());
            }
            return last;
        });
    }

    public void registerEntryTypes(EntryTypeRegistry registry) {
        registry.register(EntityEntryDefinition.ENTITY_TYPE, (EntryDefinition)ENTITY_DEFINITION);
        registry.registerBridge(VanillaEntryTypes.ITEM, EntityEntryDefinition.ENTITY_TYPE, object -> {
            Optional<Stream<Object>> stream;
            class_1799 stack = (class_1799)object.getValue();
            try {
                class_1542 entity;
                class_1792 patt5565$temp = stack.method_7909();
                if (patt5565$temp instanceof class_1826) {
                    class_1826 spawnEggItem = (class_1826)patt5565$temp;
                    class_1299 type = spawnEggItem.method_8015(stack.method_7969());
                    entity = type.method_5883((class_1937)class_310.method_1551().field_1687);
                } else {
                    entity = TwilightForestREIClientPlugin.createItemEntity(stack);
                }
                stream = Optional.of(Stream.of(EntryStack.of((EntryDefinition)ENTITY_DEFINITION, (Object)entity)));
            }
            catch (Exception e) {
                stream = Optional.empty();
                LOGGER.error("[TwilightForestREIPlugin]: It seems that there was an attempted to create a Entity for a Itemstack but a Error occurred");
            }
            return stream.map(CompoundEventResult::interruptTrue).orElseGet(CompoundEventResult::pass);
        });
        registry.registerBridge(EntityEntryDefinition.ENTITY_TYPE, VanillaEntryTypes.ITEM, object -> {
            Optional<Stream<Object>> stream = Optional.empty();
            class_1297 entity = (class_1297)object.getValue();
            class_1799 stack = null;
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                stack = itemEntity.method_6983();
            } else {
                class_1826 spawnEggItem = class_1826.method_8019((class_1299)entity.method_5864());
                if (spawnEggItem != null) {
                    stack = spawnEggItem.method_7854();
                }
            }
            if (stack != null) {
                stream = Optional.of(Stream.of(EntryStacks.of((class_1799)stack)));
            }
            return stream.map(CompoundEventResult::interruptTrue).orElseGet(CompoundEventResult::pass);
        });
    }

    public static class_1542 createItemEntity(class_1792 item) {
        return TwilightForestREIClientPlugin.createItemEntity(item.method_7854());
    }

    public static class_1542 createItemEntity(class_1799 stack) {
        class_1542 itemEntity = (class_1542)class_1299.field_6052.method_5883((class_1937)class_310.method_1551().field_1687);
        itemEntity.method_6979(stack);
        return itemEntity;
    }
}

