/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1865;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Triple;
import twilightforest.init.TFRecipes;

public abstract class TransformationPowderProvider
implements class_2405 {
    private final class_7784 output;
    private final String modId;
    private final ExistingFileHelper helper;
    protected final Map<String, Triple<class_1299<?>, class_1299<?>, Boolean>> builders = Maps.newLinkedHashMap();

    public TransformationPowderProvider(class_7784 output, String modId, ExistingFileHelper helper) {
        this.output = output;
        this.modId = modId;
        this.helper = helper;
    }

    public abstract void registerTransforms();

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.builders.clear();
        this.registerTransforms();
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.builders.forEach((name, transform) -> {
            List<String> list = this.builders.keySet().stream().filter(s -> class_7923.field_41177.method_10250(class_7923.field_41177.method_10221((Object)((class_1299)transform.getLeft())))).filter(s -> class_7923.field_41177.method_10250(class_7923.field_41177.method_10221((Object)((class_1299)transform.getMiddle())))).filter(s -> !this.builders.containsKey(s)).filter(this::missing).toList();
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Duplicate Transformation Powder Transformations: %s", list.stream().map(Objects::toString).collect(Collectors.joining(", "))));
            }
            JsonObject obj = this.serializeToJson((class_1299)transform.getLeft(), (class_1299)transform.getMiddle(), (Boolean)transform.getRight());
            Path path = this.createPath(new class_2960(this.modId, name));
            futuresBuilder.add((Object)class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    private boolean missing(String name) {
        return this.helper == null || !this.helper.exists(new class_2960(this.modId, name), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(class_3264.field_14190, ".json", "transformation_powder"));
    }

    private Path createPath(class_2960 name) {
        return this.output.method_45971().resolve("data/" + name.method_12836() + "/recipes/transformation_powder/" + name.method_12832() + ".json");
    }

    private JsonObject serializeToJson(class_1299<?> transformFrom, class_1299<?> transformTo, boolean reversible) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", class_7923.field_41189.method_10221((Object)((class_1865)TFRecipes.TRANSFORMATION_SERIALIZER.get())).toString());
        jsonobject.addProperty("from", class_7923.field_41177.method_10221(transformFrom).toString());
        jsonobject.addProperty("to", class_7923.field_41177.method_10221(transformTo).toString());
        jsonobject.addProperty("reversible", Boolean.valueOf(reversible));
        return jsonobject;
    }

    public String method_10321() {
        return this.modId + " Transformation Powder Transformations";
    }

    public void addOneWayTransform(class_1299<?> from, class_1299<?> to) {
        this.builders.put(class_7923.field_41177.method_10221(from).method_12832() + "_to_" + class_7923.field_41177.method_10221(to).method_12832(), Triple.of(from, to, (Object)false));
    }

    public void addTwoWayTransform(class_1299<?> from, class_1299<?> to) {
        this.builders.put(class_7923.field_41177.method_10221(from).method_12832() + "_to_" + class_7923.field_41177.method_10221(to).method_12832(), Triple.of(from, to, (Object)true));
    }
}

