/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import twilightforest.entity.ai.goal.HoverBaseGoal;
import twilightforest.entity.boss.SnowQueen;

public class HoverBeamGoal
extends HoverBaseGoal<SnowQueen> {
    private int hoverTimer;
    private int beamTimer;
    private int seekTimer;
    private final int maxHoverTime;
    private final int maxBeamTime;
    private final int maxSeekTime;
    private double beamY;
    private boolean isInPosition;

    public HoverBeamGoal(SnowQueen snowQueen, int hoverTime, int dropTime) {
        super(snowQueen, 3.0f, 4.0f);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        this.maxHoverTime = hoverTime;
        this.maxSeekTime = hoverTime;
        this.maxBeamTime = dropTime;
        this.hoverTimer = 0;
        this.isInPosition = false;
    }

    public boolean method_6264() {
        class_1309 target = ((SnowQueen)this.attacker).method_5968();
        if (target == null) {
            return false;
        }
        if (!target.method_5805()) {
            return false;
        }
        return ((SnowQueen)this.attacker).getCurrentPhase() == SnowQueen.Phase.BEAM;
    }

    public boolean method_6266() {
        class_1309 target = ((SnowQueen)this.attacker).method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (((SnowQueen)this.attacker).getCurrentPhase() != SnowQueen.Phase.BEAM) {
            return false;
        }
        if (this.seekTimer >= this.maxSeekTime) {
            return false;
        }
        return this.beamTimer < this.maxBeamTime;
    }

    public void method_6270() {
        this.seekTimer = 0;
        this.hoverTimer = 0;
        this.beamTimer = 0;
        this.isInPosition = false;
        ((SnowQueen)this.attacker).setBreathing(false);
    }

    public void method_6268() {
        class_1309 target;
        if (((SnowQueen)this.attacker).method_5649(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 1.0) {
            this.isInPosition = true;
        }
        if (this.isInPosition) {
            ++this.hoverTimer;
        } else {
            ++this.seekTimer;
        }
        if (this.hoverTimer >= this.maxHoverTime) {
            ++this.beamTimer;
            ((SnowQueen)this.attacker).setBreathing(true);
            this.doRayAttack();
            this.hoverPosY -= (double)0.05f;
            if (this.hoverPosY < this.beamY) {
                this.hoverPosY = this.beamY;
            }
        }
        double offsetX = this.hoverPosX - ((SnowQueen)this.attacker).method_23317();
        double offsetY = this.hoverPosY - ((SnowQueen)this.attacker).method_23318();
        double offsetZ = this.hoverPosZ - ((SnowQueen)this.attacker).method_23321();
        double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        if ((distanceDesired = (double)class_3532.method_15355((float)((float)distanceDesired))) > 0.5) {
            double velX = offsetX / distanceDesired * 0.05;
            double velY = offsetY / distanceDesired * 0.1;
            double velZ = offsetZ / distanceDesired * 0.05;
            ((SnowQueen)this.attacker).method_5762(velX, velY += (double)0.045f, velZ);
        }
        if ((target = ((SnowQueen)this.attacker).method_5968()) != null) {
            float tracking = this.isInPosition ? 1.0f : 20.0f;
            ((SnowQueen)this.attacker).method_5951((class_1297)target, tracking, tracking);
            ((SnowQueen)this.attacker).method_5988().method_6226((class_1297)target, tracking, tracking);
        }
    }

    private void doRayAttack() {
        double range = 20.0;
        double offset = 10.0;
        class_243 srcVec = new class_243(((SnowQueen)this.attacker).method_23317(), ((SnowQueen)this.attacker).method_23318() + 0.25, ((SnowQueen)this.attacker).method_23321());
        class_243 lookVec = ((SnowQueen)this.attacker).method_5828(1.0f);
        class_243 destVec = srcVec.method_1031(lookVec.method_10216() * range, lookVec.method_10214() * range, lookVec.method_10215() * range);
        List possibleList = ((SnowQueen)this.attacker).method_37908().method_8335((class_1297)this.attacker, ((SnowQueen)this.attacker).method_5829().method_989(lookVec.method_10216() * offset, lookVec.method_10214() * offset, lookVec.method_10215() * offset).method_1009(range, range, range));
        double hitDist = 0.0;
        if (((SnowQueen)this.attacker).isMultipartEntity()) {
            possibleList.removeAll(Arrays.asList(Objects.requireNonNull(((SnowQueen)this.attacker).getParts())));
        }
        for (class_1297 possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.method_5863() || possibleEntity == this.attacker) continue;
            float borderSize = possibleEntity.method_5871();
            class_238 collisionBB = possibleEntity.method_5829().method_1009((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.method_992(srcVec, destVec);
            if (collisionBB.method_1006(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                ((SnowQueen)this.attacker).doBreathAttack(possibleEntity);
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.method_1022((class_243)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            ((SnowQueen)this.attacker).doBreathAttack(possibleEntity);
            hitDist = possibleDist;
        }
    }

    @Override
    protected void makeNewHoverSpot(class_1309 target) {
        super.makeNewHoverSpot(target);
        this.beamY = target.method_23318();
        this.seekTimer = 0;
    }
}

