/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_8111;
import twilightforest.entity.ai.goal.HeavySpearAttackGoal;
import twilightforest.init.TFSounds;

public class UpperGoblinKnight
extends class_1588 {
    private static final int SHIELD_DAMAGE_THRESHOLD = 10;
    private static final class_2940<Byte> DATA_EQUIP = class_2945.method_12791(UpperGoblinKnight.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> SHIELD_DISABLED = class_2945.method_12791(UpperGoblinKnight.class, (class_2941)class_2943.field_13323);
    private static final class_1322 ARMOR_MODIFIER = new class_1322("Armor boost", 20.0, class_1322.class_1323.field_6328);
    private static final class_1322 DAMAGE_MODIFIER = new class_1322("Heavy spear attack boost", 12.0, class_1322.class_1323.field_6328);
    public static final int HEAVY_SPEAR_TIMER_START = 60;
    private int shieldHits = 0;
    private int shieldDisabledTicks;
    public int heavySpearTimer;

    public UpperGoblinKnight(class_1299<? extends UpperGoblinKnight> type, class_1937 level) {
        super(type, level);
        this.setHasArmor(true);
        this.setHasShield(true);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new HeavySpearAttackGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 1.0, false){

            public boolean method_6264() {
                return !this.field_6503.method_5765() && ((UpperGoblinKnight)this.field_6503).heavySpearTimer <= 0 && super.method_6264();
            }
        });
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23719, 0.28).method_26868(class_5134.field_23721, 8.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(DATA_EQUIP, (Object)0);
        this.method_5841().method_12784(SHIELD_DISABLED, (Object)false);
    }

    public boolean hasArmor() {
        return ((Byte)this.method_5841().method_12789(DATA_EQUIP) & 1) > 0;
    }

    private void setHasArmor(boolean flag) {
        byte otherFlags = (Byte)this.method_5841().method_12789(DATA_EQUIP);
        this.method_5841().method_12778(DATA_EQUIP, (Object)(flag ? (byte)(otherFlags | 1) : (byte)(otherFlags & 0xFFFFFFFE)));
        if (!this.method_37908().method_8608()) {
            if (flag) {
                if (!Objects.requireNonNull(this.method_5996(class_5134.field_23724)).method_6196(ARMOR_MODIFIER)) {
                    Objects.requireNonNull(this.method_5996(class_5134.field_23724)).method_26835(ARMOR_MODIFIER);
                }
            } else {
                Objects.requireNonNull(this.method_5996(class_5134.field_23724)).method_6202(ARMOR_MODIFIER);
            }
        }
    }

    public boolean hasShield() {
        return ((Byte)this.method_5841().method_12789(DATA_EQUIP) & 2) != 0;
    }

    public void setHasShield(boolean flag) {
        byte otherFlags = (Byte)this.method_5841().method_12789(DATA_EQUIP);
        this.method_5841().method_12778(DATA_EQUIP, (Object)(flag ? (byte)(otherFlags | 2) : (byte)(otherFlags & 0xFFFFFFFD)));
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("hasArmor", this.hasArmor());
        compound.method_10556("hasShield", this.hasShield());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setHasArmor(compound.method_10577("hasArmor"));
        this.setHasShield(compound.method_10577("hasShield"));
    }

    public void method_6007() {
        super.method_6007();
        if ((this.method_37908().method_8608() || !this.method_5987()) && this.heavySpearTimer > 0) {
            --this.heavySpearTimer;
        }
        if (this.isShieldDisabled()) {
            this.method_37908().method_8406((class_2394)class_2398.field_11202, this.method_23317() + (this.method_6051().method_43058() - 0.5) * (double)this.method_17681() * 0.25, this.method_23318() + (double)this.method_5751(), this.method_23321() + (this.method_6051().method_43058() - 0.5) * (double)this.method_17681() * 0.25, (double)((this.method_6051().method_43057() - 0.5f) * 0.75f), 0.0, (double)((this.method_6051().method_43057() - 0.5f) * 0.75f));
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)TFSounds.GOBLIN_KNIGHT_AMBIENT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)TFSounds.GOBLIN_KNIGHT_DEATH.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)TFSounds.GOBLIN_KNIGHT_HURT.get();
    }

    public void method_5958() {
        super.method_5958();
        if (this.isShieldDisabled() && this.shieldDisabledTicks++ >= 100) {
            this.shieldDisabledTicks = 0;
            this.method_5841().method_12778(SHIELD_DISABLED, (Object)false);
        }
        if (this.method_5805()) {
            class_1297 class_12972 = this.method_5854();
            if (class_12972 instanceof class_1308) {
                class_1308 mob = (class_1308)class_12972;
                if (this.method_5968() == null) {
                    this.method_5980(mob.method_5968());
                }
            }
            if (!this.method_5765() && this.hasShield()) {
                this.breakShield();
            }
            if (this.heavySpearTimer > 0) {
                if (!Objects.requireNonNull(this.method_5996(class_5134.field_23721)).method_6196(DAMAGE_MODIFIER)) {
                    Objects.requireNonNull(this.method_5996(class_5134.field_23721)).method_26835(DAMAGE_MODIFIER);
                }
            } else {
                Objects.requireNonNull(this.method_5996(class_5134.field_23721)).method_6200(DAMAGE_MODIFIER.method_6189());
            }
        }
    }

    public void landHeavySpearAttack() {
        class_243 vector = this.method_5720();
        double dist = 1.25;
        double px = this.method_23317() + vector.method_10216() * dist;
        double py = this.method_5829().field_1322 - (this.method_5765() ? 0.75 : 0.0);
        double pz = this.method_23321() + vector.method_10215() * dist;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            for (int i = 0; i < 50; ++i) {
                server.method_14199((class_2394)class_2398.field_11237, px, py, pz, 1, (double)((this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.25f), 0.0, (double)((this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.25f), 0.0);
            }
        }
        double radius = 1.5;
        class_238 spearBB = new class_238(px - radius, py - radius, pz - radius, px + radius, py + radius, pz + radius);
        List inBox = this.method_37908().method_8333((class_1297)this, spearBB, e -> e != this.method_5854());
        for (class_1297 entity : inBox) {
            super.method_6121(entity);
        }
        if (!inBox.isEmpty()) {
            this.method_5783(class_3417.field_15016, this.method_6107(), this.method_6017());
        }
        this.method_32876(class_5712.field_28159);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte id) {
        if (id == 4) {
            this.heavySpearTimer = 60;
        } else if (id == 5) {
            class_1799 broken = new class_1799((class_1935)class_1802.field_8523);
            this.method_6045(broken);
            this.method_6045(broken);
            this.method_6045(broken);
        } else {
            super.method_5711(id);
        }
    }

    public boolean method_6121(class_1297 entity) {
        if (this.heavySpearTimer > 0) {
            return false;
        }
        if (this.method_6051().method_43048(2) == 0) {
            this.heavySpearTimer = 60;
            this.method_37908().method_8421((class_1297)this, (byte)4);
            return false;
        }
        this.method_6104(class_1268.field_5808);
        return super.method_6121(entity);
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        if (damageSource.method_49708(class_8111.field_42340) && this.method_5854() != null) {
            return false;
        }
        class_1297 attacker = damageSource.method_5529();
        if (attacker != null) {
            double dx = this.method_23317() - attacker.method_23317();
            double dz = this.method_23321() - attacker.method_23321();
            float angle = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float difference = class_3532.method_15379((float)((this.field_6283 - angle) % 360.0f));
            if (this.hasShield() && difference > 150.0f && difference < 230.0f) {
                if (this.takeHitOnShield(damageSource, amount)) {
                    return false;
                }
            } else if (this.hasShield() && this.method_6051().method_43056()) {
                this.damageShield();
            }
            if (this.hasArmor() && (difference > 300.0f || difference < 60.0f)) {
                this.breakArmor();
            }
        }
        return super.method_5643(damageSource, amount);
    }

    private void breakArmor() {
        this.method_37908().method_8421((class_1297)this, (byte)5);
        this.setHasArmor(false);
    }

    private void breakShield() {
        this.method_37908().method_8421((class_1297)this, (byte)5);
        this.setHasShield(false);
    }

    public boolean isShieldDisabled() {
        return (Boolean)this.method_5841().method_12789(SHIELD_DISABLED);
    }

    public boolean takeHitOnShield(class_1282 source, float amount) {
        UpperGoblinKnight toKnockback;
        class_1309 living;
        if (this.isShieldDisabled()) {
            return false;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309 && (living = (class_1309)class_12972).method_6047().method_7909() instanceof class_1743 && !this.method_37908().method_8608()) {
            this.method_5841().method_12778(SHIELD_DISABLED, (Object)true);
            this.method_5783(class_3417.field_15239, 1.0f, 0.8f + this.method_37908().method_8409().method_43057() * 0.4f);
            return true;
        }
        if (amount > 10.0f && !this.method_37908().method_8608()) {
            this.damageShield();
        } else {
            this.method_5783(class_3417.field_15150, 1.0f, 0.8f + this.method_37908().method_8409().method_43057() * 0.4f);
        }
        UpperGoblinKnight upperGoblinKnight = toKnockback = this.method_5854() instanceof class_1309 ? (class_1309)this.method_5854() : this;
        if (source.method_5529() != null) {
            double d0 = source.method_5529().method_23317() - this.method_23317();
            double d1 = source.method_5529().method_23321() - this.method_23321();
            while (d0 * d0 + d1 * d1 < 1.0E-4) {
                d0 = (Math.random() - Math.random()) * 0.01;
                d1 = (Math.random() - Math.random()) * 0.01;
            }
            toKnockback.method_6005(0.0, d0 / 4.0, d1 / 4.0);
            class_1297 class_12973 = source.method_5529();
            if (class_12973 instanceof class_1309) {
                class_1309 living2 = (class_1309)class_12973;
                this.method_6015(living2);
            }
        }
        return true;
    }

    private void damageShield() {
        this.method_5783(class_3417.field_14670, 0.25f, 0.25f);
        ++this.shieldHits;
        if (!this.method_37908().method_8608() && this.shieldHits >= 3) {
            this.breakShield();
        }
    }
}

