/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4208;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.ai.control.NoClipMoveControl;
import twilightforest.entity.ai.goal.SimplifiedAttackGoal;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;

public class Wraith
extends class_1307
implements class_1569,
EnforcedHomePoint {
    private static final class_2940<Optional<class_4208>> HOME_POINT = class_2945.method_12791(Wraith.class, (class_2941)class_2943.field_38825);

    public Wraith(class_1299<? extends Wraith> type, class_1937 level) {
        super(type, level);
        this.field_6207 = new NoClipMoveControl((class_1308)this);
        this.field_5960 = true;
    }

    protected void method_5959() {
        this.field_6201.method_6277(2, (class_1352)new MoveTowardsHomeGoal(this, 0.85));
        this.field_6201.method_6277(4, (class_1352)new SimplifiedAttackGoal((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new FlyTowardsTargetGoal(this));
        this.field_6201.method_6277(6, (class_1352)new RandomFloatAroundGoal(this));
        this.field_6201.method_6277(7, (class_1352)new LookAroundGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23721, 5.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(HOME_POINT, Optional.empty());
    }

    public boolean method_21749() {
        return true;
    }

    protected boolean method_23734() {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (super.method_5643(source, amount)) {
            class_1297 entity = source.method_5529();
            if (this.method_5854() == entity || this.method_5685().contains(entity)) {
                return true;
            }
            if (entity != this && entity instanceof class_1309 && !source.method_5530()) {
                this.method_5980((class_1309)entity);
            }
            return true;
        }
        return false;
    }

    public boolean method_6121(class_1297 entity) {
        entity.method_5643(TFDamageTypes.getEntityDamageSource(this.method_37908(), TFDamageTypes.HAUNT, (class_1297)this, new class_1299[0]), (float)this.method_26825(class_5134.field_23721));
        return super.method_6121(entity);
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    protected class_3414 method_5994() {
        return (class_3414)TFSounds.WRAITH_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)TFSounds.WRAITH_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)TFSounds.WRAITH_DEATH.get();
    }

    public static boolean checkMonsterSpawnRules(class_1299<? extends Wraith> entity, class_5425 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8407() != class_1267.field_5801 && class_1588.method_20679((class_5425)world, (class_2338)pos, (class_5819)random) && Wraith.method_20636(entity, (class_1936)world, (class_3730)reason, (class_2338)pos, (class_5819)random);
    }

    public class_1315 method_5943(class_5425 accessor, class_1266 difficulty, class_3730 type, @Nullable class_1315 data, @Nullable class_2487 tag) {
        if (type == class_3730.field_16474 || type == class_3730.field_16469) {
            this.setRestrictionPoint(class_4208.method_19443((class_5321)accessor.method_8410().method_27983(), (class_2338)this.method_24515()));
        }
        return super.method_5943(accessor, difficulty, type, data, tag);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        this.saveHomePointToNbt(tag);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.loadHomePointFromNbt(tag);
    }

    @Override
    @Nullable
    public class_4208 getRestrictionPoint() {
        return ((Optional)this.method_5841().method_12789(HOME_POINT)).orElse(null);
    }

    @Override
    public void setRestrictionPoint(@Nullable class_4208 pos) {
        this.method_5841().method_12778(HOME_POINT, Optional.ofNullable(pos));
    }

    @Override
    public int getHomeRadius() {
        return 20;
    }

    public static class MoveTowardsHomeGoal
    extends class_1352 {
        private final Wraith mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;

        public MoveTowardsHomeGoal(Wraith mob, double speedModifier) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.mob.isMobWithinHomeArea((class_1297)this.mob) || this.mob.method_5968() != null) {
                return false;
            }
            class_2338 pos = this.mob.getRestrictionPoint().method_19446().method_10093(class_2350.method_10162((class_5819)this.mob.method_6051())).method_10069(this.mob.method_6051().method_43048(5), this.mob.method_6051().method_43048(5), this.mob.method_6051().method_43048(5));
            if (!this.mob.method_37908().method_8477(pos)) {
                return false;
            }
            this.wantedX = pos.method_10263();
            this.wantedY = pos.method_10264();
            this.wantedZ = pos.method_10260();
            return true;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            this.mob.method_5962().method_6239(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }
    }

    static class FlyTowardsTargetGoal
    extends class_1352 {
        private final Wraith wraith;

        FlyTowardsTargetGoal(Wraith wraith) {
            this.wraith = wraith;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return this.wraith.method_5968() != null;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            class_1309 target = this.wraith.method_5968();
            if (target != null) {
                this.wraith.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 0.5);
            }
        }
    }

    static class RandomFloatAroundGoal
    extends class_1352 {
        private final Wraith wraith;

        public RandomFloatAroundGoal(Wraith wraith) {
            this.wraith = wraith;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            double d2;
            double d1;
            if (this.wraith.method_5968() != null || !this.wraith.isMobWithinHomeArea((class_1297)this.wraith)) {
                return false;
            }
            class_1335 control = this.wraith.method_5962();
            double d0 = control.method_6236() - this.wraith.method_23317();
            double d3 = d0 * d0 + (d1 = control.method_6235() - this.wraith.method_23318()) * d1 + (d2 = control.method_6237() - this.wraith.method_23321()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            class_5819 random = this.wraith.method_6051();
            double d0 = this.wraith.method_23317() + (double)((random.method_43057() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.wraith.method_23318() + (double)((random.method_43057() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.wraith.method_23321() + (double)((random.method_43057() * 2.0f - 1.0f) * 16.0f);
            this.wraith.method_5962().method_6239(d0, d1, d2, 0.5);
        }
    }

    public static class LookAroundGoal
    extends class_1352 {
        private final Wraith wraith;

        public LookAroundGoal(Wraith wraith) {
            this.wraith = wraith;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return true;
        }

        public void method_6268() {
            if (this.wraith.method_5968() == null) {
                this.wraith.method_36456(-((float)class_3532.method_15349((double)this.wraith.method_18798().method_10216(), (double)this.wraith.method_18798().method_10215())) * 57.295776f);
                this.wraith.method_5636(this.wraith.method_36454());
            } else {
                class_1309 entitylivingbase = this.wraith.method_5968();
                if (entitylivingbase.method_5858((class_1297)this.wraith) < 4096.0) {
                    double d1 = entitylivingbase.method_23317() - this.wraith.method_23317();
                    double d2 = entitylivingbase.method_23321() - this.wraith.method_23321();
                    this.wraith.method_36456(-((float)class_3532.method_15349((double)d1, (double)d2)) * 57.295776f);
                    this.wraith.method_5636(this.wraith.method_36454());
                }
            }
        }
    }
}

