/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.Iterator;
import net.minecraft.class_2338;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class RectangleLatticeIterator<T>
implements Iterator<T>,
Iterable<T> {
    private final int yLevel;
    private final int latticeStartX;
    private final int latticeStartZ;
    private final int latticeCountX;
    private final int latticeCountZ;
    private final float xSpacing;
    private final float zSpacing;
    private final float xOffset;
    private final float zOffset;
    private final TernaryIntegerFunction<T> converter;
    private int latticeX = 0;
    private int latticeZ = 0;

    public static RectangleLatticeIterator<class_2338.class_2339> boundedGrid(class_3341 chunkBounds, int yLevel, float xSpacing, float zSpacing, float xOffset, float zOffset) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        return new RectangleLatticeIterator<class_2338.class_2339>(chunkBounds.method_35415(), chunkBounds.method_35417(), chunkBounds.method_35418(), chunkBounds.method_35420(), yLevel, xSpacing, zSpacing, xOffset, zOffset, (arg_0, arg_1, arg_2) -> ((class_2338.class_2339)mutableBlockPos).method_10103(arg_0, arg_1, arg_2));
    }

    public RectangleLatticeIterator(int minX, int minZ, int maxX, int maxZ, int yLevel, float xSpacing, float zSpacing, float xOffset, float zOffset, TernaryIntegerFunction<T> converter) {
        this.yLevel = yLevel;
        this.xSpacing = xSpacing;
        this.zSpacing = zSpacing;
        this.xOffset = xOffset;
        this.zOffset = zOffset;
        this.latticeStartX = RectangleLatticeIterator.getNearestStartLatticeIndex(this.xSpacing, (float)minX - this.xOffset);
        this.latticeStartZ = RectangleLatticeIterator.getNearestStartLatticeIndex(this.zSpacing, (float)minZ - this.zOffset);
        this.latticeCountX = RectangleLatticeIterator.getNearestEndLatticeIndex(this.xSpacing, (float)maxX + 0.999f - this.xOffset) - this.latticeStartX + 1;
        this.latticeCountZ = RectangleLatticeIterator.getNearestEndLatticeIndex(this.zSpacing, (float)maxZ + 0.999f - this.zOffset) - this.latticeStartZ + 1;
        this.converter = converter;
    }

    @Override
    public T next() {
        T ret = this.converter.apply(this.generateX(), this.yLevel, this.generateZ());
        if (this.latticeZ + 1 < this.latticeCountZ) {
            ++this.latticeZ;
        } else {
            this.latticeZ = 0;
            ++this.latticeX;
        }
        return ret;
    }

    private int generateX() {
        return (int)(this.xOffset + (float)(this.latticeStartX + this.latticeX) * this.xSpacing);
    }

    private int generateZ() {
        return (int)(this.zOffset + (float)(this.latticeStartZ + this.latticeZ) * this.zSpacing);
    }

    @Override
    public boolean hasNext() {
        return this.latticeX < this.latticeCountX;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this;
    }

    private static int getNearestStartLatticeIndex(float latticeSpacing, float i) {
        return class_3532.method_15375((float)((i + class_3532.method_15341((float)(-i), (float)latticeSpacing)) / latticeSpacing));
    }

    private static int getNearestEndLatticeIndex(float latticeSpacing, float i) {
        return class_3532.method_15375((float)((i - class_3532.method_15341((float)i, (float)latticeSpacing)) / latticeSpacing));
    }

    @FunctionalInterface
    public static interface TernaryIntegerFunction<T> {
        public T apply(int var1, int var2, int var3);
    }
}

