/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import io.github.fabricators_of_create.porting_lib.common.util.IPlantable;
import java.util.function.BiConsumer;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2541;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.loot.TFLootTables;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.FeatureUtil;
import twilightforest.util.VoxelBresenhamIterator;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFTreeFeature;

public class HollowTreeFeature
extends TFTreeFeature<TFTreeFeatureConfig> {
    private static final int LEAF_DUNGEON_CHANCE = 8;

    public HollowTreeFeature(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    public boolean generate(class_5281 world, class_5819 random, class_2338 pos, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, BiConsumer<class_2338, class_2680> decorationPlacer, TFTreeFeatureConfig config) {
        int diameter = random.method_43048(3) + 2;
        int height = random.method_43048(64) + diameter * 4;
        if (world.method_31601(pos.method_10264()) || world.method_31601(pos.method_10264() + height + diameter)) {
            return false;
        }
        int crownRadius = diameter * 4 + 8;
        for (int dx = -crownRadius; dx <= crownRadius; ++dx) {
            for (int dz = -crownRadius; dz <= crownRadius; ++dz) {
                for (int dy = height - crownRadius; dy <= height + crownRadius; ++dy) {
                    class_2248 whatsThere = world.method_8320(pos.method_10069(dx, dy, dz)).method_26204();
                    if (whatsThere == class_2246.field_10124 || whatsThere instanceof class_2397) continue;
                    return false;
                }
            }
        }
        class_2680 state = world.method_8320(pos.method_10074());
        if (!state.method_26204().canSustainPlant(state, (class_1922)world, pos.method_10074(), class_2350.field_11036, (IPlantable)TFBlocks.HOLLOW_OAK_SAPLING.get())) {
            return false;
        }
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, 3, 2, 6, 0.75, 3, 5, 3, false, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, 1, 2, 8, 0.9, 3, 5, 3, false, config);
        this.buildTrunk((class_1936)world, trunkPlacer, decorationPlacer, random, pos, diameter, height, config);
        int numFireflies = random.method_43048(6 * diameter) + 5;
        for (int i = 0; i <= numFireflies; ++i) {
            int fHeight = (int)((double)height * random.method_43058() * 0.9) + height / 10;
            double fAngle = random.method_43058();
            this.addFirefly((class_1936)world, pos, diameter, fHeight, fAngle);
        }
        int numCicadas = random.method_43048(3 * diameter) + 5;
        for (int i = 0; i <= numCicadas; ++i) {
            int fHeight = (int)((double)height * random.method_43058() * 0.9) + height / 10;
            double fAngle = random.method_43058();
            this.addCicada((class_1936)world, pos, diameter, fHeight, fAngle);
        }
        this.buildFullCrown(world, trunkPlacer, leavesPlacer, random, pos, diameter, height, config);
        int numBranches = random.method_43048(3) + 3;
        for (int i = 0; i <= numBranches; ++i) {
            int branchHeight = (int)((double)height * random.method_43058() * 0.9) + height / 10;
            double branchRotation = random.method_43058();
            this.makeSmallBranch((class_1936)world, trunkPlacer, leavesPlacer, random, pos, diameter, branchHeight, 4.0, branchRotation, 0.35, true, config);
        }
        return true;
    }

    protected void buildFullCrown(class_5281 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, class_5819 random, class_2338 pos, int diameter, int height, TFTreeFeatureConfig config) {
        int crownRadius = diameter * 4 + 2;
        int bvar = diameter + 2;
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height - crownRadius, 0, crownRadius, 0.35, bvar, bvar + 2, 2, true, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height - crownRadius / 2, 0, crownRadius, 0.28, bvar, bvar + 2, 1, true, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height, 0, crownRadius, 0.15, 2, 4, 2, true, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, diameter, height, 0, crownRadius / 2, 0.05, bvar, bvar + 2, 1, true, config);
    }

    protected void buildBranchRing(class_5281 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, class_5819 random, class_2338 pos, int diameter, int branchHeight, int heightVar, int length, double tilt, int minBranches, int maxBranches, int size, boolean leafy, TFTreeFeatureConfig config) {
        int numBranches = random.method_43048(maxBranches - minBranches) + minBranches;
        double branchRotation = 1.0 / (double)(numBranches + 1);
        double branchOffset = random.method_43058();
        for (int i = 0; i <= numBranches; ++i) {
            int dHeight = heightVar > 0 ? branchHeight - heightVar + random.method_43048(2 * heightVar) : branchHeight;
            if (size == 2) {
                this.makeLargeBranch(world, trunkPlacer, leavesPlacer, random, pos, diameter, dHeight, length - 3, (double)i * branchRotation + branchOffset, tilt, leafy, config);
                continue;
            }
            if (size == 1) {
                this.makeMedBranch((class_1936)world, trunkPlacer, leavesPlacer, random, pos, diameter, dHeight, length - 1, (double)i * branchRotation + branchOffset, tilt, leafy, config);
                continue;
            }
            if (size == 3) {
                this.makeRoot((class_1936)world, random, pos, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, config);
                continue;
            }
            this.makeSmallBranch((class_1936)world, trunkPlacer, leavesPlacer, random, pos, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy, config);
        }
    }

    protected void buildTrunk(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> decoPlacer, class_5819 random, class_2338 pos, int diameter, int height, TFTreeFeatureConfig config) {
        int dy;
        int dz;
        int dx;
        int hollow = diameter >> 1;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = -4; dy < 0; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = Math.max(ax, az = Math.abs(dz)) + (Math.min(ax, az) >> 1);
                    if (dist > diameter) continue;
                    class_2338 dPos = pos.method_10069(dx, dy, dz);
                    if (FeatureUtil.hasAirAround(world, dPos)) {
                        if (dist > hollow) {
                            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, random, dPos, config.trunkProvider);
                            continue;
                        }
                        FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, random, dPos, config.branchProvider);
                        continue;
                    }
                    FeaturePlacers.placeIfValidRootPos((class_3746)world, decoPlacer, random, dPos, config.rootsProvider);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = 0; dy <= height; ++dy) {
                    int az;
                    class_2338 dPos = pos.method_10069(dx, dy, dz);
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist <= diameter && dist > hollow) {
                        FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, random, dPos, config.trunkProvider);
                    }
                    if (dist <= hollow) {
                        // empty if block
                    }
                    if (dist != hollow || dx != hollow) continue;
                    world.method_8652(dPos, (class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)class_2541.field_11702, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
        }
    }

    protected void makeMedBranch(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, class_5819 random, class_2338 pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        class_2338 src = FeatureLogic.translate(pos.method_10086(branchHeight), diameter, angle, 0.5);
        this.makeMedBranch(world, trunkPlacer, leavesPlacer, random, src, length, angle, tilt, leafy, config);
    }

    protected void makeMedBranch(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, class_5819 random, class_2338 src, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        class_2338 dest = FeatureLogic.translate(src, length, angle, tilt);
        FeaturePlacers.drawBresenhamBranch(world, trunkPlacer, random, src, dest, config.branchProvider);
        if (leafy) {
            FeaturePlacers.placeSpheroid((class_3746)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, random, dest, 2.5f, 2.5f, config.leavesProvider);
        }
        int numShoots = random.method_43048(2) + 1;
        double angleInc = 0.8 / (double)numShoots;
        for (int i = 0; i <= numShoots; ++i) {
            double angleVar = angleInc * (double)i - 0.4;
            double outVar = random.method_43058() * 0.8 + 0.2;
            double tiltVar = random.method_43058() * 0.75 + 0.15;
            class_2338 bsrc = FeatureLogic.translate(src, length * outVar, angle, tilt);
            double slength = length * 0.4;
            this.makeSmallBranch(world, trunkPlacer, leavesPlacer, random, bsrc, slength, angle + angleVar, tilt * tiltVar, leafy, config);
        }
    }

    protected void makeSmallBranch(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, class_5819 random, class_2338 src, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        class_2338 dest = FeatureLogic.translate(src, length, angle, tilt);
        FeaturePlacers.drawBresenhamBranch(world, trunkPlacer, random, src, dest, config.branchProvider);
        if (leafy) {
            float leafRad = (float)random.method_43048(2) + 1.5f;
            FeaturePlacers.placeSpheroid((class_3746)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, random, dest, leafRad, leafRad, config.leavesProvider);
        }
    }

    protected void makeSmallBranch(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, class_5819 random, class_2338 pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        class_2338 src = FeatureLogic.translate(pos.method_10086(branchHeight), diameter, angle, 0.5);
        this.makeSmallBranch(world, trunkPlacer, leavesPlacer, random, src, length, angle, tilt, leafy, config);
    }

    protected void makeRoot(class_1936 worldReader, class_5819 random, class_2338 pos, int diameter, int branchHeight, double length, double angle, double tilt, TFTreeFeatureConfig config) {
        class_2338 src = FeatureLogic.translate(pos.method_10086(branchHeight), diameter, angle, 0.5);
        class_2338 dest = FeatureLogic.translate(src, length, angle, tilt);
        FeaturePlacers.traceExposedRoot((class_3746)worldReader, (checkedPos, state) -> worldReader.method_8652(checkedPos, state, 3), random, config.branchProvider, config.rootsProvider, new VoxelBresenhamIterator(src, dest));
    }

    protected void makeLargeBranch(class_5281 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, class_5819 random, class_2338 src, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        class_2338 dest = FeatureLogic.translate(src, length, angle, tilt);
        FeaturePlacers.drawBresenhamBranch((class_1936)world, trunkPlacer, random, src, dest, config.branchProvider);
        int reinforcements = random.method_43048(3);
        for (int i = 0; i <= reinforcements; ++i) {
            int vx = (i & 2) == 0 ? 1 : 0;
            int vy = (i & 1) == 0 ? 1 : -1;
            int vz = (i & 2) == 0 ? 0 : 1;
            FeaturePlacers.drawBresenhamBranch((class_1936)world, trunkPlacer, random, src.method_10069(vx, vy, vz), dest, config.branchProvider);
        }
        if (leafy) {
            FeaturePlacers.placeSpheroid((class_3746)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, random, dest.method_10084(), 3.5f, 3.5f, config.leavesProvider);
        }
        int numMedBranches = random.method_43048((int)(length / 6.0)) + random.method_43048(2) + 1;
        for (int i = 0; i <= numMedBranches; ++i) {
            double outVar = random.method_43058() * 0.3 + 0.3;
            double angleVar = random.method_43058() * 0.225 * ((i & 1) == 0 ? 1.0 : -1.0);
            class_2338 bsrc = FeatureLogic.translate(src, length * outVar, angle, tilt);
            this.makeMedBranch((class_1936)world, trunkPlacer, leavesPlacer, random, bsrc, length * 0.6, angle + angleVar, tilt, leafy, config);
        }
        int numSmallBranches = random.method_43048(2) + 1;
        for (int i = 0; i <= numSmallBranches; ++i) {
            double outVar = random.method_43058() * 0.25 + 0.25;
            double angleVar = random.method_43058() * 0.25 * ((i & 1) == 0 ? 1.0 : -1.0);
            class_2338 bsrc = FeatureLogic.translate(src, length * outVar, angle, tilt);
            this.makeSmallBranch((class_1936)world, trunkPlacer, leavesPlacer, random, bsrc, Math.max(length * 0.3, 2.0), angle + angleVar, tilt, leafy, config);
        }
        if (random.method_43048(8) == 0) {
            this.makeLeafDungeon(world, leavesPlacer, random, dest.method_10084(), config);
        }
    }

    private void makeLeafDungeon(class_5281 world, BiConsumer<class_2338, class_2680> leavesPlacer, class_5819 random, class_2338 pos, TFTreeFeatureConfig config) {
        FeaturePlacers.placeSpheroid((class_3746)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, random, pos, 4.5f, 4.5f, config.leavesProvider);
        FeatureUtil.drawBlob((class_1936)world, pos, 3, config.branchProvider.method_23455(random, pos));
        FeatureUtil.drawBlob((class_1936)world, pos, 2, class_2246.field_10124.method_9564());
        world.method_8652(pos.method_10084(), class_2246.field_10260.method_9564(), 18);
        class_2636 ms = (class_2636)world.method_8321(pos.method_10084());
        if (ms != null) {
            ms.method_46408((class_1299)TFEntities.SWARM_SPIDER.get(), random);
        }
        this.makeLeafDungeonChest(world, random, pos);
    }

    private void makeLeafDungeonChest(class_5281 world, class_5819 random, class_2338 pos) {
        class_2350 chestDir = class_2350.class_2353.field_11062.method_10183(random);
        pos = pos.method_10079(chestDir, 2);
        TFLootTables.TREE_CACHE.generateChest(world, pos.method_10074(), chestDir.method_10153(), false);
    }

    protected void makeLargeBranch(class_5281 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, class_5819 random, class_2338 pos, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, TFTreeFeatureConfig config) {
        class_2338 src = FeatureLogic.translate(pos.method_10086(branchHeight), diameter, angle, 0.5);
        this.makeLargeBranch(world, trunkPlacer, leavesPlacer, random, src, length, angle, tilt, leafy, config);
    }

    protected void addFirefly(class_1936 world, class_2338 pos, int diameter, int fHeight, double fAngle) {
        class_2338 src = FeatureLogic.translate(pos.method_10086(fHeight), diameter + 1, fAngle, 0.5);
        class_2350 facing = class_2350.field_11034;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            facing = class_2350.field_11035;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            facing = class_2350.field_11034;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            facing = class_2350.field_11043;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            facing = class_2350.field_11039;
        }
        if (((class_2680)((class_2248)TFBlocks.FIREFLY.get()).method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)facing)).method_26184((class_4538)world, src)) {
            world.method_8652(src, (class_2680)((class_2248)TFBlocks.FIREFLY.get()).method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)facing), 3);
        }
    }

    protected void addCicada(class_1936 world, class_2338 pos, int diameter, int fHeight, double fAngle) {
        class_2338 src = FeatureLogic.translate(pos.method_10086(fHeight), diameter + 1, fAngle, 0.5);
        class_2350 facing = class_2350.field_11034;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            facing = class_2350.field_11035;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            facing = class_2350.field_11034;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            facing = class_2350.field_11043;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            facing = class_2350.field_11039;
        }
        if (((class_2680)((class_2248)TFBlocks.CICADA.get()).method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)facing)).method_26184((class_4538)world, src)) {
            world.method_8652(src, (class_2680)((class_2248)TFBlocks.CICADA.get()).method_9564().method_11657((class_2769)class_2318.field_10927, (Comparable)facing), 3);
        }
    }
}

