/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2276;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.loot.TFLootTables;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.TFMaze;
import twilightforest.world.components.structures.TFStructureComponentOld;

public class HedgeMazeComponent
extends TFStructureComponentOld {
    private static final int MSIZE = 16;
    private static final int RADIUS = 25;
    private static final int DIAMETER = 50;
    private static final int FLOOR_LEVEL = 0;

    public HedgeMazeComponent(class_6625 ctx, class_2487 nbt) {
        super((class_3773)TFStructurePieceTypes.TFHedge.get(), nbt);
        this.field_15315 = BoundingBoxUtils.NBTToBoundingBox(nbt);
    }

    public HedgeMazeComponent(int i, int x, int y, int z) {
        super((class_3773)TFStructurePieceTypes.TFHedge.get(), i, x, y, z);
        this.method_14926(class_2350.field_11035);
        this.field_15315 = TFLandmark.getComponentToAddBoundingBox(x, y, z, -25, -3, -25, 50, 10, 50, class_2350.field_11035, false);
    }

    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, class_5819 rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        TFMaze maze = new TFMaze(16, 16);
        maze.oddBias = 2;
        maze.torchBlockState = ((class_2248)TFBlocks.FIREFLY.get()).method_9564();
        maze.wallBlockState = ((class_2248)TFBlocks.HEDGE.get()).method_9564();
        maze.type = 4;
        maze.tall = 3;
        maze.roots = 3;
        maze.setSeed(world.method_8412() + (long)this.field_15315.method_35415() * (long)this.field_15315.method_35417());
        for (int fx = 0; fx <= 50; ++fx) {
            for (int fz = 0; fz <= 50; ++fz) {
                this.method_14917(world, class_2246.field_10219.method_9564(), fx, -1, fz, sbb);
            }
        }
        class_2680 northJacko = (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)class_2350.field_11035);
        class_2680 southJacko = (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)class_2350.field_11043);
        class_2680 westJacko = (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)class_2350.field_11034);
        class_2680 eastJacko = (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)class_2350.field_11039);
        this.method_14917(world, westJacko, 0, 0, 24, sbb);
        this.method_14917(world, westJacko, 0, 0, 29, sbb);
        this.method_14917(world, eastJacko, 50, 0, 24, sbb);
        this.method_14917(world, eastJacko, 50, 0, 29, sbb);
        this.method_14917(world, northJacko, 24, 0, 0, sbb);
        this.method_14917(world, northJacko, 29, 0, 0, sbb);
        this.method_14917(world, southJacko, 24, 0, 50, sbb);
        this.method_14917(world, southJacko, 29, 0, 50, sbb);
        int nrooms = 5;
        int[] rcoords = new int[nrooms * 2];
        for (int i = 0; i < nrooms; ++i) {
            int rz;
            int rx;
            while (this.isNearRoom(rx = maze.rand.method_43048(14) + 1, rz = maze.rand.method_43048(14) + 1, rcoords)) {
            }
            maze.carveRoom1(rx, rz);
            rcoords[i * 2] = rx;
            rcoords[i * 2 + 1] = rz;
        }
        maze.generateRecursiveBacktracker(0, 0);
        maze.add4Exits();
        maze.copyToStructure(world, manager, generator, 1, 0, 1, this, sbb);
        this.decorate3x3Rooms(world, rcoords, sbb);
    }

    private boolean isNearRoom(int dx, int dz, int[] rcoords) {
        if (dx == 1 && dz == 1) {
            return true;
        }
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int rx = rcoords[i * 2];
            int rz = rcoords[i * 2 + 1];
            if (rx == 0 && rz == 0 || Math.abs(dx - rx) >= 3 || Math.abs(dz - rz) >= 3) continue;
            return true;
        }
        return false;
    }

    private void decorate3x3Rooms(class_5281 world, int[] rcoords, class_3341 sbb) {
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int dx = rcoords[i * 2];
            int dz = rcoords[i * 2 + 1];
            dx = dx * 3 + 3;
            dz = dz * 3 + 3;
            this.decorate3x3Room(world, dx, dz, sbb);
        }
    }

    private void decorate3x3Room(class_5281 world, int x, int z, class_3341 sbb) {
        class_5819 roomRNG = class_5819.method_43049((long)(world.method_8412() ^ (long)(x + z)));
        this.roomJackO(world, roomRNG, x, z, 8, sbb);
        if (roomRNG.method_43048(4) == 0) {
            this.roomJackO(world, roomRNG, x, z, 8, sbb);
        }
        this.roomSpawner(world, roomRNG, x, z, 8, sbb);
        this.roomTreasure(world, roomRNG, x, z, 8, sbb);
        if (roomRNG.method_43048(4) == 0) {
            this.roomTreasure(world, roomRNG, x, z, 8, sbb);
        }
    }

    private void roomSpawner(class_5281 world, class_5819 rand, int x, int z, int diameter, class_3341 sbb) {
        int rx = x + rand.method_43048(diameter) - diameter / 2;
        int rz = z + rand.method_43048(diameter) - diameter / 2;
        class_1299 mobID = switch (rand.method_43048(3)) {
            case 1 -> (class_1299)TFEntities.SWARM_SPIDER.get();
            case 2 -> (class_1299)TFEntities.HOSTILE_WOLF.get();
            default -> (class_1299)TFEntities.HEDGE_SPIDER.get();
        };
        this.setSpawner(world, rx, 0, rz, sbb, mobID);
    }

    private void roomTreasure(class_5281 world, class_5819 rand, int x, int z, int diameter, class_3341 sbb) {
        int rx = x + rand.method_43048(diameter) - diameter / 2;
        int rz = z + rand.method_43048(diameter) - diameter / 2;
        this.placeTreasureAtCurrentPosition(world, rx, 0, rz, TFLootTables.HEDGE_MAZE, sbb);
    }

    private void roomJackO(class_5281 world, class_5819 rand, int x, int z, int diameter, class_3341 sbb) {
        int rx = x + rand.method_43048(diameter) - diameter / 2;
        int rz = z + rand.method_43048(diameter) - diameter / 2;
        this.method_14917(world, (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)class_2350.method_10139((int)rand.method_43048(4))), rx, 0, rz, sbb);
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        BoundingBoxUtils.boundingBoxToExistingNBT(this.field_15315, tagCompound);
    }
}

