/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.mushroomtower;

import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerBridgeComponent;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerMainBridgeComponent;
import twilightforest.world.components.structures.mushroomtower.TowerRoofMushroomComponent;

public class MushroomTowerWingComponent
extends TowerWingComponent {
    private static final int RANGE = 200;
    protected static final int FLOOR_HEIGHT = 4;
    protected static final int MAIN_SIZE = 15;
    boolean hasBase = false;
    public boolean isAscender = false;

    public MushroomTowerWingComponent(class_6625 ctx, class_2487 nbt) {
        this((class_3773)TFStructurePieceTypes.TFMTWin.get(), nbt);
    }

    public MushroomTowerWingComponent(class_3773 piece, class_2487 nbt) {
        super(piece, nbt);
        this.hasBase = nbt.method_10577("hasBase");
        this.isAscender = nbt.method_10577("isAscender");
    }

    protected MushroomTowerWingComponent(class_3773 piece, int i, int x, int y, int z, int pSize, int pHeight, class_2350 direction) {
        super(piece, i, x, y, z, pSize, pHeight, direction);
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        tagCompound.method_10556("hasBase", this.hasBase);
        tagCompound.method_10556("isAscender", this.isAscender);
    }

    @Override
    public void method_14918(class_3443 parent, class_6130 list, class_5819 rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        this.addOpening(0, 1, this.size / 2, class_2470.field_11464);
        boolean bl = this.hasBase = this.size > 3;
        if (this.isAscender) {
            int[] dest = this.getValidOpening(rand, class_2470.field_11464);
            dest[1] = this.height - 3;
            int childHeight = (rand.method_43048(3) + rand.method_43048(3) + 2) * 4 + 1;
            boolean madeIt = this.makeMainBridge(list, rand, this.method_14923() + 1, dest[0], dest[1], dest[2], childHeight, class_2470.field_11464);
            if (!madeIt) {
                TwilightForestMod.LOGGER.info("Did not make bridge back to new main");
            } else {
                TwilightForestMod.LOGGER.debug("Made bridge back to new main");
            }
        }
        if (this.method_14923() < 5 && this.size > 6) {
            for (class_2470 i : RotationUtil.ROTATIONS) {
                if (this.size < 15 && i == class_2470.field_11464) continue;
                int[] dest = this.getValidOpening(rand, i);
                int childHeight = (rand.method_43048(2) + rand.method_43048(2) + 2) * 4 + 1;
                this.makeBridge(list, rand, this.method_14923() + 1, dest[0], dest[1], dest[2], this.size - 4, childHeight, i);
            }
        }
        if (this.isHighest(this.field_15315, this.size, list) || !this.hasBase) {
            this.makeARoof(parent, list, rand);
        }
    }

    private boolean isOutOfRange(class_3443 parent, int nx, int nz, int range) {
        class_3341 sbb = parent.method_14935();
        int centerX = sbb.method_35415() + (sbb.method_35418() - sbb.method_35415() + 1) / 2;
        int centerZ = sbb.method_35417() + (sbb.method_35420() - sbb.method_35417() + 1) / 2;
        return Math.abs(nx - centerX) > range || Math.abs(nz - centerZ) > range;
    }

    @Override
    public boolean makeTowerWing(class_6130 list, class_5819 rand, int index, int x, int y, int z, int wingSize, int wingHeight, class_2470 rotation) {
        MushroomTowerWingComponent wing;
        class_3443 intersect;
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        if (this.isOutOfRange(this, dx[0], dx[2], 200)) {
            return false;
        }
        if (wingSize > 3) {
            dx = this.adjustCoordinates(dx[0], dx[1], dx[2], wingSize, direction, list);
        }
        if ((intersect = list.method_35461((wing = new MushroomTowerWingComponent((class_3773)TFStructurePieceTypes.TFMTWin.get(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction)).method_14935())) == null || intersect == this || intersect instanceof TowerRoofMushroomComponent) {
            if (this instanceof MushroomTowerBridgeComponent && this.isAscender) {
                wing.isAscender = true;
            }
            list.method_35462((class_3443)wing);
            wing.method_14918(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    protected int[] adjustCoordinates(int x, int y, int z, int wingSize, class_2350 direction, class_6130 list) {
        if (list instanceof class_6626) {
            class_6626 start = (class_6626)list;
            for (class_3443 obj : start.field_34944) {
                int[] nArray;
                if (!(obj instanceof TowerWingComponent)) continue;
                TowerWingComponent otherWing = (TowerWingComponent)obj;
                if (obj instanceof MushroomTowerBridgeComponent || wingSize != otherWing.size || !otherWing.method_14935().method_14669(x - 3, z - 3, x + 3, z + 3)) continue;
                switch (direction) {
                    case field_11035: {
                        int[] nArray2 = new int[3];
                        nArray2[0] = otherWing.method_14935().method_35415();
                        nArray2[1] = y;
                        nArray = nArray2;
                        nArray2[2] = otherWing.method_14935().method_35417();
                        break;
                    }
                    case field_11039: {
                        int[] nArray3 = new int[3];
                        nArray3[0] = otherWing.method_14935().method_35418();
                        nArray3[1] = y;
                        nArray = nArray3;
                        nArray3[2] = otherWing.method_14935().method_35417();
                        break;
                    }
                    case field_11043: {
                        int[] nArray4 = new int[3];
                        nArray4[0] = otherWing.method_14935().method_35418();
                        nArray4[1] = y;
                        nArray = nArray4;
                        nArray4[2] = otherWing.method_14935().method_35420();
                        break;
                    }
                    case field_11034: {
                        int[] nArray5 = new int[3];
                        nArray5[0] = otherWing.method_14935().method_35415();
                        nArray5[1] = y;
                        nArray = nArray5;
                        nArray5[2] = otherWing.method_14935().method_35420();
                        break;
                    }
                    default: {
                        int[] nArray6 = new int[3];
                        nArray6[0] = x;
                        nArray6[1] = y;
                        nArray = nArray6;
                        nArray6[2] = z;
                    }
                }
                return nArray;
            }
        }
        return new int[]{x, y, z};
    }

    private boolean isHighest(class_3341 boundingBox, int size, class_6130 list) {
        class_3341 boxAbove = new class_3341(boundingBox.method_35415(), boundingBox.method_35416(), boundingBox.method_35417(), boundingBox.method_35418(), 256, boundingBox.method_35420());
        if (list instanceof class_6626) {
            class_6626 start = (class_6626)list;
            for (class_3443 obj : start.field_34944) {
                if (this == obj || !(obj instanceof TowerWingComponent)) continue;
                TowerWingComponent otherWing = (TowerWingComponent)obj;
                if (obj instanceof MushroomTowerBridgeComponent || size != otherWing.size || !otherWing.method_14935().method_14657(boxAbove)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void makeARoof(class_3443 parent, class_6130 list, class_5819 rand) {
        TowerRoofMushroomComponent roof = new TowerRoofMushroomComponent(this.method_14923() + 1, this, 1.6f, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
        if (!(list.method_35461(roof.method_14935()) instanceof TowerRoofMushroomComponent) && !(list.method_35461((roof = new TowerRoofMushroomComponent(this.method_14923() + 1, this, 1.0f, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260())).method_14935()) instanceof TowerRoofMushroomComponent)) {
            roof = new TowerRoofMushroomComponent(this.method_14923() + 1, this, 0.6f, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
        }
        list.method_35462((class_3443)roof);
        roof.method_14918(this, list, rand);
    }

    @Override
    protected boolean makeBridge(class_6130 list, class_5819 rand, int index, int x, int y, int z, int wingSize, int wingHeight, class_2470 rotation) {
        return this.makeBridge(list, rand, index, x, y, z, wingSize, wingHeight, rotation, false);
    }

    protected boolean makeBridge(class_6130 list, class_5819 rand, int index, int x, int y, int z, int wingSize, int wingHeight, class_2470 rotation, boolean ascender) {
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 3, direction);
        if (wingSize == 3) {
            wingHeight = 4;
        }
        MushroomTowerBridgeComponent bridge = new MushroomTowerBridgeComponent((class_3773)TFStructurePieceTypes.TFMTBri.get(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        bridge.isAscender = ascender;
        class_3443 intersect = list.method_35461(bridge.method_14935());
        if (intersect != null && intersect != this) {
            return false;
        }
        intersect = list.method_35461(bridge.getWingBB());
        if (intersect == null || intersect == this) {
            list.method_35462((class_3443)bridge);
            bridge.method_14918(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    private boolean makeMainBridge(class_6130 list, class_5819 rand, int index, int x, int y, int z, int wingHeight, class_2470 rotation) {
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 3, direction);
        MushroomTowerMainBridgeComponent bridge = new MushroomTowerMainBridgeComponent(index, dx[0], dx[1], dx[2], wingHeight, direction);
        list.method_35462((class_3443)bridge);
        bridge.method_14918(this, list, rand);
        this.addOpening(x, y, z, rotation);
        return true;
    }

    @Override
    public int[] getValidOpening(class_5819 rand, class_2470 direction) {
        int wLength = Math.min(this.size / 3, 3);
        int offset = (this.size - wLength) / 2;
        if (direction == class_2470.field_11467 || direction == class_2470.field_11464) {
            int rx = direction == class_2470.field_11467 ? this.size - 1 : 0;
            int rz = offset + rand.method_43048(wLength);
            int ry = this.getYByStairs(rz, rand, direction);
            return new int[]{rx, ry, rz};
        }
        if (direction == class_2470.field_11463 || direction == class_2470.field_11465) {
            int rx = offset + rand.method_43048(wLength);
            int rz = direction == class_2470.field_11463 ? this.size - 1 : 0;
            int ry = this.getYByStairs(rx, rand, direction);
            return new int[]{rx, ry, rz};
        }
        return new int[]{0, 0, 0};
    }

    @Override
    protected int getYByStairs(int rx, class_5819 rand, class_2470 direction) {
        int floors = this.height / 4;
        return 5 + rand.method_43048(floors - 1) * 4;
    }

    @Override
    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, class_5819 rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        this.makeTrunk(world, sbb);
        this.makeFloorsForTower(world, sbb);
        this.makeOpenings(world, sbb);
    }

    private void makeTrunk(class_5281 world, class_3341 sbb) {
        int diameter = this.size / 2;
        int hollow = (int)((double)diameter * 0.8);
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int az;
                int ax = Math.abs(dx);
                int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.4);
                if (dist > diameter) continue;
                this.method_14917(world, this.deco.floorState, dx + diameter, 0, dz + diameter, sbb);
                this.method_14917(world, this.deco.floorState, dx + diameter, this.height, dz + diameter, sbb);
                if (dist > hollow) {
                    for (dy = 0; dy <= this.height; ++dy) {
                        this.method_14917(world, this.deco.blockState, dx + diameter, dy, dz + diameter, sbb);
                    }
                } else {
                    for (dy = 1; dy <= this.height - 1; ++dy) {
                        this.method_14917(world, AIR, dx + diameter, dy, dz + diameter, sbb);
                    }
                }
                if (!this.hasBase) continue;
                this.method_14936(world, this.deco.blockState, dx + diameter, -1, dz + diameter, sbb);
            }
        }
    }

    private void makeFloorsForTower(class_5281 world, class_3341 sbb) {
        int floors = this.height / 4;
        for (int i = 0; i < floors; ++i) {
            this.placeFloor(world, i * 4, sbb);
        }
    }

    private void placeFloor(class_5281 world, int dy, class_3341 sbb) {
        int diameter = this.size / 2;
        int hollow = (int)((double)diameter * 0.8);
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int az;
                int ax = Math.abs(dx);
                int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.4);
                if (dist > hollow) continue;
                this.method_14917(world, this.isAscender ? class_2246.field_10334.method_9564() : this.deco.floorState, dx + diameter, dy, dz + diameter, sbb);
            }
        }
    }

    @Override
    protected void makeDoorOpening(class_5281 world, int dx, int dy, int dz, class_3341 sbb) {
        super.makeDoorOpening(world, dx, dy, dz, sbb);
        if (this.method_14929((class_1922)world, dx, dy + 2, dz, sbb).method_26204() != class_2246.field_10124) {
            this.method_14917(world, this.deco.accentState, dx, dy + 2, dz, sbb);
        }
    }

    @Override
    protected void decorateFloor(class_5281 world, class_5819 rand, int floor, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, class_3341 sbb) {
    }
}

