/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.trollcave;

import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.HugeMushroomUtil;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.trollcave.TrollCaveGardenComponent;
import twilightforest.world.components.structures.trollcave.TrollCaveMainComponent;

public class TrollCaveConnectComponent
extends TrollCaveMainComponent {
    protected static final Stalactite STONE_STALACTITE_SMALL = new Stalactite(Map.of(class_2246.field_10340, 1), 1.0f, 5, 1);
    protected final boolean[] openingTowards = new boolean[]{false, false, true, false};

    public TrollCaveConnectComponent(class_6625 ctx, class_2487 nbt) {
        super((class_3773)TFStructurePieceTypes.TFTCCon.get(), nbt);
        this.openingTowards[0] = nbt.method_10577("openingTowards0");
        this.openingTowards[1] = nbt.method_10577("openingTowards1");
        this.openingTowards[2] = nbt.method_10577("openingTowards2");
        this.openingTowards[3] = nbt.method_10577("openingTowards3");
    }

    public TrollCaveConnectComponent(int index, int x, int y, int z, int caveSize, int caveHeight, class_2350 direction) {
        super((class_3773)TFStructurePieceTypes.TFTCCon.get(), index, x, y, z);
        this.size = caveSize;
        this.height = caveHeight;
        this.method_14926(direction);
        this.field_15315 = TFLandmark.getComponentToAddBoundingBox(x, y, z, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, direction, false);
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        tagCompound.method_10556("openingTowards0", this.openingTowards[0]);
        tagCompound.method_10556("openingTowards1", this.openingTowards[1]);
        tagCompound.method_10556("openingTowards2", this.openingTowards[2]);
        tagCompound.method_10556("openingTowards3", this.openingTowards[3]);
    }

    @Override
    public void method_14918(class_3443 parent, class_6130 list, class_5819 rand) {
        if (this.method_14923() < 3) {
            for (class_2470 rotation : RotationUtil.ROTATIONS) {
                class_2338 dest = this.getValidOpening(rand, rotation);
                if (!rand.method_43056() && this.makeGardenCave(list, rand, this.method_14923() + 1, dest.method_10263(), dest.method_10264(), dest.method_10260(), 30, 15, rotation)) continue;
                this.makeSmallerCave(list, rand, this.method_14923() + 1, dest.method_10263(), dest.method_10264(), dest.method_10260(), 20, 15, rotation);
            }
        }
    }

    @Override
    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, class_5819 rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        int i;
        this.hollowCaveMiddle(world, sbb, rand, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        class_5819 decoRNG = class_5819.method_43049((long)(world.method_8412() + (long)this.field_15315.method_35415() * 321534781L ^ (long)this.field_15315.method_35417() * 756839L));
        for (class_2470 rotation : RotationUtil.ROTATIONS) {
            if (this.openingTowards[rotation.ordinal()]) continue;
            this.decorateWall(world, sbb, decoRNG, rotation);
        }
        decoRNG.method_43052(world.method_8412() + (long)this.field_15315.method_35415() * 321534781L ^ (long)this.field_15315.method_35417() * 756839L);
        for (i = 0; i < 32; ++i) {
            class_2338.class_2339 dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, STONE_STALACTITE_SMALL, (class_2382)dest.method_33096(this.height), sbb, true);
        }
        for (i = 0; i < 32; ++i) {
            class_2338.class_2339 dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, STONE_STALACTITE_SMALL, (class_2382)dest.method_33096(0), sbb, false);
        }
        decoRNG.method_43052(world.method_8412() + (long)this.field_15315.method_35415() * 321534781L ^ (long)this.field_15315.method_35417() * 756839L);
        if (this.countExits() == 1 && decoRNG.method_43048(3) == 0) {
            this.makeTreasureCrate(world, sbb);
        } else if (decoRNG.method_43048(3) == 0) {
            this.makeMonolith(world, decoRNG, sbb);
        }
    }

    protected void makeMonolith(class_5281 world, class_5819 rand, class_3341 sbb) {
        int mid = this.size / 2;
        int height = 7 + rand.method_43048(8);
        class_2470 rotation = RotationUtil.ROTATIONS[rand.method_43048(4)];
        this.fillBlocksRotated(world, sbb, mid - 1, 0, mid - 1, mid - 1, height, mid - 1, class_2246.field_10540.method_9564(), rotation);
        this.fillBlocksRotated(world, sbb, mid, 0, mid - 1, mid, height - 2, mid - 1, class_2246.field_10540.method_9564(), rotation);
        this.fillBlocksRotated(world, sbb, mid - 1, 0, mid, mid - 1, height - 2, mid, class_2246.field_10540.method_9564(), rotation);
        this.fillBlocksRotated(world, sbb, mid, 0, mid, mid, height - 4, mid, class_2246.field_10540.method_9564(), rotation);
    }

    private int countExits() {
        int count = 0;
        for (boolean openingToward : this.openingTowards) {
            if (!openingToward) continue;
            ++count;
        }
        return count;
    }

    private void decorateWall(class_5281 world, class_3341 sbb, class_5819 decoRNG, class_2470 rotation) {
        if (decoRNG.method_43056()) {
            this.decorateBracketMushrooms(world, sbb, decoRNG, rotation);
        } else if (decoRNG.method_43056()) {
            this.decorateStoneFormation(world, sbb, decoRNG, rotation);
            this.decorateStoneFormation(world, sbb, decoRNG, rotation);
        }
    }

    private void decorateStoneFormation(class_5281 world, class_3341 sbb, class_5819 decoRNG, class_2470 rotation) {
        int startY;
        int z = 5 + decoRNG.method_43048(7);
        for (int y = startY = 1 + decoRNG.method_43048(2); y < this.height; y += 2) {
            int width = 1;
            int depth = 1 + (decoRNG.method_43048(3) == 0 ? 1 : 0);
            this.makeSingleStoneFormation(world, sbb, decoRNG, rotation, z, y, width, depth);
            if ((z += decoRNG.method_43048(4) - decoRNG.method_43048(4)) >= 5 && z <= this.size - 5) continue;
            z = 5 + decoRNG.method_43048(7);
        }
    }

    private void makeSingleStoneFormation(class_5281 world, class_3341 sbb, class_5819 decoRNG, class_2470 rotation, int z, int y, int width, int depth) {
        if (decoRNG.method_43048(8) == 0) {
            this.fillBlocksRotated(world, sbb, this.size - (depth + 1), y - width, z - width, this.size - 1, y + width, z + width, class_2246.field_10540.method_9564(), rotation);
        } else if (decoRNG.method_43048(4) == 0) {
            this.fillBlocksRotated(world, sbb, this.size - (depth + 1), y - width, z - width, this.size - 1, y + width, z + width, ((class_2248)TFBlocks.TROLLSTEINN.get()).method_9564(), rotation);
        } else {
            this.fillBlocksRotated(world, sbb, this.size - (depth + 1), y - width, z - width, this.size - 1, y + width, z + width, class_2246.field_10340.method_9564(), rotation);
        }
    }

    private void decorateStoneProjection(class_5281 world, class_3341 sbb, class_5819 decoRNG, class_2470 rotation) {
        int z = 7 + decoRNG.method_43048(3) - decoRNG.method_43048(3);
        int y = 7 + decoRNG.method_43048(3) - decoRNG.method_43048(3);
        this.randomlyFillBlocksRotated(world, sbb, decoRNG, 0.25f, this.size - 9, y, z, this.size - 2, y + 3, z + 3, ((class_2248)TFBlocks.TROLLSTEINN.get()).method_9564(), class_2246.field_10340.method_9564(), rotation);
        if (decoRNG.method_43056()) {
            this.randomlyFillBlocksRotated(world, sbb, decoRNG, 0.25f, this.size - 9, 1, z, this.size - 6, y - 1, z + 3, ((class_2248)TFBlocks.TROLLSTEINN.get()).method_9564(), class_2246.field_10340.method_9564(), rotation);
        } else {
            this.randomlyFillBlocksRotated(world, sbb, decoRNG, 0.25f, this.size - 9, y + 4, z, this.size - 6, this.height - 2, z + 3, ((class_2248)TFBlocks.TROLLSTEINN.get()).method_9564(), class_2246.field_10340.method_9564(), rotation);
        }
    }

    private void decorateBracketMushrooms(class_5281 world, class_3341 sbb, class_5819 decoRNG, class_2470 rotation) {
        int startY;
        int z = 5 + decoRNG.method_43048(7);
        for (int y = startY = 1 + decoRNG.method_43048(4); y < this.height; y += 2) {
            int width = 1 + decoRNG.method_43048(2) + decoRNG.method_43048(2);
            int depth = 1 + decoRNG.method_43048(2) + decoRNG.method_43048(2);
            class_2248 mushBlock = decoRNG.method_43048(3) == 0 ? (class_2248)TFBlocks.HUGE_MUSHGLOOM.get() : (decoRNG.method_43056() ? class_2246.field_10580 : class_2246.field_10240);
            this.makeSingleBracketMushroom(world, sbb, rotation, z, y, width, depth, mushBlock.method_9564());
            if ((z += decoRNG.method_43048(4) - decoRNG.method_43048(4)) >= 5 && z <= this.size - 5) continue;
            z = 5 + decoRNG.method_43048(7);
        }
    }

    private void makeSingleBracketMushroom(class_5281 world, class_3341 sbb, class_2470 rotation, int z, int y, int width, int depth, class_2680 mushBlock) {
        this.fillBlocksRotated(world, sbb, this.size - depth, y, z - (width - 1), this.size - 2, y, z + (width - 1), HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.CENTER, mushBlock), rotation);
        this.fillBlocksRotated(world, sbb, this.size - (depth + 1), y, z - (width - 1), this.size - (depth + 1), y, z + (width - 1), this.getMushroomState(mushBlock, HugeMushroomUtil.HugeMushroomType.EAST), rotation);
        class_2680 northMushroom = this.getMushroomState(mushBlock, HugeMushroomUtil.HugeMushroomType.SOUTH);
        for (int d = 0; d < depth - 1; ++d) {
            this.setBlockStateRotated(world, northMushroom, this.size - (2 + d), y, z - width, rotation, sbb);
        }
        class_2680 northWestMushroom = this.getMushroomState(mushBlock, HugeMushroomUtil.HugeMushroomType.SOUTH_EAST);
        this.setBlockStateRotated(world, northWestMushroom, this.size - (depth + 1), y, z - width, rotation, sbb);
        class_2680 southMushroom = this.getMushroomState(mushBlock, HugeMushroomUtil.HugeMushroomType.NORTH);
        for (int d = 0; d < depth - 1; ++d) {
            this.setBlockStateRotated(world, southMushroom, this.size - (2 + d), y, z + width, rotation, sbb);
        }
        class_2680 southWestMushroom = this.getMushroomState(mushBlock, HugeMushroomUtil.HugeMushroomType.NORTH_EAST);
        this.setBlockStateRotated(world, southWestMushroom, this.size - (depth + 1), y, z + width, rotation, sbb);
    }

    private class_2680 getMushroomState(class_2680 mushroomBlockState, HugeMushroomUtil.HugeMushroomType defaultRotation) {
        return HugeMushroomUtil.getState(defaultRotation, mushroomBlockState);
    }

    protected boolean makeGardenCave(class_6130 list, class_5819 rand, int index, int x, int y, int z, int caveSize, int caveHeight, class_2470 rotation) {
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        class_2338 dest = this.offsetTowerCCoords(x, y, z, caveSize, direction);
        TrollCaveGardenComponent cave = new TrollCaveGardenComponent(index, dest.method_10263(), dest.method_10264(), dest.method_10260(), caveSize, caveHeight, direction);
        class_3443 intersect = list.method_35461(cave.method_14935());
        class_3443 otherGarden = this.findNearbyGarden(list, cave.method_14935());
        if ((intersect == null || intersect == this) && otherGarden == null) {
            list.method_35462((class_3443)cave);
            ((TrollCaveMainComponent)cave).method_14918(this, list, rand);
            this.openingTowards[rotation.ordinal()] = true;
            return true;
        }
        return false;
    }

    @Nullable
    private class_3443 findNearbyGarden(class_6130 list, class_3341 boundingBox) {
        class_3341 largeBox = new class_3341(boundingBox.method_35415() - 30, boundingBox.method_35416() - 30, boundingBox.method_35417() - 30, boundingBox.method_35418() - 30, boundingBox.method_35419() - 30, boundingBox.method_35420() - 30);
        if (list instanceof class_6626) {
            class_6626 start = (class_6626)list;
            for (class_3443 component : start.field_34944) {
                if (!(component instanceof TrollCaveGardenComponent) || !component.method_14935().method_14657(largeBox)) continue;
                return component;
            }
        }
        return null;
    }

    @Override
    protected boolean makeSmallerCave(class_6130 list, class_5819 rand, int index, int x, int y, int z, int caveSize, int caveHeight, class_2470 rotation) {
        if (super.makeSmallerCave(list, rand, index, x, y, z, caveSize, caveHeight, rotation)) {
            this.openingTowards[rotation.ordinal()] = true;
            return true;
        }
        return false;
    }
}

