/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public interface StructureHints {
    public static final String BOOK_AUTHOR = "twilightforest.book.author";

    default public class_1799 createHintBook() {
        class_1799 book = new class_1799((class_1935)class_1802.field_8360);
        book.method_7948().method_10556("twilightforest:book", true);
        this.addBookInformation(book, new class_2499());
        return book;
    }

    default public void addBookInformation(class_1799 book, class_2499 bookPages) {
        StructureHints.addBookInformationStatic(book, bookPages, "unknown", 2);
    }

    public static void addBookInformationStatic(class_1799 book, class_2499 bookPages, @Nullable String name, int pageCount) {
        String key = name == null ? "unknown" : name;
        StructureHints.addTranslatedPages(bookPages, "twilightforest.book." + key, pageCount);
        book.method_7959("pages", (class_2520)bookPages);
        book.method_7959("generation", (class_2520)class_2497.method_23247((int)3));
        book.method_7959("author", (class_2520)class_2519.method_23256((String)BOOK_AUTHOR));
        book.method_7959("title", (class_2520)class_2519.method_23256((String)("twilightforest.book." + key)));
    }

    public static void addTranslatedPages(class_2499 bookPages, String translationKey, int pageCount) {
        for (int i = 1; i <= pageCount; ++i) {
            bookPages.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43471((String)(translationKey + "." + i)))));
        }
    }

    default public void trySpawnHintMonster(class_1937 world, class_1657 player) {
        this.trySpawnHintMonster(world, player, player.method_24515());
    }

    public void trySpawnHintMonster(class_1937 var1, class_1657 var2, class_2338 var3);

    public static void tryHintForStructure(class_1657 player, class_3218 level, class_5321<class_3195> forStructure) {
        Object object;
        Optional optStructureReg = level.method_30349().method_33310(class_7924.field_41246);
        if (optStructureReg.isEmpty() || !((object = ((class_2378)optStructureReg.get()).method_29107(forStructure)) instanceof StructureHints)) {
            return;
        }
        StructureHints structureHints = (StructureHints)object;
        structureHints.trySpawnHintMonster((class_1937)level, player);
    }

    default public boolean didSpawnHintMonster(class_1937 world, class_1657 player, class_2338 pos) {
        int dx = world.field_9229.method_43048(16) - world.field_9229.method_43048(16);
        int dy = world.field_9229.method_43048(4) - world.field_9229.method_43048(4);
        int dz = world.field_9229.method_43048(16) - world.field_9229.method_43048(16);
        class_1308 hinty = this.createHintMonster(world);
        hinty.method_5725(pos.method_10069(dx, dy, dz), 0.0f, 0.0f);
        if (hinty.method_5957((class_4538)world) && hinty.method_5985().method_6369((class_1297)player)) {
            class_1799 book = this.createHintBook();
            hinty.method_5673(class_1304.field_6173, book);
            hinty.method_5946(class_1304.field_6173, 1.0f);
            world.method_8649((class_1297)hinty);
            return true;
        }
        return false;
    }

    @Nullable
    public class_1308 createHintMonster(class_1937 var1);

    public record HintConfig(class_1799 hintItem, class_1299<? extends class_1308> hintMob) {
        public static final MapCodec<HintConfig> FLAT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1799.field_24671.fieldOf("hint_item").forGetter(HintConfig::hintItem), (App)class_7923.field_41177.method_39673().comapFlatMap(HintConfig::checkCastMob, entityType -> entityType).fieldOf("hint_mob").forGetter(HintConfig::hintMob)).apply((Applicative)instance, HintConfig::new));
        public static Codec<HintConfig> CODEC = FLAT_CODEC.codec();

        private static DataResult<class_1299<? extends class_1308>> checkCastMob(class_1299<?> entityType) {
            if (!entityType.method_31794().isAssignableFrom(class_1308.class)) {
                return DataResult.error(() -> "Configured Hint Entity " + entityType.method_35050() + " does not have a `Mob` superclass!");
            }
            return DataResult.success(entityType);
        }

        public static class_1799 defaultBook() {
            return HintConfig.book("unknown", 2);
        }

        public static class_1799 book(String name, int pageCount) {
            class_1799 book = new class_1799((class_1935)class_1802.field_8360);
            book.method_7948().method_10556("twilightforest:book", true);
            StructureHints.addBookInformationStatic(book, new class_2499(), name, pageCount);
            return book;
        }
    }
}

