/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration.biomes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.floats.Float2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectSortedMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFLandmark;
import twilightforest.world.components.chunkgenerators.warp.TerrainColumn;
import twilightforest.world.registration.biomes.BiomeHelper;

public final class BiomeMaker
extends BiomeHelper {
    public static final Map<class_5321<class_1959>, ImmutableSet<TFLandmark>> BIOME_FEATURES_SETS = new ImmutableMap.Builder().put(TFBiomes.ENCHANTED_FOREST, (Object)ImmutableSet.of((Object)TFLandmark.QUEST_GROVE)).put(TFBiomes.SWAMP, (Object)ImmutableSet.of((Object)TFLandmark.LABYRINTH)).put(TFBiomes.FIRE_SWAMP, (Object)ImmutableSet.of((Object)TFLandmark.HYDRA_LAIR)).put(TFBiomes.DARK_FOREST, (Object)ImmutableSet.of((Object)TFLandmark.KNIGHT_STRONGHOLD)).put(TFBiomes.DARK_FOREST_CENTER, (Object)ImmutableSet.of((Object)TFLandmark.DARK_TOWER)).put(TFBiomes.SNOWY_FOREST, (Object)ImmutableSet.of((Object)TFLandmark.YETI_CAVE)).put(TFBiomes.GLACIER, (Object)ImmutableSet.of((Object)TFLandmark.ICE_TOWER)).put(TFBiomes.HIGHLANDS, (Object)ImmutableSet.of((Object)TFLandmark.TROLL_CAVE)).put(TFBiomes.FINAL_PLATEAU, (Object)ImmutableSet.of((Object)TFLandmark.FINAL_CASTLE)).build();

    public static List<TerrainColumn> makeBiomeList(class_7871<class_1959> biomeRegistry, class_6880<class_1959> undergroundBiome) {
        return List.of(BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, TFBiomes.FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.1f, 0.2f, biomeRegistry, TFBiomes.DENSE_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.0625f, 0.05f, biomeRegistry, TFBiomes.FIREFLY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.005f, 0.005f, biomeRegistry, TFBiomes.CLEARING, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.1f, biomeRegistry, TFBiomes.OAK_SAVANNAH, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-1.65f, 0.25f, biomeRegistry, TFBiomes.STREAM, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-1.97f, 0.0f, biomeRegistry, TFBiomes.LAKE, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, TFBiomes.MUSHROOM_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.05f, biomeRegistry, TFBiomes.DENSE_MUSHROOM_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, TFBiomes.ENCHANTED_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, TFBiomes.SPOOKY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-0.9f, 0.15f, biomeRegistry, TFBiomes.SWAMP, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-0.2f, 0.05f, biomeRegistry, TFBiomes.FIRE_SWAMP, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.005f, biomeRegistry, TFBiomes.DARK_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.005f, biomeRegistry, TFBiomes.DARK_FOREST_CENTER, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.15f, biomeRegistry, TFBiomes.SNOWY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, TFBiomes.GLACIER, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(3.0f, 0.25f, biomeRegistry, TFBiomes.HIGHLANDS, undergroundBiome), BiomeMaker.biomeColumnToBedrock(7.0f, 0.1f, biomeRegistry, TFBiomes.THORNLANDS), BiomeMaker.biomeColumnToBedrock(13.75f, 0.025f, biomeRegistry, TFBiomes.FINAL_PLATEAU));
    }

    private static TerrainColumn biomeColumnWithUnderground(float noiseDepth, float noiseScale, class_7871<class_1959> biomeRegistry, class_5321<class_1959> key, class_6880<class_1959> undergroundBiome) {
        class_6880.class_6883 biomeHolder = biomeRegistry.method_46747(key);
        biomeHolder.method_45917(key);
        return BiomeMaker.makeColumn(noiseDepth, noiseScale, (class_6880<class_1959>)biomeHolder, treeMap -> {
            treeMap.put(Math.min(noiseDepth - 1.0f, -1.0f), (Object)biomeHolder);
            treeMap.put(Math.min(noiseDepth - 3.0f, -3.0f), (Object)undergroundBiome);
        });
    }

    private static TerrainColumn biomeColumnToBedrock(float noiseDepth, float noiseScale, class_7871<class_1959> biomeRegistry, class_5321<class_1959> key) {
        class_6880.class_6883 biomeHolder = biomeRegistry.method_46747(key);
        biomeHolder.method_45917(key);
        return BiomeMaker.makeColumn(noiseDepth, noiseScale, (class_6880<class_1959>)biomeHolder, treeMap -> treeMap.put(0.0f, (Object)biomeHolder));
    }

    private static TerrainColumn makeColumn(float noiseDepth, float noiseScale, class_6880<class_1959> biomeHolder, Consumer<Float2ObjectSortedMap<class_6880<class_1959>>> layerBuilder) {
        return new TerrainColumn(biomeHolder, (Float2ObjectSortedMap<class_6880<class_1959>>)((Float2ObjectSortedMap)class_156.method_654((Object)new Float2ObjectAVLTreeMap(), layerBuilder)), noiseDepth, noiseScale);
    }
}

