/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.mixin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.event.v1.FabricLivingEvents;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedDouble;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingAttackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingEquipmentChangeCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingFallCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingKnockBackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.MobEffectEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.ShieldBlockCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.event.CapturedDropsEntity;
import fuzs.puzzleslib.impl.event.EventImplHelper;
import fuzs.puzzleslib.impl.event.FabricEventImplHelper;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1309.class})
abstract class LivingEntityFabricMixin
extends class_1297 {
    @Unique
    private final ThreadLocal<class_1799> puzzleslib$originalUseItem = new ThreadLocal();
    @Shadow
    protected class_1799 field_6277;
    @Shadow
    protected int field_6222;
    @Shadow
    @Nullable
    protected class_1657 field_6258;
    @Shadow
    protected int field_6238;
    @Shadow
    @Final
    private Map<class_1291, class_1293> field_6280;
    @Unique
    private MutableInt puzzleslib$lootingLevel;
    @Unique
    private DefaultedFloat puzzleslib$damageAmount;
    @Unique
    private float puzzleslib$hurtAmount;
    @Unique
    private DefaultedFloat puzzleslib$fallDistance;
    @Unique
    private DefaultedFloat puzzleslib$damageMultiplier;
    @Unique
    private DefaultedDouble puzzleslib$strength;
    @Unique
    private DefaultedDouble puzzleslib$ratioX;
    @Unique
    private DefaultedDouble puzzleslib$ratioZ;

    public LivingEntityFabricMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void tick(CallbackInfo callback) {
        if (((LivingEvents.Tick)FabricLivingEvents.LIVING_TICK.invoker()).onLivingTick((class_1309)class_1309.class.cast((Object)this)).isInterrupt()) {
            callback.cancel();
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    public void die(class_1282 damageSource, CallbackInfo callback) {
        EventResult result = ((LivingDeathCallback)FabricLivingEvents.LIVING_DEATH.invoker()).onLivingDeath((class_1309)class_1309.class.cast((Object)this), damageSource);
        if (result.isInterrupt()) {
            callback.cancel();
        }
    }

    @Inject(method={"startUsingItem"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;useItemRemaining:I", shift=At.Shift.AFTER)}, cancellable=true)
    public void startUsingItem(class_1268 hand, CallbackInfo callback) {
        DefaultedInt useItemRemaining = DefaultedInt.fromValue(this.field_6222);
        EventResult result = ((UseItemEvents.Start)FabricLivingEvents.USE_ITEM_START.invoker()).onUseItemStart((class_1309)class_1309.class.cast((Object)this), this.field_6277, useItemRemaining);
        if (result.isInterrupt()) {
            this.field_6277 = class_1799.field_8037;
            this.field_6222 = 0;
            callback.cancel();
        } else {
            this.field_6222 = useItemRemaining.getAsOptionalInt().orElse(this.field_6222);
        }
    }

    @Inject(method={"updateUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    protected void updateUsingItem(class_1799 usingItem, CallbackInfo callback) {
        if (!usingItem.method_7960()) {
            DefaultedInt remainingUseDuration = DefaultedInt.fromValue(this.method_6014());
            EventResult result = ((UseItemEvents.Tick)FabricLivingEvents.USE_ITEM_TICK.invoker()).onUseItemTick((class_1309)class_1309.class.cast((Object)this), usingItem, remainingUseDuration);
            remainingUseDuration.getAsOptionalInt().ifPresent(t -> {
                this.field_6222 = t == 0 ? 1 : t;
            });
            if (result.isInterrupt()) {
                if (this.method_22382()) {
                    this.method_6098(usingItem, 5);
                }
                if (--this.field_6222 == 0 && !this.method_37908().field_9236 && !usingItem.method_7967()) {
                    this.method_6040();
                }
                callback.cancel();
            }
        }
    }

    @Shadow
    public abstract int method_6014();

    @Shadow
    private boolean method_22382() {
        throw new RuntimeException();
    }

    @Shadow
    protected abstract void method_6098(class_1799 var1, int var2);

    @Shadow
    protected abstract void method_6040();

    @Shadow
    private void method_6076() {
        throw new RuntimeException();
    }

    @Inject(method={"completeUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;", shift=At.Shift.BEFORE)})
    protected void completeUsingItem(CallbackInfo callback) {
        this.puzzleslib$originalUseItem.set(this.field_6277.method_7972());
    }

    @ModifyVariable(method={"completeUsingItem"}, at=@At(value="STORE"), ordinal=0)
    protected class_1799 completeUsingItem(class_1799 useItem) {
        Objects.requireNonNull(this.puzzleslib$originalUseItem.get(), "use item copy is null");
        DefaultedValue<class_1799> stack = DefaultedValue.fromValue(useItem);
        ((UseItemEvents.Finish)FabricLivingEvents.USE_ITEM_FINISH.invoker()).onUseItemFinish((class_1309)class_1309.class.cast((Object)this), stack, this.field_6222, this.puzzleslib$originalUseItem.get());
        useItem = stack.getAsOptional().orElse(useItem);
        this.puzzleslib$originalUseItem.remove();
        return useItem;
    }

    @Shadow
    public abstract void method_6021();

    @Inject(method={"releaseUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void releaseUsingItem(CallbackInfo callback) {
        if (!this.field_6277.method_7960()) {
            if (((UseItemEvents.Stop)FabricLivingEvents.USE_ITEM_STOP.invoker()).onUseItemStop((class_1309)class_1309.class.cast((Object)this), this.field_6277, this.field_6222).isPass()) {
                return;
            }
            if (this.field_6277.method_7967()) {
                this.method_6076();
            }
            this.method_6021();
            callback.cancel();
        }
    }

    @ModifyVariable(method={"dropAllDeathLoot"}, at=@At(value="STORE"), ordinal=0)
    protected int dropAllDeathLoot$0(int lootingLevel, class_1282 damageSource) {
        this.puzzleslib$lootingLevel = FabricEventImplHelper.onLootingLevel((class_1309)class_1309.class.cast((Object)this), damageSource, lootingLevel);
        return this.puzzleslib$lootingLevel.getAsInt();
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;lastHurtByPlayerTime:I", shift=At.Shift.BEFORE)})
    protected void dropAllDeathLoot$1(class_1282 damageSource, CallbackInfo callback) {
        ((CapturedDropsEntity)((Object)this)).puzzleslib$acceptCapturedDrops(Lists.newArrayList());
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="TAIL")})
    protected void dropAllDeathLoot$2(class_1282 damageSource, CallbackInfo callback) {
        if (!FabricEventImplHelper.tryOnLivingDrops((class_1309)class_1309.class.cast((Object)this), damageSource, this.field_6238, () -> this.puzzleslib$lootingLevel)) {
            PuzzlesLib.LOGGER.warn("Unable to invoke LivingDropsCallback for entity {}: Drops is null", (Object)this.method_5477().getString());
        }
        this.puzzleslib$lootingLevel = null;
    }

    @Inject(method={"die"}, at={@At(value="TAIL")})
    public void die$1(class_1282 damageSource, CallbackInfo callback) {
        FabricEventImplHelper.tryOnLivingDrops((class_1309)class_1309.class.cast((Object)this), damageSource, this.field_6238, () -> {
            int n;
            class_1297 patt9853$temp = damageSource.method_5529();
            if (patt9853$temp instanceof class_1657) {
                class_1657 player = (class_1657)patt9853$temp;
                n = class_1890.method_8226((class_1309)player);
            } else {
                n = 0;
            }
            int lootingLevel = n;
            return FabricEventImplHelper.onLootingLevel((class_1309)class_1309.class.cast((Object)this), damageSource, lootingLevel);
        });
    }

    @Inject(method={"dropExperience"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V")}, cancellable=true)
    protected void dropExperience(CallbackInfo callback) {
        DefaultedInt experienceReward = DefaultedInt.fromValue(this.method_6110());
        EventResult result = ((LivingExperienceDropCallback)FabricLivingEvents.EXPERIENCE_DROP.invoker()).onLivingExperienceDrop((class_1309)class_1309.class.cast((Object)this), this.field_6258, experienceReward);
        if (result.isInterrupt()) {
            callback.cancel();
        } else {
            experienceReward.getAsOptionalInt().ifPresent(value -> {
                class_1303.method_31493((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (int)value);
                callback.cancel();
            });
        }
    }

    @Shadow
    protected abstract int method_6110();

    @Inject(method={"actuallyHurt"}, at={@At(value="HEAD")}, cancellable=true)
    protected void actuallyHurt(class_1282 damageSource, float damageAmount, CallbackInfo callback) {
        if (!this.method_5679(damageSource)) {
            this.puzzleslib$damageAmount = DefaultedFloat.fromValue(damageAmount);
            if (((LivingHurtCallback)FabricLivingEvents.LIVING_HURT.invoker()).onLivingHurt((class_1309)class_1309.class.cast((Object)this), damageSource, this.puzzleslib$damageAmount).isInterrupt()) {
                callback.cancel();
            }
        }
    }

    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    protected float actuallyHurt(float damageAmount, class_1282 damageSource) {
        if (!this.method_5679(damageSource)) {
            Objects.requireNonNull(this.puzzleslib$damageAmount, "damage amount is null");
            damageAmount = this.puzzleslib$damageAmount.getAsOptionalFloat().orElse(Float.valueOf(damageAmount)).floatValue();
            this.puzzleslib$damageAmount = null;
        }
        return damageAmount;
    }

    @Shadow
    public abstract boolean method_6061(class_1282 var1);

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callback) {
        if (class_1657.class.isInstance((Object)this)) {
            return;
        }
        EventResult result = ((LivingAttackCallback)FabricLivingEvents.LIVING_ATTACK.invoker()).onLivingAttack((class_1309)class_1309.class.cast((Object)this), source, amount);
        if (result.isInterrupt()) {
            callback.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="LOAD", ordinal=1), ordinal=0)
    public float hurt$0(float amount, class_1282 source) {
        if (amount > 0.0f && this.method_6061(source)) {
            this.puzzleslib$hurtAmount = amount;
            DefaultedFloat blockedDamage = DefaultedFloat.fromValue(amount);
            EventResult result = ((ShieldBlockCallback)FabricLivingEvents.SHIELD_BLOCK.invoker()).onShieldBlock((class_1309)class_1309.class.cast((Object)this), source, blockedDamage);
            if (result.isInterrupt()) {
                return 0.0f;
            }
            this.puzzleslib$hurtAmount -= blockedDamage.getAsFloat();
            return blockedDamage.getAsFloat();
        }
        return amount;
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;walkAnimation:Lnet/minecraft/world/entity/WalkAnimationState;", shift=At.Shift.BEFORE), ordinal=0)
    public float hurt$1(float amount, class_1282 source) {
        if (this.puzzleslib$hurtAmount != 0.0f) {
            amount = this.puzzleslib$hurtAmount;
            this.puzzleslib$hurtAmount = 0.0f;
        }
        return amount;
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void causeFallDamage$0(float distance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> callback) {
        this.puzzleslib$fallDistance = DefaultedFloat.fromValue(distance);
        this.puzzleslib$damageMultiplier = DefaultedFloat.fromValue(damageMultiplier);
        if (((LivingFallCallback)FabricLivingEvents.LIVING_FALL.invoker()).onLivingFall((class_1309)class_1309.class.cast((Object)this), this.puzzleslib$fallDistance, this.puzzleslib$damageMultiplier).isInterrupt()) {
            callback.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"causeFallDamage"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    public float causeFallDamage$1(float fallDistance) {
        Objects.requireNonNull(this.puzzleslib$fallDistance, "fall distance is null");
        fallDistance = this.puzzleslib$fallDistance.getAsOptionalFloat().orElse(Float.valueOf(fallDistance)).floatValue();
        this.puzzleslib$fallDistance = null;
        return fallDistance;
    }

    @ModifyVariable(method={"causeFallDamage"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    public float causeFallDamage$2(float damageMultiplier) {
        Objects.requireNonNull(this.puzzleslib$damageMultiplier, "damage multiplier is null");
        damageMultiplier = this.puzzleslib$damageMultiplier.getAsOptionalFloat().orElse(Float.valueOf(damageMultiplier)).floatValue();
        this.puzzleslib$damageMultiplier = null;
        return damageMultiplier;
    }

    @Inject(method={"knockback"}, at={@At(value="HEAD")}, cancellable=true)
    public void knockback$0(double strength, double ratioX, double ratioZ, CallbackInfo callback) {
        this.puzzleslib$strength = DefaultedDouble.fromValue(strength);
        this.puzzleslib$ratioX = DefaultedDouble.fromValue(ratioX);
        this.puzzleslib$ratioZ = DefaultedDouble.fromValue(ratioZ);
        if (((LivingKnockBackCallback)FabricLivingEvents.LIVING_KNOCK_BACK.invoker()).onLivingKnockBack((class_1309)class_1309.class.cast((Object)this), this.puzzleslib$strength, this.puzzleslib$ratioX, this.puzzleslib$ratioZ).isInterrupt()) {
            callback.cancel();
        }
    }

    @ModifyVariable(method={"knockback"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    public double knockback$1(double strength) {
        Objects.requireNonNull(this.puzzleslib$strength, "strength is null");
        strength = this.puzzleslib$strength.getAsOptionalDouble().orElse(strength);
        this.puzzleslib$strength = null;
        return strength;
    }

    @ModifyVariable(method={"knockback"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    public double knockback$2(double ratioX) {
        Objects.requireNonNull(this.puzzleslib$ratioX, "ratio x is null");
        ratioX = this.puzzleslib$ratioX.getAsOptionalDouble().orElse(ratioX);
        this.puzzleslib$ratioX = null;
        return ratioX;
    }

    @ModifyVariable(method={"knockback"}, at=@At(value="HEAD"), ordinal=2, argsOnly=true)
    public double knockback$3(double ratioZ) {
        Objects.requireNonNull(this.puzzleslib$ratioZ, "ratio z is null");
        ratioZ = this.puzzleslib$ratioZ.getAsOptionalDouble().orElse(ratioZ);
        this.puzzleslib$ratioZ = null;
        return ratioZ;
    }

    @ModifyVariable(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at=@At(value="STORE"), ordinal=1)
    public class_1293 addEffect(@Nullable class_1293 oldEffectInstance, class_1293 effectInstance, @Nullable class_1297 entity) {
        ((MobEffectEvents.Apply)FabricLivingEvents.MOB_EFFECT_APPLY.invoker()).onMobEffectApply((class_1309)class_1309.class.cast((Object)this), effectInstance, oldEffectInstance, entity);
        return oldEffectInstance;
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    public void canBeAffected(class_1293 effectInstance, CallbackInfoReturnable<Boolean> callback) {
        EventResult result = ((MobEffectEvents.Affects)FabricLivingEvents.MOB_EFFECT_AFFECTS.invoker()).onMobEffectAffects((class_1309)class_1309.class.cast((Object)this), effectInstance);
        if (result.isInterrupt()) {
            callback.setReturnValue((Object)result.getAsBoolean());
        }
    }

    @Inject(method={"removeEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void removeEffect(class_1291 effect, CallbackInfoReturnable<Boolean> callback) {
        EventResult result = ((MobEffectEvents.Remove)FabricLivingEvents.MOB_EFFECT_REMOVE.invoker()).onMobEffectRemove((class_1309)class_1309.class.cast((Object)this), this.method_6112(effect));
        if (result.isInterrupt()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Shadow
    @Nullable
    public abstract class_1293 method_6112(class_1291 var1);

    @Inject(method={"removeEffect"}, at={@At(value="HEAD")})
    public void removeAllEffects(CallbackInfoReturnable<Boolean> callback) {
        if (this.method_37908().field_9236) {
            return;
        }
        Set activeEffectsToKeep = Sets.newIdentityHashSet();
        for (class_1293 mobEffectInstance : this.field_6280.values()) {
            EventResult result = ((MobEffectEvents.Remove)FabricLivingEvents.MOB_EFFECT_REMOVE.invoker()).onMobEffectRemove((class_1309)class_1309.class.cast((Object)this), mobEffectInstance);
            if (!result.isInterrupt()) continue;
            activeEffectsToKeep.add(mobEffectInstance);
        }
        if (!activeEffectsToKeep.isEmpty()) {
            Iterator<class_1293> iterator = this.field_6280.values().iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                class_1293 effect = iterator.next();
                this.method_6129(effect);
                iterator.remove();
                flag = true;
            }
            callback.setReturnValue((Object)flag);
        }
    }

    @Shadow
    protected abstract void method_6129(class_1293 var1);

    @ModifyVariable(method={"tickEffects"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;remove()V"), ordinal=0)
    protected class_1293 tickEffects(class_1293 mobEffectInstance) {
        ((MobEffectEvents.Expire)FabricLivingEvents.MOB_EFFECT_EXPIRE.invoker()).onMobEffectExpire((class_1309)class_1309.class.cast((Object)this), mobEffectInstance);
        return mobEffectInstance;
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="TAIL")})
    protected void jumpFromGround(CallbackInfo callback) {
        EventImplHelper.onLivingJump((LivingEvents.Jump)FabricLivingEvents.LIVING_JUMP.invoker(), (class_1309)class_1309.class.cast((Object)this));
    }

    @ModifyVariable(method={"getVisibilityPercent"}, at=@At(value="TAIL", shift=At.Shift.BEFORE), ordinal=0)
    public double getVisibilityPercent(double value, @Nullable class_1297 lookingEntity) {
        DefaultedDouble visibilityPercentage = DefaultedDouble.fromValue(value);
        ((LivingEvents.Visibility)FabricLivingEvents.LIVING_VISIBILITY.invoker()).onLivingVisibility((class_1309)class_1309.class.cast((Object)this), lookingEntity, visibilityPercentage);
        return visibilityPercentage.getAsOptionalDouble().stream().map(t -> Math.max(t, 0.0)).findAny().orElse(value);
    }

    @Inject(method={"collectEquipmentChanges"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void collectEquipmentChanges(CallbackInfoReturnable<Map<class_1304, class_1799>> callback, Map<class_1304, class_1799> map, class_1304[] values, int $0, int $1, class_1304 equipmentSlot, class_1799 oldItemStack, class_1799 newItemStack) {
        ((LivingEquipmentChangeCallback)FabricLivingEvents.LIVING_EQUIPMENT_CHANGE.invoker()).onLivingEquipmentChange((class_1309)class_1309.class.cast((Object)this), equipmentSlot, oldItemStack, newItemStack);
    }
}

