/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.blocks;

import com.google.common.collect.Maps;
import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.blockentities.WunderKisteBlockEntity;
import de.ambertation.wunderreich.blockentities.renderer.WunderkisteRenderer;
import de.ambertation.wunderreich.interfaces.ActiveChestStorage;
import de.ambertation.wunderreich.interfaces.BlockEntityProvider;
import de.ambertation.wunderreich.interfaces.BlockTagSupplier;
import de.ambertation.wunderreich.interfaces.CanDropLoot;
import de.ambertation.wunderreich.interfaces.WunderKisteExtensionProvider;
import de.ambertation.wunderreich.inventory.WunderKisteContainer;
import de.ambertation.wunderreich.items.WunderKisteItem;
import de.ambertation.wunderreich.loot.LootTableJsonBuilder;
import de.ambertation.wunderreich.network.AddRemoveWunderKisteMessage;
import de.ambertation.wunderreich.registries.WunderreichAdvancements;
import de.ambertation.wunderreich.registries.WunderreichBlockEntities;
import de.ambertation.wunderreich.registries.WunderreichBlocks;
import de.ambertation.wunderreich.registries.WunderreichParticles;
import de.ambertation.wunderreich.registries.WunderreichRules;
import de.ambertation.wunderreich.utils.LiveBlockManager;
import de.ambertation.wunderreich.utils.WunderKisteDomain;
import de.ambertation.wunderreich.utils.WunderKisteServerExtension;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4732;
import net.minecraft.class_4739;
import net.minecraft.class_4838;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_747;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WunderKisteBlock
extends class_4739<WunderKisteBlockEntity>
implements class_3954,
BlockTagSupplier,
BlockEntityProvider<WunderKisteBlockEntity>,
CanDropLoot {
    public static final class_2754<WunderKisteDomain> DOMAIN;
    public static final WunderKisteDomain DEFAULT_DOMAIN;
    public static final class_2753 FACING;
    public static final class_2746 WATERLOGGED;
    protected static final class_265 SHAPE;
    private static final class_2561 CONTAINER_TITLE;
    private static final Map<WunderKisteDomain.ID, Boolean> hasAnyOpenInstance;

    public WunderKisteBlock() {
        super((class_4970.class_2251)WunderreichBlocks.makeStoneBlockSettings().luminance(7).requiresTool().strength(12.5f, 800.0f), () -> WunderreichBlockEntities.BLOCK_ENTITY_WUNDER_KISTE);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(DOMAIN, (Comparable)((Object)DEFAULT_DOMAIN)));
    }

    public static void updateAllBoxes(class_2680 state, @Nullable class_2586 entity, MinecraftServer server, boolean withOpenState, boolean withFillrate) {
        WunderKisteContainer container = WunderKisteBlock.getContainer(state, entity, server);
        WunderKisteBlock.updateAllBoxes(container, withOpenState, withFillrate);
    }

    public static void updateAllBoxes(class_1263 container, boolean withOpenState, boolean withFillrate) {
        WunderKisteContainer c = null;
        if (container instanceof WunderKisteContainer) {
            WunderKisteContainer wc;
            c = wc = (WunderKisteContainer)container;
        }
        WunderKisteBlock.updateAllBoxes(c, withOpenState, withFillrate);
    }

    private static void updateAllBoxes(WunderKisteContainer container, boolean withOpenState, boolean withFillrate) {
        if (!WunderreichRules.Wunderkiste.isRedstoneEnabled()) {
            return;
        }
        if (container != null) {
            if (withOpenState) {
                WunderKisteDomain.ID.forAll(d -> hasAnyOpenInstance.put((WunderKisteDomain.ID)d, false));
                WunderKisteBlock.getLiveBlockManager().forEach(liveBlock -> {
                    class_2586 be = liveBlock.getLevel().method_8321(liveBlock.pos);
                    if (be instanceof WunderKisteBlockEntity) {
                        WunderKisteBlockEntity entity = (WunderKisteBlockEntity)be;
                        WunderKisteDomain.ID d = WunderKisteServerExtension.getDomain(entity.method_11010(), entity);
                        hasAnyOpenInstance.put(d, entity.isOpen() || hasAnyOpenInstance.get(d) != false);
                    }
                });
            }
            WunderKisteBlock.getLiveBlockManager().emitChange();
        }
    }

    public static void updateNeighbours(LiveBlockManager.LiveBlock live) {
        class_2248 block;
        class_2680 state = live.getLevel().method_8320(live.pos);
        if (state != null && (block = state.method_26204()) instanceof WunderKisteBlock) {
            WunderKisteBlock.updateNeighbours(live.getLevel(), live.pos, state, block);
        }
    }

    public static void updateNeighbours(class_1937 level, class_2338 pos, class_2680 state, class_2248 box) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        level.method_8455(pos, box);
        level.method_8452(pos, box);
        level.method_8452(pos.method_10093(facing), box);
    }

    public static WunderKisteContainer getContainer(class_2680 state, class_2586 entity, class_1937 level) {
        return level != null ? WunderKisteBlock.getContainer(state, entity, level.method_8503()) : null;
    }

    public static WunderKisteContainer getContainer(class_2680 state, @Nullable class_2586 entity, MinecraftServer server) {
        if (server instanceof WunderKisteExtensionProvider) {
            WunderKisteExtensionProvider extWunderkiste = (WunderKisteExtensionProvider)server;
            return extWunderkiste.getWunderKisteExtension().getContainer(state, entity);
        }
        return null;
    }

    public static LiveBlockManager<LiveBlockManager.LiveBlock> getLiveBlockManager() {
        return WunderKisteServerExtension.WUNDERKISTEN;
    }

    public class_4732.class_4734<? extends class_2595> method_24167(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, boolean bl) {
        return class_4732.class_3923::method_24174;
    }

    public class_265 method_9530(@NotNull class_2680 blockState, @NotNull class_1922 blockGetter, @NotNull class_2338 blockPos, @NotNull class_3726 collisionContext) {
        return SHAPE;
    }

    public class_2464 method_9604(@NotNull class_2680 blockState) {
        return class_2464.field_11456;
    }

    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_3610 fluidState = blockPlaceContext.method_8045().method_8316(blockPlaceContext.method_8037());
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)blockPlaceContext.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9598(class_2680 blockState, class_2470 rotation) {
        return (class_2680)blockState.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)blockState.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 blockState, class_2415 mirror) {
        return blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, DOMAIN});
    }

    public class_3610 method_9545(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(blockState);
    }

    public class_2680 method_9559(class_2680 blockState, @NotNull class_2350 direction, @NotNull class_2680 blockState2, @NotNull class_1936 levelAccessor, @NotNull class_2338 blockPos, @NotNull class_2338 blockPos2) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            levelAccessor.method_39281(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)levelAccessor));
        }
        return super.method_9559(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public boolean method_9516(@NotNull class_2680 blockState, @NotNull class_1922 blockGetter, @NotNull class_2338 blockPos, @NotNull class_10 pathComputationType) {
        return false;
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 random) {
        class_2586 blockEntity = serverLevel.method_8321(blockPos);
        if (blockEntity instanceof WunderKisteBlockEntity) {
            ((WunderKisteBlockEntity)blockEntity).recheckOpen();
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, @NotNull class_2680 blockState, @NotNull class_2591<T> blockEntityType) {
        return level.field_9236 ? WunderKisteBlock.method_31618(blockEntityType, WunderreichBlockEntities.BLOCK_ENTITY_WUNDER_KISTE, WunderKisteBlockEntity::lidAnimateTick) : null;
    }

    private void dispatchParticles(class_1937 level, class_2338 blockPos, WunderKisteDomain domain) {
        level.method_20290(2002, blockPos, domain.color);
    }

    public class_1269 method_9534(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_1657 player, @NotNull class_1268 interactionHand, @NotNull class_3965 blockHitResult) {
        class_2586 entity = level.method_8321(blockPos);
        WunderKisteContainer wunderKisteContainer = WunderKisteBlock.getContainer(blockState, entity, level);
        if (wunderKisteContainer != null && entity instanceof WunderKisteBlockEntity) {
            class_1799 tool = player.method_5998(interactionHand);
            WunderKisteDomain targetDomain = null;
            if (WunderreichRules.Wunderkiste.canColor()) {
                for (WunderKisteDomain dom : WunderKisteDomain.values()) {
                    if (!tool.method_31574(dom.triggerItem)) continue;
                    targetDomain = dom;
                    break;
                }
            }
            if (targetDomain != null) {
                Wunderreich.LOGGER.info("Wants to change domain to " + targetDomain);
                class_2680 state = level.method_8320(blockPos);
                WunderKisteDomain domain = WunderKisteServerExtension.getDomain(state);
                if (!domain.equals((Object)targetDomain)) {
                    if (level instanceof class_3218) {
                        int cost;
                        class_3218 server = (class_3218)level;
                        Wunderreich.LOGGER.info("Will change domain to " + targetDomain);
                        server.method_8652(blockPos, (class_2680)state.method_11657(DOMAIN, (Comparable)((Object)targetDomain)), 3);
                        this.dispatchParticles(level, blockPos, targetDomain);
                        if (!player.method_31549().field_7477 && (cost = WunderreichRules.Wunderkiste.recolorCost()) > 0) {
                            tool.method_7934(cost);
                        }
                    }
                    if (player instanceof class_3222) {
                        class_3222 sp = (class_3222)player;
                        WunderreichAdvancements.COLOR_WUNDERKISTE.method_9141(sp);
                    }
                    return class_1269.method_29236((boolean)level.field_9236);
                }
                return class_1269.field_5811;
            }
            class_2338 blockPos2 = blockPos.method_10084();
            if (level.method_8320(blockPos2).method_26212((class_1922)level, blockPos2)) {
                return class_1269.method_29236((boolean)level.field_9236);
            }
            if (level.field_9236) {
                return class_1269.field_5812;
            }
            WunderKisteBlockEntity wunderKisteBlockEntity = (WunderKisteBlockEntity)entity;
            ((ActiveChestStorage)player).setActiveWunderKiste(wunderKisteBlockEntity);
            WunderKisteDomain domain = WunderKisteServerExtension.getDomain(blockState);
            player.method_17355((class_3908)new class_747((containerID, inventory, playerx) -> class_1707.method_19245((int)containerID, (class_1661)inventory, (class_1263)wunderKisteContainer), (class_2561)(WunderreichRules.Wunderkiste.haveMultiple() ? class_2561.method_43469((String)"%s - %s", (Object[])new Object[]{CONTAINER_TITLE, WunderreichRules.Wunderkiste.namedNetworks() && wunderKisteBlockEntity.method_16914() ? wunderKisteBlockEntity.method_5797() : WunderKisteItem.getDomainComponent(domain)}) : CONTAINER_TITLE)));
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                WunderreichAdvancements.OPEN_WUNDERKISTE.method_9141(sp);
            }
            class_4838.method_24733((class_1657)player, (boolean)true);
            return class_1269.field_21466;
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public void method_9496(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_5819 random) {
        for (int i = 0; i < 3; ++i) {
            int xFactor = random.method_43048(2) * 2 - 1;
            int zFactor = random.method_43048(2) * 2 - 1;
            double x0 = (double)blockPos.method_10263() + 0.5 + 0.25 * (double)xFactor;
            double y0 = (float)blockPos.method_10264() + random.method_43057();
            double z0 = (double)blockPos.method_10260() + 0.5 + 0.25 * (double)zFactor;
            double xd = random.method_43057() * (float)xFactor;
            double yd = ((double)random.method_43057() - 0.5) * 0.125;
            double zd = random.method_43057() * (float)zFactor;
            level.method_8406((class_2394)WunderreichParticles.EIR_PARTICLES, x0, y0, z0, xd, yd, zd);
        }
    }

    public boolean method_9498(@NotNull class_2680 blockState) {
        return WunderreichRules.Wunderkiste.analogRedstoneOutput();
    }

    public int method_9572(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos) {
        WunderKisteContainer wunderKisteContainer;
        if (WunderreichRules.Wunderkiste.analogRedstoneOutput() && (wunderKisteContainer = WunderKisteBlock.getContainer(blockState, level.method_8321(blockPos), level)) != null) {
            return class_1703.method_7618((class_1263)wunderKisteContainer);
        }
        return 0;
    }

    public boolean method_9506(@NotNull class_2680 blockState) {
        return WunderreichRules.Wunderkiste.redstonePowerWhenOpened();
    }

    public int method_9524(@NotNull class_2680 blockState, @NotNull class_1922 blockGetter, @NotNull class_2338 blockPos, @NotNull class_2350 direction) {
        if (!WunderreichRules.Wunderkiste.redstonePowerWhenOpened()) {
            return 0;
        }
        class_2586 entity = blockGetter.method_8321(blockPos);
        if (entity instanceof WunderKisteBlockEntity) {
            WunderKisteBlockEntity wentity = (WunderKisteBlockEntity)entity;
            WunderKisteDomain.ID domain = WunderKisteServerExtension.getDomain(blockState, wentity);
            return hasAnyOpenInstance.getOrDefault(domain, false) != false ? 15 : 0;
        }
        return 0;
    }

    public class_2586 method_10123(@NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        AddRemoveWunderKisteMessage.INSTANCE.send(true, blockPos);
        return new WunderKisteBlockEntity(blockPos, blockState);
    }

    @Deprecated
    public void method_9615(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_2680 blockState2, boolean bl) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            AddRemoveWunderKisteMessage.addedBox(serverLevel, blockPos);
        } else {
            AddRemoveWunderKisteMessage.INSTANCE.send(true, blockPos);
        }
        super.method_9615(blockState, level, blockPos, blockState2, bl);
    }

    @Deprecated
    public void method_9536(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_2680 blockState2, boolean bl) {
        super.method_9536(blockState, level, blockPos, blockState2, bl);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            AddRemoveWunderKisteMessage.removedBox(serverLevel, blockPos);
        } else {
            AddRemoveWunderKisteMessage.INSTANCE.send(false, blockPos);
        }
        if (!blockState.method_31709() || !blockState.method_27852(blockState2.method_26204())) {
            // empty if block
        }
    }

    public class_1278 method_17680(@NotNull class_2680 blockState, class_1936 levelAccessor, @NotNull class_2338 blockPos) {
        return WunderKisteBlock.getContainer(blockState, levelAccessor.method_8321(blockPos), levelAccessor.method_8503());
    }

    @Override
    public void supplyTags(Consumer<class_6862<class_2248>> blockTags, Consumer<class_6862<class_1792>> itemTags) {
        blockTags.accept((class_6862<class_2248>)class_3481.field_33715);
    }

    @Override
    public class_2591 getBlockEntityType() {
        return WunderreichBlockEntities.BLOCK_ENTITY_WUNDER_KISTE;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_5614 getBlockEntityRenderProvider() {
        return WunderkisteRenderer::new;
    }

    public List<class_1799> method_9560(@NotNull class_2680 blockState, class_8567.class_8568 builder) {
        class_2586 entity = (class_2586)builder.method_51876(class_181.field_1228);
        return super.method_9560(blockState, builder).stream().map(stack -> {
            class_1792 patt21955$temp = stack.method_7909();
            if (patt21955$temp instanceof WunderKisteItem) {
                WunderKisteBlockEntity wentity;
                WunderKisteItem item = (WunderKisteItem)patt21955$temp;
                stack = WunderKisteItem.setDomain(stack, WunderKisteServerExtension.getDomain(blockState));
                if (entity instanceof WunderKisteBlockEntity && (wentity = (WunderKisteBlockEntity)entity).method_16914()) {
                    stack.method_7977(wentity.method_5797());
                }
            }
            return stack;
        }).collect(Collectors.toList());
    }

    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1309 livingEntity, class_1799 itemStack) {
        class_2586 class_25862;
        if (itemStack.method_7938() && (class_25862 = level.method_8321(blockPos)) instanceof WunderKisteBlockEntity) {
            WunderKisteBlockEntity entity = (WunderKisteBlockEntity)class_25862;
            entity.setDomainName(itemStack.method_7964());
        }
    }

    public void method_9576(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        super.method_9576(level, blockPos, blockState, player);
    }

    @Override
    public LootTableJsonBuilder buildLootTable() {
        LootTableJsonBuilder b = LootTableJsonBuilder.create((class_2248)this).startPool(1.0, 0.0, poolBuilder -> poolBuilder.startAlternatives(altBuilder -> ((LootTableJsonBuilder.AlternativeEntryBuilder)altBuilder.startSelfEntry(LootTableJsonBuilder.EntryBuilder::silkTouch)).startItemEntry(class_1802.field_22021, builder -> builder.setCount(4, false).explosionDecay())));
        return b;
    }

    static {
        hasAnyOpenInstance = Maps.newHashMap();
        FACING = class_2383.field_11177;
        WATERLOGGED = class_2741.field_12508;
        SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        CONTAINER_TITLE = class_2561.method_43471((String)"container.wunderreich.wunder_kiste");
        DEFAULT_DOMAIN = WunderKisteDomain.WHITE;
        DOMAIN = class_2754.method_11850((String)"domain", WunderKisteDomain.class);
    }
}

