/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.client;

import com.google.common.collect.Maps;
import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.config.Configs;
import de.ambertation.wunderreich.gui.overlay.InputManager;
import de.ambertation.wunderreich.interfaces.BlockEntityProvider;
import de.ambertation.wunderreich.interfaces.ChangeRenderLayer;
import de.ambertation.wunderreich.registries.CreativeTabs;
import de.ambertation.wunderreich.registries.WunderreichParticles;
import de.ambertation.wunderreich.registries.WunderreichScreens;
import de.ambertation.wunderreich.registries.WunderreichSlabBlocks;
import de.ambertation.wunderreich.utils.WunderKisteDomain;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1933;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class WunderreichClient
implements ClientModInitializer {
    private static final Map<String, class_4730> WUNDERKISTE_MATERIALS = Maps.newHashMap();
    public static class_4730 WUNDER_KISTE_LOCATION = WunderreichClient.getWunderkisteColor("wunder_kiste");
    public static class_4730 WUNDER_KISTE_TOP_LOCATION = WunderreichClient.chestMaterial("wunder_kiste_top");
    public static class_4730 WUNDER_KISTE_MONOCHROME_TOP_LOCATION = WunderreichClient.chestMaterial("wunder_kiste_bw_top");
    private static class_304 transformKey;

    private static class_4730 chestMaterial(String string) {
        return new class_4730(class_4722.field_21709, Wunderreich.ID("entity/chest/" + string));
    }

    public static class_4730 getWunderkisteColor(String name) {
        return WUNDERKISTE_MATERIALS.computeIfAbsent(name, WunderreichClient::chestMaterial);
    }

    public static void getAllWunderkisteMaterials(Consumer<class_4730> consumer) {
        WunderKisteDomain.WHITE.getMaterial();
        for (Map.Entry<String, class_4730> entry : WUNDERKISTE_MATERIALS.entrySet()) {
            consumer.accept(entry.getValue());
        }
    }

    public void onInitializeClient() {
        WunderreichParticles.register();
        WunderreichScreens.registerScreens();
        CreativeTabs.register();
        class_7923.field_41175.forEach(block -> {
            Object view;
            if (block instanceof ChangeRenderLayer) {
                view = (ChangeRenderLayer)block;
                BlockRenderLayerMap.INSTANCE.putBlock(block, view.getRenderType());
            }
            if (block instanceof BlockEntityProvider) {
                view = (BlockEntityProvider)block;
                BlockEntityRendererRegistry.register(view.getBlockEntityType(), view.getBlockEntityRenderProvider());
            }
        });
        if (Configs.BLOCK_CONFIG.isEnabled(WunderreichSlabBlocks.GRASS_SLAB)) {
            ColorProviderRegistry.BLOCK.register((state, view, pos, tintIndex) -> {
                if (tintIndex == 0) {
                    return view != null && pos != null ? class_1163.method_4962((class_1920)view, (class_2338)pos) : class_1933.method_8377((double)0.5, (double)1.0);
                }
                return -1;
            }, (Object[])new class_2248[]{WunderreichSlabBlocks.GRASS_SLAB});
            ColorProviderRegistry.ITEM.register((item, tintIndex) -> class_1933.method_8377((double)0.5, (double)1.0), (Object[])new class_1935[]{WunderreichSlabBlocks.GRASS_SLAB});
        }
        if (((Boolean)Configs.MAIN.allowConstructionTools.get()).booleanValue()) {
            transformKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.wunderreich.transform", class_3675.class_307.field_1668, 46, "category.wunderreich"));
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                while (transformKey.method_1436()) {
                    InputManager.INSTANCE.startTransformMode();
                }
            });
        }
    }
}

