/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.config;

import de.ambertation.wunderreich.config.LevelDataFile;
import de.ambertation.wunderreich.utils.WunderKisteDomain;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_32;
import net.minecraft.class_5218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelData {
    public static final String DATA_FOLDER = "data";
    private static final String LIVEBLOCKS_TAG_NAME = "live_blocks";
    private static LevelData INSTANCE;
    @Nullable
    Path levelPath;
    @Nullable
    LevelDataFile levelFile;
    private static final Map<String, LevelDataFile> FILES;

    private LevelData() {
    }

    public static LevelData getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LevelData();
        }
        return INSTANCE;
    }

    private void reset() {
        this.levelFile = null;
        this.levelPath = null;
        for (LevelDataFile f : FILES.values()) {
            f.reset();
        }
        FILES.clear();
    }

    public void loadNewLevel(class_32.class_5143 accessor) {
        this.reset();
        if (accessor == null) {
            return;
        }
        this.levelPath = accessor.method_27010(class_5218.field_24188);
        this.levelFile = new LevelDataFile(this, "");
        this.levelFile.load();
    }

    public void saveLevelConfig() {
        if (this.levelFile != null) {
            this.levelFile.save();
        }
    }

    @NotNull
    public class_2487 getRoot() {
        if (this.levelFile != null) {
            return this.levelFile.getRoot();
        }
        return new class_2487();
    }

    public class_2487 getLiveBlocks(String type) {
        class_2487 liveBlocks;
        class_2487 root = this.getRoot();
        if (!root.method_10545(LIVEBLOCKS_TAG_NAME)) {
            liveBlocks = new class_2487();
            root.method_10566(LIVEBLOCKS_TAG_NAME, (class_2520)liveBlocks);
        } else {
            liveBlocks = root.method_10562(LIVEBLOCKS_TAG_NAME);
        }
        if (!liveBlocks.method_10545(type)) {
            class_2487 item = new class_2487();
            liveBlocks.method_10566(type, (class_2520)item);
            return item;
        }
        return liveBlocks.method_10562(type);
    }

    public class_2487 getWunderkisteInventory(WunderKisteDomain.ID domain) {
        if (domain.extraFile == null) {
            return this.levelFile.getWunderkisteInventory(domain.toString());
        }
        return domain.extraFile.getWunderkisteInventory(domain.toString());
    }

    public void saveWunderkisteInventory(WunderKisteDomain.ID domain) {
        if (domain.extraFile == null) {
            this.saveLevelConfig();
        } else {
            domain.extraFile.save();
        }
    }

    public LevelDataFile fileForName(String name) {
        return FILES.computeIfAbsent(name, n -> new LevelDataFile(this, (String)n));
    }

    Path dataPath() {
        return this.levelPath.resolve(DATA_FOLDER);
    }

    static {
        FILES = new HashMap<String, LevelDataFile>();
    }
}

