/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.config;

import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.blocks.WunderKisteBlock;
import de.ambertation.wunderreich.config.LevelData;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class LevelDataFile {
    private static final String WUNDERKISTE_TAG_NAME = "wunderkiste";
    private static final String OLD_GLOBAL_TAG_NAME = "global";
    @NotNull
    private LevelData levelData;
    private String baseName;
    private boolean didLoad = false;
    @NotNull
    private class_2487 root = new class_2487();

    public LevelDataFile(LevelData levelData, String baseName) {
        this.levelData = levelData;
        this.baseName = baseName;
    }

    void reset() {
        this.root = new class_2487();
        this.didLoad = false;
    }

    private File getDataFile(String comment) {
        assert (this.baseName != null);
        return this.levelData.dataPath().resolve("wunderreich" + this.baseName + comment + ".nbt").toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        LevelDataFile levelDataFile = this;
        synchronized (levelDataFile) {
            class_2487 loadedRoot = null;
            File dataFile = this.getDataFile("");
            if (dataFile.exists()) {
                try {
                    loadedRoot = class_2507.method_30613((File)dataFile);
                }
                catch (IOException e) {
                    Wunderreich.LOGGER.info("Unable to access level config from '{}'. Trying previous version.", dataFile.toString(), e);
                    dataFile = this.getDataFile("_old");
                    try {
                        loadedRoot = class_2507.method_30613((File)dataFile);
                    }
                    catch (IOException ee) {
                        Wunderreich.LOGGER.error("Failed to access level config from '{}'", dataFile.toString(), ee);
                    }
                }
            }
            if (loadedRoot == null) {
                loadedRoot = new class_2487();
                loadedRoot.method_10582("create_version", Wunderreich.VERSION.toString());
            }
            this.root = loadedRoot;
            this.didLoad = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        LevelDataFile levelDataFile = this;
        synchronized (levelDataFile) {
            if (this.levelData == null || this.baseName == null) {
                Wunderreich.LOGGER.error("Unable to write config " + this.baseName + " - " + this.baseName);
                return;
            }
            File tempFile = this.getDataFile("_temp");
            this.root.method_10582("modify_version", Wunderreich.VERSION.toString());
            try {
                class_2507.method_30614((class_2487)this.root, (File)tempFile);
                File dataFile = this.getDataFile("");
                File oldFile = this.getDataFile("_old");
                class_156.method_27760((File)dataFile, (File)tempFile, (File)oldFile);
            }
            catch (IOException e) {
                Wunderreich.LOGGER.error("Unable to write level config for '{}'.", this.levelData.dataPath() + " - " + this.baseName, e);
            }
        }
    }

    class_2487 getWunderkisteInventory(String domain) {
        class_2487 wunderkiste;
        class_2487 root;
        if (!this.didLoad) {
            this.load();
        }
        if (!(root = this.getRoot()).method_10545(WUNDERKISTE_TAG_NAME)) {
            wunderkiste = new class_2487();
            if (root.method_10545(OLD_GLOBAL_TAG_NAME)) {
                wunderkiste.method_10566(WunderKisteBlock.DEFAULT_DOMAIN.toString(), (class_2520)root.method_10562(OLD_GLOBAL_TAG_NAME));
                root.method_10551(OLD_GLOBAL_TAG_NAME);
            }
            root.method_10566(WUNDERKISTE_TAG_NAME, (class_2520)wunderkiste);
        } else {
            wunderkiste = root.method_10562(WUNDERKISTE_TAG_NAME);
        }
        if (wunderkiste.method_10573(domain, 10)) {
            return wunderkiste.method_10562(domain);
        }
        class_2487 global = new class_2487();
        wunderkiste.method_10566(domain, (class_2520)global);
        return global;
    }

    @NotNull
    public class_2487 getRoot() {
        return this.root;
    }
}

