/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.gui.overlay;

import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float2;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderreich.gui.overlay.RenderContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_5253;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class LinePrimitives {
    private static void addVertex(RenderContext ctx, Float3 p, float nx, float ny, float nz, int r, int g, int b, int a) {
        ctx.vertexConsumer.method_22918(ctx.pose(), (float)p.x, (float)p.y, (float)p.z).method_1336(r, g, b, a).method_23763(ctx.normal(), nx, ny, nz).method_1344();
    }

    private static void addVertex(RenderContext ctx, int corner, float nx, float ny, float nz, int r, int g, int b, int a, Float3[] corners) {
        LinePrimitives.addVertex(ctx, corners[corner], nx, ny, nz, r, g, b, a);
    }

    public static void renderLine(RenderContext ctx, Float3 start, Float3 end, int color, float alpha) {
        LinePrimitives.addLine(ctx, start.add(ctx.worldToCamSpace), end.add(ctx.worldToCamSpace), class_5253.class_5254.method_27765((int)color), class_5253.class_5254.method_27766((int)color), class_5253.class_5254.method_27767((int)color), (int)(alpha * 255.0f));
    }

    private static void addLine(RenderContext ctx, Bounds.Interpolate cornerStart, Bounds.Interpolate cornerEnd, int r, int g, int b, int a, Float3[] corners) {
        Float3 start = corners[cornerStart.idx];
        Float3 end = corners[cornerEnd.idx];
        Float3 n = end.sub(start).normalized();
        LinePrimitives.addVertex(ctx, start, (float)n.x, (float)n.y, (float)n.z, r, g, b, a);
        LinePrimitives.addVertex(ctx, end, (float)n.x, (float)n.y, (float)n.z, r, g, b, a);
    }

    private static void addLine(RenderContext ctx, Float3 start, Float3 end, int r, int g, int b, int a) {
        Float3 n = end.sub(start).normalized();
        LinePrimitives.addVertex(ctx, start, (float)n.x, (float)n.y, (float)n.z, r, g, b, a);
        LinePrimitives.addVertex(ctx, end, (float)n.x, (float)n.y, (float)n.z, r, g, b, a);
    }

    public static void renderQuad(RenderContext ctx, Float3 p1, Float3 p2, Float3 p3, Float3 p4, int color, float alpha) {
        LinePrimitives.renderQuad(ctx, p1, p2, p3, p4, class_5253.class_5254.method_27765((int)color), class_5253.class_5254.method_27766((int)color), class_5253.class_5254.method_27767((int)color), (int)(alpha * 255.0f));
    }

    public static void renderQuadXZ(RenderContext ctx, Float3 center, Float2 size, int color, float alpha) {
        Float3 sz = size.div(2.0).xxy();
        LinePrimitives.renderQuad(ctx, center.add(sz.mul(Float3.XZ_PLANE)), center.add(sz.mul(Float3.XmZ_PLANE)), center.add(sz.mul(Float3.mXmZ_PLANE)), center.add(sz.mul(Float3.mXZ_PLANE)), class_5253.class_5254.method_27765((int)color), class_5253.class_5254.method_27766((int)color), class_5253.class_5254.method_27767((int)color), (int)(alpha * 255.0f));
    }

    public static void renderQuad(RenderContext ctx, Float3 p1, Float3 p2, Float3 p3, Float3 p4, int r, int g, int b, int a) {
        LinePrimitives.renderQuadCameraSpace(ctx, p1.add(ctx.worldToCamSpace), p2.add(ctx.worldToCamSpace), p3.add(ctx.worldToCamSpace), p4.add(ctx.worldToCamSpace), r, g, b, a);
    }

    private static void renderQuadCameraSpace(RenderContext ctx, Float3 p1, Float3 p2, Float3 p3, Float3 p4, int r, int g, int b, int a) {
        LinePrimitives.addLine(ctx, p1, p2, r, g, b, a);
        LinePrimitives.addLine(ctx, p2, p3, r, g, b, a);
        LinePrimitives.addLine(ctx, p3, p4, r, g, b, a);
        LinePrimitives.addLine(ctx, p4, p1, r, g, b, a);
    }

    public static void renderSingleBlock(RenderContext ctx, class_2338 pos, float deflate, int color, float alpha) {
        float x = (float)((double)pos.method_10263() + ctx.worldToCamSpace.field_1352);
        float y = (float)((double)pos.method_10264() + ctx.worldToCamSpace.field_1351);
        float z = (float)((double)pos.method_10260() + ctx.worldToCamSpace.field_1350);
        LinePrimitives.renderCubeOutlineCameraSpace(ctx, x + deflate, y + deflate, z + deflate, 1.0f + x - deflate, 1.0f + y - deflate, 1.0f + z - deflate, class_5253.class_5254.method_27765((int)color), class_5253.class_5254.method_27766((int)color), class_5253.class_5254.method_27767((int)color), (int)(alpha * 255.0f));
    }

    public static void renderSingleBlock(RenderContext ctx, Float3 pos, float deflate, int color, float alpha) {
        float x = (float)(pos.x + ctx.worldToCamSpace.field_1352) - 0.5f;
        float y = (float)(pos.y + ctx.worldToCamSpace.field_1351) - 0.5f;
        float z = (float)(pos.z + ctx.worldToCamSpace.field_1350) - 0.5f;
        LinePrimitives.renderCubeOutlineCameraSpace(ctx, x + deflate, y + deflate, z + deflate, 1.0f + x - deflate, 1.0f + y - deflate, 1.0f + z - deflate, class_5253.class_5254.method_27765((int)color), class_5253.class_5254.method_27766((int)color), class_5253.class_5254.method_27767((int)color), (int)(alpha * 255.0f));
    }

    public static void renderBounds(RenderContext ctx, Bounds bounds, float deflate, int color, float alpha) {
        LinePrimitives.renderCubeOutlineCameraSpace(ctx, (float)(bounds.min.x + ctx.worldToCamSpace.field_1352) + deflate - 0.5f, (float)(bounds.min.y + ctx.worldToCamSpace.field_1351) + deflate - 0.5f, (float)(bounds.min.z + ctx.worldToCamSpace.field_1350) + deflate - 0.5f, (float)(bounds.max.x + ctx.worldToCamSpace.field_1352) - deflate + 0.5f, (float)(bounds.max.y + ctx.worldToCamSpace.field_1351) - deflate + 0.5f, (float)(bounds.max.z + ctx.worldToCamSpace.field_1350) - deflate + 0.5f, class_5253.class_5254.method_27765((int)color), class_5253.class_5254.method_27766((int)color), class_5253.class_5254.method_27767((int)color), (int)(alpha * 255.0f));
    }

    private static void renderCubeOutlineCameraSpace(RenderContext ctx, float lx, float ly, float lz, float hx, float hy, float hz, int r, int g, int b, int a) {
        Matrix4f pose = ctx.pose();
        Matrix3f normal = ctx.normal();
        ctx.vertexConsumer.method_22918(pose, lx, ly, lz).method_1336(r, g, b, a).method_23763(normal, 1.0f, 0.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, ly, lz).method_1336(r, g, b, a).method_23763(normal, 1.0f, 0.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, lx, ly, lz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, lx, hy, lz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, lx, ly, lz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 0.0f, 1.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, lx, ly, hz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 0.0f, 1.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, ly, lz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, hy, lz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, hy, lz).method_1336(r, g, b, a).method_23763(normal, -1.0f, 0.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, lx, hy, lz).method_1336(r, g, b, a).method_23763(normal, -1.0f, 0.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, lx, hy, lz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 0.0f, 1.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, lx, hy, hz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 0.0f, 1.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, lx, hy, hz).method_1336(r, g, b, a).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, lx, ly, hz).method_1336(r, g, b, a).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, lx, ly, hz).method_1336(r, g, b, a).method_23763(normal, 1.0f, 0.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, ly, hz).method_1336(r, g, b, a).method_23763(normal, 1.0f, 0.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, ly, hz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 0.0f, -1.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, ly, lz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 0.0f, -1.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, lx, hy, hz).method_1336(r, g, b, a).method_23763(normal, 1.0f, 0.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, hy, hz).method_1336(r, g, b, a).method_23763(normal, 1.0f, 0.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, ly, hz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, hy, hz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, hy, lz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 0.0f, 1.0f).method_1344();
        ctx.vertexConsumer.method_22918(pose, hx, hy, hz).method_1336(r, g, b, a).method_23763(normal, 0.0f, 0.0f, 1.0f).method_1344();
    }

    public static void renderTransform(RenderContext ctx, Transform t, int color, float alpha) {
        LinePrimitives.renderTransform(ctx, t, class_5253.class_5254.method_27765((int)color), class_5253.class_5254.method_27766((int)color), class_5253.class_5254.method_27767((int)color), (int)(alpha * 255.0f));
    }

    private static void renderTransform(RenderContext ctx, Transform t, int r, int g, int b, int a) {
        Float3[] corners = t.translate(ctx.worldToCamSpace).getCornersInWorldSpace(false);
        ctx.pushText(t.toString(), corners[0].x - ctx.worldToCamSpace.field_1352, corners[0].y - 0.1 - ctx.worldToCamSpace.field_1351, corners[0].z - ctx.worldToCamSpace.field_1350, -13260801);
        LinePrimitives.renderCornersInCamSpace(ctx, corners, r, g, b, a);
    }

    public static void renderCorners(RenderContext ctx, Float3[] corners, int color, float alpha) {
        Float3[] camCorners = new Float3[corners.length];
        for (int i = 0; i < camCorners.length; ++i) {
            camCorners[i] = corners[i].add(ctx.worldToCamSpace);
        }
        LinePrimitives.renderCornersInCamSpace(ctx, camCorners, class_5253.class_5254.method_27765((int)color), class_5253.class_5254.method_27766((int)color), class_5253.class_5254.method_27767((int)color), (int)(alpha * 255.0f));
    }

    public static void renderCornersInCamSpace(RenderContext ctx, Float3[] corners, int r, int g, int b, int a) {
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MIN_MIN_MIN, Bounds.Interpolate.MAX_MIN_MIN, r, g, b, a, corners);
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MAX_MIN_MIN, Bounds.Interpolate.MAX_MIN_MAX, r, g, b, a, corners);
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MAX_MIN_MAX, Bounds.Interpolate.MIN_MIN_MAX, r, g, b, a, corners);
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MIN_MIN_MAX, Bounds.Interpolate.MIN_MIN_MIN, r, g, b, a, corners);
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MIN_MAX_MIN, Bounds.Interpolate.MAX_MAX_MIN, r, g, b, a, corners);
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MAX_MAX_MIN, Bounds.Interpolate.MAX_MAX_MAX, r, g, b, a, corners);
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MAX_MAX_MAX, Bounds.Interpolate.MIN_MAX_MAX, r, g, b, a, corners);
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MIN_MAX_MAX, Bounds.Interpolate.MIN_MAX_MIN, r, g, b, a, corners);
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MIN_MIN_MIN, Bounds.Interpolate.MIN_MAX_MIN, r, g, b, a, corners);
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MIN_MIN_MAX, Bounds.Interpolate.MIN_MAX_MAX, r, g, b, a, corners);
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MAX_MIN_MAX, Bounds.Interpolate.MAX_MAX_MAX, r, g, b, a, corners);
        LinePrimitives.addLine(ctx, Bounds.Interpolate.MAX_MIN_MIN, Bounds.Interpolate.MAX_MAX_MIN, r, g, b, a, corners);
    }
}

