/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.gui.overlay;

import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float2;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Matrix4;
import de.ambertation.wunderlib.math.sdf.SDF;
import de.ambertation.wunderlib.math.sdf.interfaces.MaterialProvider;
import de.ambertation.wunderlib.math.sdf.shapes.Empty;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.render.RenderHelper;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderreich.gui.overlay.BlockInfo;
import de.ambertation.wunderreich.gui.overlay.InputManager;
import de.ambertation.wunderreich.gui.overlay.LinePrimitives;
import de.ambertation.wunderreich.gui.overlay.RenderContext;
import de.ambertation.wunderreich.gui.overlay.TextRenderer;
import de.ambertation.wunderreich.gui.overlay.TransformWidget;
import de.ambertation.wunderreich.items.construction.ConstructionData;
import de.ambertation.wunderreich.registries.WunderreichItems;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_863;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class OverlayRenderer
implements class_863.class_864 {
    private static final RenderContext ctx = new RenderContext();
    private static Float3 refPlanePosition = null;
    public static final int[] FILL_COLORS = new int[]{-5613750, -4299651, -5013069, -8084009, -12990756, -13573953, -7605617, -1509018};
    public static final int[] OUTLINE_COLORS = new int[]{-13427158, -12306612, -11905938, -12225396, -13068640, -12994391, -10561115, -6817895};
    public static final int COLOR_MINION_YELLOW = -6324;
    public static final int COLOR_FIERY_ROSE = -42652;
    public static final int COLOR_PURPLE = -10551110;
    public static final int COLOR_MEDIUM_PURPLE = -5543438;
    public static final int COLOR_RICH_BLACK = -16185079;
    public static final int COLOR_BLUE_JEANS = -13260801;
    public static final int COLOR_MAUVE = -2507783;
    public static final int COLOR_DARK_MAUVE = -3431690;
    public static final int COLOR_DARK_GREEN_MOSS = -12623571;
    public static final int COLOR_SELECTION = -6324;
    public static final int COLOR_OUT_OF_REACH = -42652;
    public static final int COLOR_BOUNDING_BOX = -13260801;
    public static final int COLOR_BLOCK_PREVIEW_FILL = -2507783;
    public static final int COLOR_BLOCK_PREVIEW_OUTLINE = -3431690;
    public static final OverlayRenderer INSTANCE = new OverlayRenderer();
    final List<BlockInfo> positions = new ArrayList<BlockInfo>(64);
    float time = 0.0f;

    @ApiStatus.Internal
    public void method_23109(class_4587 poseStack, class_4597 multiBufferSource, double x, double y, double z) {
        ctx.setBufferSource(multiBufferSource);
        ctx.setPoseStack(poseStack);
        class_746 player = class_310.method_1551().field_1724;
        this.positions.clear();
        refPlanePosition = null;
        class_1799 ruler = InputManager.INSTANCE.inTransformMode() ? InputManager.INSTANCE.getActiveRuler() : player.method_6047();
        if (ruler == null || !ruler.method_31574(WunderreichItems.RULER)) {
            ruler = player.method_6079();
        }
        if (ruler == null || !ruler.method_31574(WunderreichItems.RULER)) {
            return;
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        boolean showTargetBlock = false;
        if (camera.method_19332()) {
            Float3 cursorPos = this.getCursorPos(class_310.method_1551().method_1560(), 8, 4);
            cursorPos = cursorPos.mul(2.0).round().div(2.0);
            ConstructionData.setCursorPosOnClient(cursorPos);
            ctx.setCamera(camera);
            InputManager.INSTANCE.setCamera(camera);
            OverlayRenderer.ctx.vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23594());
            showTargetBlock = true;
            ConstructionData constructionData = ConstructionData.getConstructionData(ruler);
            if (constructionData != null) {
                SDF sdf = constructionData.getActiveSDF();
                if (sdf == null && !(sdf instanceof Empty)) {
                    return;
                }
                TransformWidget widget = constructionData.getActiveTransformWidget();
                sdf.setRootTransform(Matrix4.ofTranslation((Float3)constructionData.CENTER.get()));
                TextRenderer.render(ctx, constructionData.CENTER.get(), -42652);
                this.time += class_310.method_1551().method_1534();
                if (this.time > 10000.0f) {
                    this.time -= 10000.0f;
                }
                double scaledTime = (double)this.time * 0.02;
                float phase = (float)(Math.sin(Math.PI * 2 * (scaledTime - Math.floor(scaledTime))) + 1.0) / 2.0f;
                if (widget != null) {
                    Float3 bottom;
                    widget.cursorTick(cursorPos);
                    if (widget.hasHovered()) {
                        bottom = Float3.of((double)cursorPos.x, (double)(widget.hoveredCornerPos().y - 0.5), (double)cursorPos.z);
                    } else {
                        bottom = Float3.of((double)cursorPos.x, (double)Math.floor(cursorPos.y), (double)cursorPos.z);
                        refPlanePosition = Float3.of((double)Float3.toBlockPos((double)cursorPos.x), (double)Math.floor(cursorPos.y), (double)Float3.toBlockPos((double)cursorPos.z));
                        LinePrimitives.renderQuadXZ(ctx, refPlanePosition, Float2.IDENTITY, 0, 0.75f);
                    }
                    LinePrimitives.renderQuadXZ(ctx, cursorPos, Float2.of((double)0.1, (double)0.1), -6324, 0.75f);
                    LinePrimitives.renderLine(ctx, bottom, cursorPos, -6324, 1.0f);
                    LinePrimitives.renderQuadXZ(ctx, bottom, Float2.of((double)0.1, (double)0.1), 0, 0.75f);
                    widget.render(ctx, phase);
                    showTargetBlock = !widget.hasSelection();
                }
                this.renderSDF(ctx, sdf, sdf.getBoundingBox(), 0.1f, 0.8f, 1.0f, false);
                if (sdf.getParent() != null) {
                    this.renderSDF(ctx, sdf.getRoot(), sdf.getRoot().getBoundingBox(), 0.1f, 0.3f, 0.3f, false);
                }
            }
            this.positions.sort((a, b) -> {
                if (Math.abs(b.camDistSquare - a.camDistSquare) < 0.001) {
                    return 0;
                }
                if (b.camDistSquare > a.camDistSquare) {
                    return 1;
                }
                return -1;
            });
            this.renderPositionOutlines(ctx);
        } else {
            ConstructionData.setCursorPosOnClient(null);
        }
        if (!showTargetBlock || OverlayRenderer.ctx.vertexConsumer != null) {
            // empty if block
        }
        ctx.renderAllText();
        ctx.invalidate();
    }

    private void printDist(RenderContext ctx, SDF sdf, Float3 oo) {
        oo = oo.sub(0.5);
        Float3 oa = ConstructionData.getCursorPos().blockAligned();
        Float3 op = oa.add(oo);
        Float3 ot = oa.add(oo.mul(1.3).sub(0.15));
        double dist = sdf.dist(op);
        dist = (double)Math.round(dist * 4.0) / 4.0;
        ctx.pushText(Float3.toString((double)dist), ot, dist < 0.0 ? FILL_COLORS[0] : FILL_COLORS[FILL_COLORS.length - 1]);
    }

    private void renderSDF(RenderContext ctx, SDF sdf, Bounds box, float deflate, float alpha, float lineAlpha, boolean debugDist) {
        sdf.evaluate(box, (p, ed) -> {
            int mIdx = 0;
            SDF patt8889$temp = ed.source();
            if (patt8889$temp instanceof MaterialProvider) {
                MaterialProvider mp = (MaterialProvider)patt8889$temp;
                mIdx = mp.getMaterialIndex();
            }
            this.positions.add(BlockInfo.withCamPos(p, ctx.camToWorldSpace, deflate, FILL_COLORS[mIdx % FILL_COLORS.length], alpha, OUTLINE_COLORS[mIdx % OUTLINE_COLORS.length], lineAlpha));
        }, debugDist ? (p, ed, didPlace) -> ctx.pushText("" + (double)Math.round(4.0 * ed.dist()) / 4.0, p, ed.dist() < 0.0 ? -42652 : -13260801) : null);
    }

    @ApiStatus.Internal
    public void renderPositionBlocks(class_4587 poseStack, class_4184 camera) {
        if (camera.method_19332()) {
            ctx.setPoseStack(poseStack);
            OverlayRenderer.ctx.worldToCamSpace = camera.method_19326().method_22882();
            BlockInfo.renderTransparentPositions(ctx, this.positions, refPlanePosition);
        }
    }

    @ApiStatus.Internal
    public void renderHUD(class_332 guiGraphics) {
        class_327 font = class_310.method_1551().field_1772;
        if (InputManager.INSTANCE.inTransformMode()) {
            SDF sdf;
            ConstructionData cd;
            class_1799 ruler;
            class_5250 c = null;
            if (InputManager.INSTANCE.getMode() == InputManager.Mode.NONE) {
                c = class_2561.method_43470((String)"Transform Mode:\n  **t**: Move\n  **r**: Rotate\n  **z**: Scale\n  **ALT+t**,**ALT+r**,**ALT+z**: Reset");
            } else if (InputManager.INSTANCE.getMode() == InputManager.Mode.TRANSLATE) {
                c = class_2561.method_43470((String)"Transform Mode - Move:\n  **x**, **y**, **z**: Transform along Axis\n **SHIFT**: Lock Axis\n **CTRL**: Round");
            } else if (InputManager.INSTANCE.getMode() == InputManager.Mode.ROTATE) {
                c = class_2561.method_43470((String)"Transform Mode - Rotate:\n  **x**, **y**, **z**: Transform along Axis\n **SHIFT**: Lock Axis\n **CTRL**: Round");
            } else if (InputManager.INSTANCE.getMode() == InputManager.Mode.SCALE) {
                c = class_2561.method_43470((String)"Transform Mode - Scale:\n  **x**, **y**, **z**: Transform along Axis\n **SHIFT**: Lock Axis\n **CTRL**: Round");
            }
            float y = 8.0f;
            if (c != null) {
                y = TextRenderer.draw(guiGraphics, font, Float2.of((double)8.0), class_310.method_1551().method_22683().method_4489() - 16, (class_2561)c, ColorHelper.WHITE);
            }
            if (InputManager.INSTANCE.getMode() != InputManager.Mode.NONE) {
                String axis = null;
                String type = "axis";
                String space = "world";
                if ((InputManager.INSTANCE.getLockFlag() & 1) != 0) {
                    axis = "x";
                }
                if ((InputManager.INSTANCE.getLockFlag() & 2) != 0) {
                    axis = "y";
                }
                if ((InputManager.INSTANCE.getLockFlag() & 4) != 0) {
                    axis = "z";
                }
                if ((InputManager.INSTANCE.getLockFlag() & 0x10) != 0) {
                    type = "inverted";
                }
                if ((InputManager.INSTANCE.getLockFlag() & 8) != 0 && !InputManager.INSTANCE.willWriteAbsolute()) {
                    space = "local";
                }
                if (axis != null) {
                    y = TextRenderer.draw(guiGraphics, font, Float2.of((double)8.0, (double)y), class_310.method_1551().method_22683().method_4489() - 16, (class_2561)class_2561.method_43471((String)("info.wunderreich." + space + "_" + axis + "_" + type)), ColorHelper.YELLOW);
                }
            }
            if (InputManager.INSTANCE.getMode() != InputManager.Mode.NONE) {
                String write = "change";
                if (InputManager.INSTANCE.willWriteAbsolute()) {
                    write = "write";
                }
                y = InputManager.INSTANCE.hasNumberString() ? TextRenderer.draw(guiGraphics, font, Float2.of((double)8.0, (double)y), class_310.method_1551().method_22683().method_4489() - 16, (class_2561)class_2561.method_43470((String)(InputManager.INSTANCE.getNumberString() + " [" + InputManager.INSTANCE.getDeltaString() + "]")).method_10852((class_2561)class_2561.method_43471((String)("info.wunderreich.transform_" + write))), InputManager.INSTANCE.isValidNumberString() ? ColorHelper.YELLOW : ColorHelper.RED) : TextRenderer.draw(guiGraphics, font, Float2.of((double)8.0, (double)y), class_310.method_1551().method_22683().method_4489() - 16, (class_2561)class_2561.method_43470((String)InputManager.INSTANCE.getDeltaString()).method_10852((class_2561)class_2561.method_43471((String)("info.wunderreich.transform_" + write))), ColorHelper.YELLOW);
                if (class_310.method_1551().method_22683() != null) {
                    int widgetSize = 100;
                    Rectangle r = new Rectangle(8, class_310.method_1551().method_22683().method_4502() - 8 - 100, 100, 100);
                    Float2 center = r.center();
                    Float2 offset = center.add(InputManager.INSTANCE.getMouseDelta());
                    guiGraphics.method_25294((int)center.x - 2, (int)center.y - 2, (int)center.x + 2, (int)center.y + 2, 0x77000000);
                    guiGraphics.method_25294((int)center.x - 1, (int)center.y - 1, (int)center.x + 1, (int)center.y + 1, 0x77FFFFFF);
                    guiGraphics.method_25294((int)offset.x - 2, (int)offset.y - 2, (int)offset.x + 2, (int)offset.y + 2, ColorHelper.BLACK);
                    guiGraphics.method_25294((int)offset.x - 1, (int)offset.y - 1, (int)offset.x + 1, (int)offset.y + 1, ColorHelper.YELLOW);
                    RenderHelper.outline((class_332)guiGraphics, (int)r.left, (int)r.top, (int)r.right(), (int)r.bottom(), (int)0x77FFFFFF);
                }
            }
            if ((ruler = InputManager.INSTANCE.getActiveRuler()) != null && (cd = ConstructionData.getConstructionData(ruler)) != null && (sdf = cd.getActiveSDF()) != null) {
                y += 8.0f;
                y = TextRenderer.draw(guiGraphics, font, Float2.of((double)8.0, (double)y), class_310.method_1551().method_22683().method_4489() - 16, (class_2561)class_2561.method_43470((String)("c: " + sdf.getLocalTransform().center.toString())), ColorHelper.YELLOW);
                y = TextRenderer.draw(guiGraphics, font, Float2.of((double)8.0, (double)y), class_310.method_1551().method_22683().method_4489() - 16, (class_2561)class_2561.method_43470((String)("s: " + sdf.getLocalTransform().size.toString())), ColorHelper.YELLOW);
                y = TextRenderer.draw(guiGraphics, font, Float2.of((double)8.0, (double)y), class_310.method_1551().method_22683().method_4489() - 16, (class_2561)class_2561.method_43470((String)("r: " + sdf.getLocalTransform().rotation.toEuler().toString())), ColorHelper.YELLOW);
            }
        }
    }

    private void renderPositionOutlines(RenderContext ctx) {
        for (BlockInfo pos : this.positions) {
            if (!(pos.outlineAlpha > 0.0f)) continue;
            LinePrimitives.renderSingleBlock(ctx, pos.pos, pos.deflate - 1.0E-4f, pos.outlineColor, pos.outlineAlpha);
        }
    }

    private Float3 getCursorPos(class_1297 cameraEntity, int reach, int emptyDist) {
        return Float3.of((class_243)cameraEntity.method_33571().method_1019(cameraEntity.method_5828(1.0f).method_1021((double)emptyDist)));
    }

    @NotNull
    private class_2338 getTargetedBlock(class_1297 cameraEntity, int reach, int emptyDist) {
        return this.getCursorPos(cameraEntity, reach, emptyDist).toBlockPos();
    }
}

