/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.items.construction;

import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Matrix4;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.SDF;
import de.ambertation.wunderlib.math.sdf.interfaces.MaterialProvider;
import de.ambertation.wunderlib.math.sdf.interfaces.Transformable;
import de.ambertation.wunderreich.gui.construction.RulerContainer;
import de.ambertation.wunderreich.gui.overlay.TransformWidget;
import de.ambertation.wunderreich.items.construction.Ruler;
import de.ambertation.wunderreich.network.ChangedTargetBlockMessage;
import de.ambertation.wunderreich.noise.OpenSimplex2;
import de.ambertation.wunderreich.utils.RandomList;
import de.ambertation.wunderreich.utils.nbt.CachedNBTValue;
import de.ambertation.wunderreich.utils.nbt.NbtTagHelper;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public class ConstructionData {
    private static final String SDF_TAG = "sdf";
    private static final String CENTER_TAG = "c";
    private static final String SELECTED_CORNER_TAG = "sc";
    private static final String MATERIAL_TAG = "m";
    private static final String ACTIVE_SLOT_TAG = "a";
    private static final String TRANSFORM_STATE_TAG = "ts";
    private static final int VALID_RADIUS_SQUARE = 4096;
    private static final String CONSTRUCTION_DATA_TAG = "construction";
    public final CachedNBTValue<Float3, class_2487> CENTER;
    public final CachedNBTValue<Bounds.Interpolate, class_2481> SELECTED_CORNER;
    public final CachedNBTValue<SDF, class_2520> SDF_DATA;
    public final CachedNBTValue<Integer, class_2497> ACTIVE_SLOT;
    public final CachedNBTValue<RulerContainer, class_2499> MATERIAL_DATA;
    @ApiStatus.Internal
    private static Float3 lastTarget;
    private TransformWidget activeTransformWidget;

    public ConstructionData(class_2487 baseTag) {
        this.CENTER = new CachedNBTValue<Float3, class_2487>(baseTag, CENTER_TAG, Float3.ZERO, NbtTagHelper::readPos, NbtTagHelper::writePos);
        this.SELECTED_CORNER = new CachedNBTValue<Bounds.Interpolate, class_2481>(baseTag, SELECTED_CORNER_TAG, NbtTagHelper::readInterpolated, NbtTagHelper::writeInterpolated);
        this.SDF_DATA = new CachedNBTValue<SDF, class_2520>(baseTag, SDF_TAG, NbtTagHelper::readSDF, NbtTagHelper::writeSDF, this::sdfObjectDidChange);
        this.MATERIAL_DATA = new CachedNBTValue<RulerContainer, class_2499>(baseTag, MATERIAL_TAG, tag -> {
            RulerContainer rc = new RulerContainer();
            NbtTagHelper.readContainer(tag, rc);
            return rc;
        }, NbtTagHelper::writeContainer);
        this.ACTIVE_SLOT = new CachedNBTValue<Integer, class_2497>(baseTag, ACTIVE_SLOT_TAG, 0, class_2497::method_10701, class_2497::method_23247, this::changedActiveSlot);
        this.updateActiveTransformWidget();
        if (this.getActiveTransformWidget() != null) {
            if (!baseTag.method_10573(TRANSFORM_STATE_TAG, 10)) {
                baseTag.method_10566(TRANSFORM_STATE_TAG, (class_2520)new class_2487());
            }
            this.getActiveTransformWidget().setDataTag(baseTag.method_10562(TRANSFORM_STATE_TAG));
            this.getActiveTransformWidget().readState();
        }
    }

    public void changedActiveSlot(int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.updateActiveTransformWidget();
        }
    }

    public TransformWidget getActiveTransformWidget() {
        return this.activeTransformWidget;
    }

    public void updateActiveTransformWidget() {
        SDF sdf = this.getActiveSDF();
        if (sdf instanceof Transformable) {
            Transformable source = (Transformable)sdf;
            sdf.setRootTransform(Matrix4.ofTranslation((Float3)this.CENTER.get()));
            this.activeTransformWidget = new TransformWidget(source);
        } else {
            this.activeTransformWidget = null;
        }
    }

    public static Float3 getCursorPos() {
        return lastTarget;
    }

    public static void setCursorPosOnClient(Float3 newTarget) {
        if (ConstructionData.setCursorPosCommon(newTarget)) {
            ChangedTargetBlockMessage.INSTANCE.send(newTarget);
        }
    }

    public static void setCursorPosOnServer(Float3 lastTarget) {
        ConstructionData.setCursorPosCommon(lastTarget);
    }

    private static boolean setCursorPosCommon(Float3 newTarget) {
        if (lastTarget == newTarget) {
            return false;
        }
        if (lastTarget == null || newTarget == null || !lastTarget.equals((Object)newTarget)) {
            lastTarget = newTarget;
            return true;
        }
        return false;
    }

    public void sdfObjectDidChange(SDF old, SDF fresh) {
    }

    public static ConstructionData getConstructionData(class_1799 itemStack) {
        if (itemStack.method_7909() instanceof Ruler) {
            class_2487 tag = itemStack.method_7948();
            return ConstructionData.getConstructionData(tag);
        }
        return null;
    }

    public static ConstructionData getConstructionData(class_2487 tag) {
        if (tag == null) {
            return null;
        }
        if (!tag.method_10545(CONSTRUCTION_DATA_TAG)) {
            tag.method_10566(CONSTRUCTION_DATA_TAG, (class_2520)new class_2487());
        }
        return new ConstructionData(tag.method_10562(CONSTRUCTION_DATA_TAG));
    }

    public SDF getRootSDF() {
        SDF s = this.SDF_DATA.get();
        return s;
    }

    public SDF getActiveSDF() {
        SDF s = this.SDF_DATA.get();
        if (s == null) {
            return null;
        }
        s = s.getChildWithGraphIndex(this.ACTIVE_SLOT.get().intValue());
        return s;
    }

    public Transform updateActiveTransformOnClient(BiFunction<SDF, Transform, Transform> updater) {
        SDF s = this.getActiveSDF();
        if (s instanceof Transformable) {
            Transformable tSDF = (Transformable)s;
            Transform newTransform = updater.apply(s, tSDF.getLocalTransform());
            tSDF.setLocalTransform(newTransform);
            this.SDF_DATA.set(s.getRoot());
            return newTransform;
        }
        return null;
    }

    public Bounds.Interpolate getSelectedCorner() {
        return this.SELECTED_CORNER.get();
    }

    public void setSelectedCorner(Bounds.Interpolate bb) {
        this.SELECTED_CORNER.set(bb);
    }

    public Bounds getBoundingBoxInWorldSpace() {
        return this.getBoundingBoxInWorldSpace(this.getRootSDF());
    }

    public Bounds getActiveBoundingBoxInWorldSpace() {
        return this.getBoundingBoxInWorldSpace(this.getActiveSDF());
    }

    public Bounds getBoundingBoxInWorldSpace(SDF sdf) {
        if (sdf != null) {
            Float3 offset = this.CENTER.get();
            Bounds box = sdf.getBoundingBox();
            if (offset != null) {
                box = box.move(offset);
            }
            return box;
        }
        return Bounds.EMPTY;
    }

    public static Bounds getNewBoundsForSelectedCorner(Bounds bounds, Bounds.Interpolate selectedCorner, Float3 newCornerPos) {
        if (Objects.equals(selectedCorner.idx, Bounds.Interpolate.CENTER.idx)) {
            System.out.println("New Center:" + newCornerPos);
            return bounds.moveToCenter(newCornerPos);
        }
        Bounds.Interpolate oppositeCorner = selectedCorner.opposite();
        return Bounds.of((Float3)bounds.get(oppositeCorner), (Float3)newCornerPos);
    }

    public double distToCenterSquare(Float3 worldPos) {
        Bounds bb = this.getBoundingBoxInWorldSpace();
        if (bb == null) {
            return Double.MAX_VALUE;
        }
        return bb.getCenter().distSquare(worldPos);
    }

    public boolean inReach(Float3 worldPos) {
        return this.distToCenterSquare(worldPos) < 4096.0;
    }

    public void realize(MinecraftServer server, class_3222 player) {
        SDF sdf = this.getRootSDF();
        if (sdf != null) {
            sdf.setRootTransform(Matrix4.ofTranslation((Float3)this.CENTER.get()));
            Function<Float3, Float> noise = cPos -> Float.valueOf((1.0f + OpenSimplex2.noise3_ImproveXZ(20688L, cPos.x * 0.15, cPos.y * 0.2, cPos.z * 0.15)) / 2.0f);
            RandomList[] materials = new RandomList[8];
            for (int i = 0; i < materials.length; ++i) {
                materials[i] = new RandomList(18);
            }
            RulerContainer materialContainer = this.MATERIAL_DATA.get();
            for (int page = 0; page < 8; ++page) {
                for (int pageIndex = 0; pageIndex < 18; ++pageIndex) {
                    int slot = materialContainer.getCategorySlotIndex(page, pageIndex) + 0;
                    class_1799 stack = materialContainer.method_5438(slot);
                    if (stack == null || stack.method_7960() || !(stack.method_7909() instanceof class_1747)) continue;
                    materials[page].add(stack, stack.method_7947());
                }
            }
            sdf.evaluate((p, ed) -> {
                int mIdx = 0;
                SDF patt9813$temp = ed.source();
                if (patt9813$temp instanceof MaterialProvider) {
                    MaterialProvider mp = (MaterialProvider)patt9813$temp;
                    mIdx = mp.getMaterialIndex();
                }
                class_1799 stack = (class_1799)materials[mIdx % materials.length].getRandomAt(p, noise);
                player.method_37908().method_8652(p.toBlockPos(), ((class_1747)stack.method_7909()).method_7711().method_9564(), 2);
            }, null);
        }
    }
}

