/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.ambertation.wunderreich.loot.Entry;
import de.ambertation.wunderreich.loot.EntryCondition;
import de.ambertation.wunderreich.loot.EntryList;
import java.util.ArrayList;
import java.util.List;

class EntryPool
implements EntryList {
    private final double rolls;
    private final double bonusRolls;
    private final List<Entry> entries;
    List<EntryCondition> conditions = new ArrayList<EntryCondition>(0);

    EntryPool(double rolls, double bonusRolls) {
        this.rolls = rolls;
        this.bonusRolls = bonusRolls;
        this.entries = new ArrayList<Entry>(0);
    }

    @Override
    public void addEntry(Entry e) {
        this.entries.add(e);
    }

    void addCondition(EntryCondition c) {
        this.conditions.add(c);
    }

    JsonObject serialize() {
        JsonArray f;
        JsonObject root = new JsonObject();
        root.add("rolls", (JsonElement)new JsonPrimitive((Number)this.rolls));
        root.add("bonus_rolls", (JsonElement)new JsonPrimitive((Number)this.bonusRolls));
        if (this.entries.size() > 0) {
            f = new JsonArray();
            this.entries.stream().map(Entry::serialize).forEach(arg_0 -> ((JsonArray)f).add(arg_0));
            root.add("entries", (JsonElement)f);
        }
        if (this.conditions.size() > 0) {
            f = new JsonArray();
            this.conditions.stream().map(EntryCondition::serialize).forEach(arg_0 -> ((JsonArray)f).add(arg_0));
            root.add("conditions", (JsonElement)f);
        }
        return root;
    }
}

