/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.advancements.AdvancementsJsonBuilder;
import de.ambertation.wunderreich.config.Configs;
import de.ambertation.wunderreich.registries.WunderreichRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class StonecutterJsonBuilder {
    private static final ThreadLocal<StonecutterJsonBuilder> BUILDER = ThreadLocal.withInitial(StonecutterJsonBuilder::new);
    private class_2960 ID;
    private boolean canBuild;
    private class_1935 resultItem;
    private class_1935 ingredient;
    private int count = 1;

    private StonecutterJsonBuilder() {
    }

    public static void invalidate() {
        BUILDER.remove();
    }

    private static boolean isEnabled(class_1935 item) {
        if (item instanceof class_2248) {
            class_2248 bl = (class_2248)item;
            return Configs.BLOCK_CONFIG.isEnabled(bl);
        }
        if (item instanceof class_1792) {
            class_1792 itm = (class_1792)item;
            return Configs.ITEM_CONFIG.isEnabled(itm);
        }
        return false;
    }

    private static class_2960 getKey(class_1935 item) {
        if (item instanceof class_2248) {
            class_2248 bl = (class_2248)item;
            return class_7923.field_41175.method_10221((Object)bl);
        }
        if (item instanceof class_1792) {
            class_1792 itm = (class_1792)item;
            return class_7923.field_41178.method_10221((Object)itm);
        }
        return null;
    }

    public static StonecutterJsonBuilder create(String name) {
        class_2960 id = Wunderreich.ID(name + "_stonecutter");
        StonecutterJsonBuilder b = BUILDER.get().reset(id);
        return b;
    }

    private StonecutterJsonBuilder reset(class_2960 ID2) {
        this.ID = ID2;
        this.canBuild = (Boolean)Configs.RECIPE_CONFIG.newBooleanFor(ID2.method_12832(), ID2).get();
        this.resultItem = null;
        this.ingredient = null;
        this.count = 1;
        return this;
    }

    public StonecutterJsonBuilder result(class_1935 item) {
        this.canBuild &= StonecutterJsonBuilder.isEnabled(item);
        this.resultItem = item;
        return this;
    }

    public StonecutterJsonBuilder ingredient(class_1935 item) {
        this.canBuild &= StonecutterJsonBuilder.isEnabled(item);
        this.ingredient = item;
        return this;
    }

    public StonecutterJsonBuilder count(int count) {
        this.count = count;
        return this;
    }

    public boolean canBuild() {
        return this.canBuild;
    }

    public JsonElement registerAndCreateAdvancement(AdvancementsJsonBuilder.AdvancementType type) {
        ArrayList<class_1792> items = new ArrayList<class_1792>(1);
        class_1935 class_19352 = this.ingredient;
        if (class_19352 instanceof class_2248) {
            class_2248 bl = (class_2248)class_19352;
            items.add(bl.method_8389());
        } else {
            class_19352 = this.ingredient;
            if (class_19352 instanceof class_1792) {
                class_1792 itm = (class_1792)class_19352;
                items.add(itm);
            }
        }
        return this.registerAndCreateAdvancement(type, items);
    }

    public JsonElement registerAndCreateAdvancement(AdvancementsJsonBuilder.AdvancementType type, List<class_1792> items) {
        JsonElement res = this.register();
        if (res == null) {
            return null;
        }
        if (items.size() == 0) {
            return res;
        }
        AdvancementsJsonBuilder b = null;
        class_1935 class_19352 = this.resultItem;
        if (class_19352 instanceof class_2248) {
            class_2248 bl = (class_2248)class_19352;
            b = AdvancementsJsonBuilder.createRecipe(bl.method_8389(), type);
        } else {
            class_19352 = this.resultItem;
            if (class_19352 instanceof class_1792) {
                class_1792 itm = (class_1792)class_19352;
                b = AdvancementsJsonBuilder.createRecipe(itm, type);
            }
        }
        if (b != null) {
            int ct = 0;
            for (class_1792 item : items) {
                String name = "has_" + ct++;
                b.inventoryChangedCriteria(name, item);
            }
            b.register();
        }
        return res;
    }

    public JsonElement register() {
        if (!this.canBuild) {
            Wunderreich.LOGGER.info("Discarding Recipe for " + this.ID);
            return null;
        }
        JsonElement res = this.build();
        WunderreichRecipes.RECIPES.put(this.ID, res);
        return res;
    }

    public JsonElement build() {
        if (!this.canBuild) {
            Wunderreich.LOGGER.info("Discarding Recipe for " + this.ID);
            return null;
        }
        if (this.resultItem == null) {
            throw new IllegalStateException("A Recipe needs a Result (" + this.ID + ")");
        }
        if (this.ingredient == null) {
            throw new IllegalStateException("A Recipe needs an Ingredient (" + this.ID + ")");
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:stonecutting");
        JsonObject ing = new JsonObject();
        class_2960 ingredientLoc = StonecutterJsonBuilder.getKey(this.ingredient);
        if (ingredientLoc == null) {
            Wunderreich.LOGGER.info("Ignoring Stonecutter-Recipe for " + this.ID + " due to missing ingredient.");
            return null;
        }
        ing.addProperty("item", ingredientLoc.toString());
        json.add("ingredient", (JsonElement)ing);
        class_2960 resLoc = StonecutterJsonBuilder.getKey(this.resultItem);
        if (resLoc == null) {
            Wunderreich.LOGGER.info("Ignoring Stonecutter-Recipe for " + this.ID + " due to missing result item.");
            return null;
        }
        json.addProperty("result", resLoc.toString());
        json.addProperty("count", (Number)this.count);
        return json;
    }
}

