/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.registries;

import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.config.Configs;
import de.ambertation.wunderreich.registries.WunderreichItems;
import de.ambertation.wunderreich.utils.WunderKisteServerExtension;
import de.ambertation.wunderreich.utils.WunderreichGameRules;
import net.minecraft.class_1928;
import net.minecraft.class_3218;
import net.minecraft.class_5268;

public class WunderreichRules {
    private static final WunderreichGameRules.BooleanRule NO_NAMETAGGED_DESPAWN = new WunderreichGameRules.BooleanRule(class_1928.class_5198.field_24096, Configs.DEFAULT_RULES.doNotDespawnWithNameTag);

    public static void onLevelLoad(class_3218 l, class_5268 serverLevelData) {
        Wunderreich.LOGGER.info("Loading ServerLevel: " + l);
        WunderreichGameRules.setCurrentRules(serverLevelData.method_146());
    }

    public static void register() {
        Whispers.register();
        Wunderkiste.register();
    }

    public static boolean doNotDespawnWithNameTag() {
        return (Boolean)NO_NAMETAGGED_DESPAWN.get();
    }

    public static class Whispers {
        private static final WunderreichGameRules.IntRule DURABILITY = new WunderreichGameRules.IntRule(class_1928.class_5198.field_24100, Configs.DEFAULT_RULES.whisperDurability, 0, Integer.MAX_VALUE);
        private static final WunderreichGameRules.IntRule TRAINED_DURABILITY = new WunderreichGameRules.IntRule(class_1928.class_5198.field_24100, Configs.DEFAULT_RULES.whisperTrainedDurability, 0, Integer.MAX_VALUE);
        private static final WunderreichGameRules.IntRule MIN_XP_MULT = new WunderreichGameRules.IntRule(class_1928.class_5198.field_24097, Configs.DEFAULT_RULES.whisperMinXPMultiplier, 0, Integer.MAX_VALUE);
        private static final WunderreichGameRules.IntRule MAX_XP_MULT = new WunderreichGameRules.IntRule(class_1928.class_5198.field_24097, Configs.DEFAULT_RULES.whisperMaxXPMultiplier, 0, Integer.MAX_VALUE);
        private static final WunderreichGameRules.BooleanRule LIBRARIAN_SELECTION = new WunderreichGameRules.BooleanRule(class_1928.class_5198.field_24095, Configs.DEFAULT_RULES.allowLibrarianSelection);
        private static final WunderreichGameRules.BooleanRule TRADES_CYCLING = new WunderreichGameRules.BooleanRule(class_1928.class_5198.field_24095, Configs.DEFAULT_RULES.allowTradesCycling);
        private static final WunderreichGameRules.BooleanRule CYCLE_NEEDS_WHISPERER = new WunderreichGameRules.BooleanRule(class_1928.class_5198.field_24095, Configs.DEFAULT_RULES.cyclingNeedsWhisperer);

        public static int durability() {
            return (Integer)DURABILITY.get();
        }

        public static int trainedDurability() {
            return (Integer)TRAINED_DURABILITY.get();
        }

        public static float minXPMultiplier() {
            return (float)((Integer)MIN_XP_MULT.get()).intValue() / 100.0f;
        }

        public static float maxXPMultiplier() {
            return (float)((Integer)MAX_XP_MULT.get()).intValue() / 100.0f;
        }

        public static boolean allowLibrarianSelection() {
            return (Boolean)LIBRARIAN_SELECTION.get() != false && Configs.ITEM_CONFIG.valueOf(WunderreichItems.BLANK_WHISPERER) && Configs.ITEM_CONFIG.valueOf(WunderreichItems.WHISPERER);
        }

        public static boolean allowTradesCycling() {
            return (Boolean)TRADES_CYCLING.get();
        }

        public static boolean cyclingNeedsWhisperer() {
            return (Boolean)CYCLE_NEEDS_WHISPERER.get() != false && (Configs.ITEM_CONFIG.valueOf(WunderreichItems.BLANK_WHISPERER) || Configs.ITEM_CONFIG.valueOf(WunderreichItems.WHISPERER));
        }

        static void register() {
        }
    }

    public static class Wunderkiste {
        private static final WunderreichGameRules.BooleanRule REDSTONE_POWER = new WunderreichGameRules.BooleanRule(class_1928.class_5198.field_24098, Configs.DEFAULT_RULES.wunderkisteRedstonePowerWhenOpened);
        private static final WunderreichGameRules.BooleanRule ANALOG_REDSTONE = new WunderreichGameRules.BooleanRule(class_1928.class_5198.field_24098, Configs.DEFAULT_RULES.wunderkisteAnalogRedstoneOutput);
        private static final WunderreichGameRules.BooleanRule SHOW_COLOR_WUNDERKISTE = new WunderreichGameRules.BooleanRule(class_1928.class_5198.field_24100, Configs.DEFAULT_RULES.wunderkisteShowColored);
        private static final WunderreichGameRules.BooleanRule ALLOW_WUNDERKISTE_DOMAINS = new WunderreichGameRules.BooleanRule(class_1928.class_5198.field_24100, Configs.DEFAULT_RULES.wunderkisteAllowDomains);
        private static final WunderreichGameRules.BooleanRule ALLOW_WUNDERKISTE_NAMED_DOMAINS = new WunderreichGameRules.BooleanRule(class_1928.class_5198.field_24100, Configs.DEFAULT_RULES.wunderkisteAllowNamedDomains);
        private static final WunderreichGameRules.BooleanRule CAN_COLOR_WUNDERKISTE = new WunderreichGameRules.BooleanRule(class_1928.class_5198.field_24094, Configs.DEFAULT_RULES.wunderkisteCanColor);
        private static final WunderreichGameRules.IntRule COLOR_COST_WUNDERKISTE = new WunderreichGameRules.IntRule(class_1928.class_5198.field_24100, Configs.DEFAULT_RULES.wunderkisteChangeDomainCost, 0, 64);
        private static final WunderreichGameRules.IntRule CHUNK_LOADER_DIST_WUNDERKISTE = new WunderreichGameRules.IntRule(class_1928.class_5198.field_24098, Configs.DEFAULT_RULES.wunderkisteChunkLoaderRadius, 0, 5, (server, value) -> WunderKisteServerExtension.WUNDERKISTEN.rebuildLoadedChunks());

        public static boolean redstonePowerWhenOpened() {
            return (Boolean)REDSTONE_POWER.get();
        }

        public static boolean analogRedstoneOutput() {
            return (Boolean)ANALOG_REDSTONE.get();
        }

        public static boolean showColors() {
            return (Boolean)SHOW_COLOR_WUNDERKISTE.get();
        }

        public static boolean canColor() {
            return (Boolean)CAN_COLOR_WUNDERKISTE.get();
        }

        public static boolean haveMultiple() {
            return (Boolean)ALLOW_WUNDERKISTE_DOMAINS.get();
        }

        public static boolean namedNetworks() {
            return Wunderkiste.haveMultiple() && (Boolean)ALLOW_WUNDERKISTE_NAMED_DOMAINS.get() != false;
        }

        public static int recolorCost() {
            return (Integer)COLOR_COST_WUNDERKISTE.get();
        }

        public static int chunkLoaderDist() {
            return (Integer)CHUNK_LOADER_DIST_WUNDERKISTE.get();
        }

        public static boolean colorsOrDomains() {
            return Wunderkiste.showColors() || Wunderkiste.canColor() || Wunderkiste.haveMultiple();
        }

        public static boolean isRedstoneEnabled() {
            return Wunderkiste.redstonePowerWhenOpened() || Wunderkiste.analogRedstoneOutput();
        }

        static void register() {
        }
    }
}

