/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.utils;

import com.google.common.collect.Maps;
import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.blockentities.WunderKisteBlockEntity;
import de.ambertation.wunderreich.blocks.WunderKisteBlock;
import de.ambertation.wunderreich.inventory.WunderKisteContainer;
import de.ambertation.wunderreich.registries.WunderreichRules;
import de.ambertation.wunderreich.utils.LiveBlockManager;
import de.ambertation.wunderreich.utils.WunderKisteDomain;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import org.jetbrains.annotations.Nullable;

public class WunderKisteServerExtension {
    private final Map<WunderKisteDomain.ID, WunderKisteContainer> containers = Maps.newHashMap();
    public static final LiveBlockManager<LiveBlockManager.LiveBlock> WUNDERKISTEN = new LiveBlockManager("wunderkiste");

    public static WunderKisteDomain getDomain(class_2680 state) {
        if (WunderreichRules.Wunderkiste.colorsOrDomains() && state.method_28498(WunderKisteBlock.DOMAIN)) {
            return (WunderKisteDomain)((Object)state.method_11654(WunderKisteBlock.DOMAIN));
        }
        return WunderKisteBlock.DEFAULT_DOMAIN;
    }

    public static WunderKisteDomain.ID getDomain(class_2680 state, @Nullable class_2586 entity) {
        WunderKisteBlockEntity kiste;
        if (WunderreichRules.Wunderkiste.namedNetworks() && entity instanceof WunderKisteBlockEntity && (kiste = (WunderKisteBlockEntity)entity).method_16914()) {
            return kiste.getDomainName();
        }
        return WunderKisteServerExtension.getDomain((class_2680)state).domainID;
    }

    public WunderKisteContainer getContainer(class_2680 state, @Nullable class_2586 entity) {
        return this.getContainer(WunderKisteServerExtension.getDomain(state, entity));
    }

    public WunderKisteContainer getContainer(WunderKisteDomain.ID domainID) {
        return this.containers.computeIfAbsent(WunderreichRules.Wunderkiste.haveMultiple() ? domainID : WunderKisteBlock.DEFAULT_DOMAIN.domainID, d -> this.loadOrCreate(domainID));
    }

    private WunderKisteContainer loadOrCreate(WunderKisteDomain.ID domainID) {
        WunderKisteContainer wunderKisteContainer = new WunderKisteContainer(domainID);
        wunderKisteContainer.load();
        wunderKisteContainer.method_5489(container -> WunderKisteBlock.updateAllBoxes(container, false, true));
        return wunderKisteContainer;
    }

    public void saveAll() {
        this.containers.entrySet().forEach(e -> ((WunderKisteContainer)((Object)((Object)e.getValue()))).save());
    }

    public void onCloseServer() {
        Wunderreich.LOGGER.info("Unloading Cache for Wunderkiste");
        WUNDERKISTEN.unLoad();
    }

    public void onStartServer(class_7780<class_7659> registryAccess) {
        Wunderreich.LOGGER.info("Initializing Cache for Wunderkiste");
        this.containers.clear();
        WUNDERKISTEN.load(registryAccess);
    }

    public void onLevelsCreated(Map<class_5321<class_1937>, class_3218> levels) {
        Wunderreich.LOGGER.info("Assigning Levels to Wunderkiste in " + levels.size() + " levels.");
        WUNDERKISTEN.assignLevels(levels);
    }
}

