/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.filesystem;

import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.MountConstants;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.OpenOption;
import java.util.Set;

public interface WritableMount
extends Mount {
    public void makeDirectory(String var1) throws IOException;

    public void delete(String var1) throws IOException;

    public void rename(String var1, String var2) throws IOException;

    @Deprecated(forRemoval=true)
    public SeekableByteChannel openForWrite(String var1) throws IOException;

    @Deprecated(forRemoval=true)
    public SeekableByteChannel openForAppend(String var1) throws IOException;

    default public SeekableByteChannel openFile(String path, Set<OpenOption> options) throws IOException {
        if (options.equals(MountConstants.READ_OPTIONS)) {
            return this.openForRead(path);
        }
        if (options.equals(MountConstants.WRITE_OPTIONS)) {
            return this.openForWrite(path);
        }
        if (options.equals(MountConstants.APPEND_OPTIONS)) {
            return this.openForAppend(path);
        }
        throw new IOException("Unsupported mode");
    }

    public long getRemainingSpace() throws IOException;

    public long getCapacity();

    default public boolean isReadOnly(String path) throws IOException {
        return false;
    }
}

