/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.upgrades;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dan200.computercraft.impl.PlatformHelper;
import dan200.computercraft.impl.upgrades.SerialiserWithCraftingItem;
import dan200.computercraft.impl.upgrades.SimpleSerialiser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7924;
import org.jspecify.annotations.Nullable;

public abstract class UpgradeDataProvider<T extends UpgradeBase, R extends UpgradeSerialiser<? extends T>>
implements class_2405 {
    private final class_7784 output;
    private final String name;
    private final String folder;
    private final class_5321<class_2378<R>> registry;
    private @Nullable List<T> upgrades;

    protected UpgradeDataProvider(class_7784 output, String name, String folder, class_5321<class_2378<R>> registry) {
        this.output = output;
        this.name = name;
        this.folder = folder;
        this.registry = registry;
    }

    public final Upgrade<R> simple(class_2960 id, R serialiser) {
        if (!(serialiser instanceof SimpleSerialiser)) {
            throw new IllegalStateException(String.valueOf(serialiser) + " must be a simple() seriaiser.");
        }
        return new Upgrade<R>(id, serialiser, s -> {});
    }

    public final Upgrade<R> simpleWithCustomItem(class_2960 id, R serialiser, class_1792 item) {
        if (!(serialiser instanceof SerialiserWithCraftingItem)) {
            throw new IllegalStateException(String.valueOf(serialiser) + " must be a simpleWithCustomItem() serialiser.");
        }
        return new Upgrade<R>(id, serialiser, s -> s.addProperty("item", PlatformHelper.get().getRegistryKey(class_7924.field_41197, item).toString()));
    }

    protected abstract void addUpgrades(Consumer<Upgrade<R>> var1);

    public CompletableFuture<?> method_10319(class_7403 cache) {
        Path base = this.output.method_45971().resolve("data");
        HashSet seen = new HashSet();
        ArrayList upgrades = new ArrayList();
        ArrayList futures = new ArrayList();
        this.addUpgrades(upgrade -> {
            if (!seen.add(upgrade.id())) {
                throw new IllegalStateException("Duplicate upgrade " + String.valueOf(upgrade.id()));
            }
            JsonObject json = new JsonObject();
            json.addProperty("type", PlatformHelper.get().getRegistryKey(this.registry, upgrade.serialiser()).toString());
            upgrade.serialise().accept(json);
            futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)base.resolve(upgrade.id().method_12836() + "/" + this.folder + "/" + upgrade.id().method_12832() + ".json")));
            try {
                Object result = upgrade.serialiser().fromJson(upgrade.id(), json);
                upgrades.add(result);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                field_40831.error("Failed to parse {} {}", new Object[]{this.name, upgrade.id(), e});
            }
        });
        this.upgrades = Collections.unmodifiableList(upgrades);
        return class_156.method_652(futures);
    }

    public final String method_10321() {
        return this.name;
    }

    public final R existingSerialiser(class_2960 id) {
        UpgradeSerialiser result = (UpgradeSerialiser)PlatformHelper.get().getRegistryObject(this.registry, id);
        if (result == null) {
            throw new IllegalArgumentException("No such serialiser " + String.valueOf(this.registry));
        }
        return (R)result;
    }

    public List<T> getGeneratedUpgrades() {
        if (this.upgrades == null) {
            throw new IllegalStateException("Upgrades have not been generated yet");
        }
        return this.upgrades;
    }

    public record Upgrade<R extends UpgradeSerialiser<?>>(class_2960 id, R serialiser, Consumer<JsonObject> serialise) {
        public void add(Consumer<Upgrade<R>> add) {
            add.accept(this);
        }

        public Upgrade<R> requireMod(String modId) {
            return new Upgrade<R>(this.id, this.serialiser, json -> {
                PlatformHelper.get().addRequiredModCondition((JsonObject)json, modId);
                this.serialise.accept((JsonObject)json);
            });
        }
    }
}

