/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.monitor;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.mojang.blaze3d.platform.GlStateManager;
import dan200.computercraft.client.render.vbo.DirectBuffers;
import dan200.computercraft.client.render.vbo.DirectVertexBuffer;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import org.jspecify.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL31;

@Environment(value=EnvType.CLIENT)
public class MonitorRenderState
implements ClientMonitor.RenderState {
    @GuardedBy(value="allMonitors")
    private static final Set<MonitorRenderState> allMonitors = new HashSet<MonitorRenderState>();
    public long lastRenderFrame = -1L;
    public @Nullable class_2338 lastRenderPos = null;
    public int tboBuffer;
    public int tboTexture;
    public int tboUniform;
    public @Nullable DirectVertexBuffer backgroundBuffer;
    public @Nullable DirectVertexBuffer foregroundBuffer;

    public boolean createBuffer(MonitorRenderer renderer) {
        switch (renderer) {
            case TBO: {
                if (this.tboBuffer != 0) {
                    return false;
                }
                this.deleteBuffers();
                this.tboBuffer = DirectBuffers.createBuffer();
                DirectBuffers.setEmptyBufferData(35882, this.tboBuffer, 35044);
                this.tboTexture = GlStateManager._genTexture();
                GL11.glBindTexture((int)35882, (int)this.tboTexture);
                GL31.glTexBuffer((int)35882, (int)33330, (int)this.tboBuffer);
                GL11.glBindTexture((int)35882, (int)0);
                this.tboUniform = DirectBuffers.createBuffer();
                DirectBuffers.setEmptyBufferData(35345, this.tboUniform, 35044);
                this.addMonitor();
                return true;
            }
            case VBO: {
                if (this.backgroundBuffer != null) {
                    return false;
                }
                this.deleteBuffers();
                this.backgroundBuffer = new DirectVertexBuffer();
                this.foregroundBuffer = new DirectVertexBuffer();
                this.addMonitor();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMonitor() {
        Set<MonitorRenderState> set = allMonitors;
        synchronized (set) {
            allMonitors.add(this);
        }
    }

    private void deleteBuffers() {
        if (this.tboBuffer != 0) {
            DirectBuffers.deleteBuffer(35882, this.tboBuffer);
            this.tboBuffer = 0;
        }
        if (this.tboTexture != 0) {
            GlStateManager._deleteTexture((int)this.tboTexture);
            this.tboTexture = 0;
        }
        if (this.tboUniform != 0) {
            DirectBuffers.deleteBuffer(35345, this.tboUniform);
            this.tboUniform = 0;
        }
        if (this.backgroundBuffer != null) {
            this.backgroundBuffer.close();
            this.backgroundBuffer = null;
        }
        if (this.foregroundBuffer != null) {
            this.foregroundBuffer.close();
            this.foregroundBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.tboBuffer != 0 || this.backgroundBuffer != null) {
            Set<MonitorRenderState> set = allMonitors;
            synchronized (set) {
                allMonitors.remove(this);
            }
            this.deleteBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyAll() {
        Set<MonitorRenderState> set = allMonitors;
        synchronized (set) {
            Iterator<MonitorRenderState> iterator = allMonitors.iterator();
            while (iterator.hasNext()) {
                MonitorRenderState monitor = iterator.next();
                monitor.deleteBuffers();
                iterator.remove();
            }
        }
    }
}

