/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.menu;

import dan200.computercraft.core.apis.handles.ByteBufferChannel;
import dan200.computercraft.core.apis.transfer.TransferredFile;
import dan200.computercraft.core.apis.transfer.TransferredFiles;
import dan200.computercraft.core.input.ComputerInput;
import dan200.computercraft.core.input.UserComputerInput;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.computer.upload.FileSlice;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInputState
implements ServerInputHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServerInputState.class);
    private final class_1703 owner;
    private final ServerComputer computer;
    private final UserComputerInput input;
    private @Nullable UUID toUploadId;
    private @Nullable List<FileUpload> toUpload;

    public ServerInputState(class_1703 owner, ServerComputer computer) {
        this.owner = owner;
        this.computer = computer;
        this.input = computer.createComputerInput();
    }

    @Override
    public ComputerInput getComputerInput() {
        return this.input;
    }

    @Override
    public void startUpload(UUID uploadId, List<FileUpload> files) {
        this.toUploadId = uploadId;
        this.toUpload = files;
    }

    @Override
    public void continueUpload(UUID uploadId, List<FileSlice> slices) {
        if (this.toUploadId == null || this.toUpload == null || !this.toUploadId.equals(uploadId)) {
            LOG.warn("Invalid continueUpload call, skipping.");
            return;
        }
        for (FileSlice slice : slices) {
            slice.apply(this.toUpload);
        }
    }

    @Override
    public void finishUpload(class_3222 uploader, UUID uploadId) {
        if (this.toUploadId == null || this.toUpload == null || this.toUpload.isEmpty() || !this.toUploadId.equals(uploadId)) {
            LOG.warn("Invalid finishUpload call, skipping.");
            return;
        }
        ServerNetworking.sendToPlayer(this.finishUpload(uploader), uploader);
    }

    private UploadResultMessage finishUpload(class_3222 player) {
        if (this.toUpload == null) {
            return UploadResultMessage.error(this.owner, UploadResult.COMPUTER_OFF_MSG);
        }
        for (FileUpload upload : this.toUpload) {
            if (upload.checksumMatches()) continue;
            LOG.warn("Checksum failed to match for {}.", (Object)upload.getName());
            return UploadResultMessage.error(this.owner, (class_2561)class_2561.method_43471((String)"gui.computercraft.upload.failed.corrupted"));
        }
        this.computer.queueEvent("file_transfer", new Object[]{new TransferredFiles(this.toUpload.stream().map(x -> new TransferredFile(x.getName(), new ByteBufferChannel(x.getBytes()))).toList(), () -> {
            if (player.method_5805() && player.field_7512 == this.owner) {
                ServerNetworking.sendToPlayer(UploadResultMessage.consumed(this.owner), player);
            }
        })});
        return UploadResultMessage.queued(this.owner);
    }

    public void close() {
        this.input.releaseInputs();
    }
}

