/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import java.util.Locale;
import org.jspecify.annotations.Nullable;

public class TurtleToolCommand
implements TurtleCommand {
    private final TurtleVerb verb;
    private final InteractDirection direction;
    private final @Nullable TurtleSide side;

    public TurtleToolCommand(TurtleVerb verb, InteractDirection direction, @Nullable TurtleSide side) {
        this.verb = verb;
        this.direction = direction;
        this.side = side;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        TurtleCommandResult firstFailure = null;
        for (TurtleSide side : TurtleSide.values()) {
            ITurtleUpgrade upgrade;
            if (this.side != null && this.side != side || (upgrade = turtle.getUpgrade(side)) == null || !upgrade.getType().isTool()) continue;
            TurtleCommandResult result = upgrade.useTool(turtle, side, this.verb, this.direction.toWorldDir(turtle));
            if (result.isSuccess()) {
                switch (side) {
                    case LEFT: {
                        turtle.playAnimation(TurtleAnimation.SWING_LEFT_TOOL);
                        break;
                    }
                    case RIGHT: {
                        turtle.playAnimation(TurtleAnimation.SWING_RIGHT_TOOL);
                        break;
                    }
                    default: {
                        turtle.playAnimation(TurtleAnimation.WAIT);
                    }
                }
                return result;
            }
            if (firstFailure != null) continue;
            firstFailure = result;
        }
        return firstFailure != null ? firstFailure : TurtleCommandResult.failure("No tool to " + this.verb.name().toLowerCase(Locale.ROOT) + " with");
    }

    public static TurtleToolCommand attack(InteractDirection direction, @Nullable TurtleSide side) {
        return new TurtleToolCommand(TurtleVerb.ATTACK, direction, side);
    }

    public static TurtleToolCommand dig(InteractDirection direction, @Nullable TurtleSide side) {
        return new TurtleToolCommand(TurtleVerb.DIG, direction, side);
    }
}

