/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Min;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.audioplayer.PlayerManager;
import de.maxhenkel.audioplayer.Plugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

@Command(value={"audioplayer"})
public class PlayCommands {
    @RequiresPermission(value="audioplayer.play_command")
    @Command(value={"play"})
    public void play(CommandContext<class_2168> context, @Name(value="sound") UUID sound, @Name(value="location") class_243 location, @Name(value="range") @Min(value="0") float range) throws CommandSyntaxException {
        @Nullable class_3222 player = ((class_2168)context.getSource()).method_44023();
        VoicechatServerApi api = Plugin.voicechatServerApi;
        if (api == null) {
            return;
        }
        PlayerManager.instance().playLocational(api, ((class_2168)context.getSource()).method_9225(), location, sound, player, range, null, Integer.MAX_VALUE, true);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully played %s".formatted(sound)), false);
    }

    @RequiresPermission(value="audioplayer.play_command")
    @Command(value={"stop"})
    private static int stop(CommandContext<class_2168> context, @Name(value="sound") UUID sound) {
        UUID channelID = PlayerManager.instance().findChannelID(sound, true);
        if (channelID != null) {
            PlayerManager.instance().stop(channelID);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully stopped %s".formatted(sound)), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to stop, could not find sound with ID %s".formatted(sound)));
        return 0;
    }
}

